/* e_compon.cc
 *$Header: /al/acs/src/RCS/e_compon.cc,v 9.24 95/10/24 22:44:33 al Exp $
 * Base class for elements of a circuit
 */
#include "ap.h"
#include "e_compon.h"
#include "io.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	void	COMPONENT::parselabel(CS&);
//	int	COMPONENT::parsenodes(CS&,int);
//	void	COMPONENT::printnodes(int,int)const;
static	int	name2number(CS&);
static	char*	number2name(char*,int);
/*--------------------------------------------------------------------------*/
void COMPONENT::parselabel(CS& cmd)
{
  cmd.ctostr(label, LABELEN, TOKENTERM);
  label[0] = to_upper(label[0]);
}
/*--------------------------------------------------------------------------*/
/* parsenodes: parse circuit connections from input string
 * result in brh.
 * n array must hold at least numnodes+1
 * cnt updated.
 */
int COMPONENT::parsenodes(CS& cmd, int numnodes)
{
  int count = 0;
  int ii;
  for (ii = 0;  ii < numnodes;  ii++){
    n[ii].t = n[ii].e = name2number(cmd);
    if (n[ii].e != INVALIDNODE)
      count = ii+1;
  }
  n[ii].t = n[ii].e = INVALIDNODE;
  return count;
}
/*--------------------------------------------------------------------------*/
/* printnodes: print a node list
 */
void COMPONENT::printnodes(int where, int numnodes)const
{
  int ii;
  for (ii = 0;   ii < numnodes  &&  n[ii].e != INVALIDNODE;   ii++){
    char name[LABELEN+1];
    mprintf(where, " %s ", number2name(name,n[ii].e));
  }
}
/*--------------------------------------------------------------------------*/
/* name2number: convert node name to node number
 * returns node number
 * cnt updated
 */
static int name2number(CS& cmd)
{
  int test = cmd.index();
  int node = cmd.ctoi();
  return  (test == cmd.index())  ?  INVALIDNODE  :  node;
}
/*--------------------------------------------------------------------------*/
/* number2name: convert node number to node name
 * result in name (must be big enough)
 * returns name
 */
static char* number2name(char *name, int node)
{
  sprintf(name, "%d", node);
  return name;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
