/* classes: h_files */

#ifndef LVECTORSH
#define LVECTORSH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "__scm.h"



#define SCM_LVECTOR_KEY(x, n) (SCM_VELTS((SCM_VELTS(x)[0]))[n])

/* Some lvectors are type objects which describe other lvectors.
 * In those, element 0 is `scm_lvector_type' and the other elements
 * have these names:
 */
#define SCM_LV_USER_DATA (1)
#define SCM_LV_REF_FN (2)
#define SCM_LV_SET_FN (3)
#define SCM_LV_PRINT_FN (4)
#define SCM_LV_EQUAL_FN (5)
#define SCM_LV_ISA_FN (6)



#ifdef __STDC__
extern SCM scm_get_lvector_hook (SCM vec, int index);
extern SCM scm_lvector_isa_p (SCM vec, SCM keyvec);
extern SCM scm_lvector_set_x (SCM vec, SCM key, SCM index, SCM val, SCM rock);
extern SCM scm_lvector_poke_x (SCM vec, SCM index, SCM val);
extern SCM scm_lvector_ref (SCM vec, SCM key, SCM index);
extern SCM scm_lvector_ref2 (SCM vec, SCM key, SCM index, SCM rock);
extern SCM scm_lvector_peek (SCM vec, SCM index);
extern SCM scm_lvector_accessor (SCM type, SCM index);
extern SCM scm_lvector_modifier (SCM type, SCM index);
extern SCM scm_lock_vector_x (SCM vec);
extern SCM scm_unlock_vector_x (SCM vec);
extern SCM scm_lvector_keys (SCM vec);
extern SCM scm_lvector_p (SCM vec);
extern void scm_init_lvectors (void);

#else /* STDC */
extern SCM scm_get_lvector_hook ();
extern SCM scm_lvector_isa_p ();
extern SCM scm_lvector_set_x ();
extern SCM scm_lvector_poke_x ();
extern SCM scm_lvector_ref ();
extern SCM scm_lvector_ref2 ();
extern SCM scm_lvector_peek ();
extern SCM scm_lvector_accessor ();
extern SCM scm_lvector_modifier ();
extern SCM scm_lock_vector_x ();
extern SCM scm_unlock_vector_x ();
extern SCM scm_lvector_keys ();
extern SCM scm_lvector_p ();
extern void scm_init_lvectors ();

#endif /* STDC */





#endif  /* LVECTORSH */
