;;;; 	copyright (C) 1995 Free Software Foundation, Inc.
;;;; 
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;; 


;;; ----------------------------------------------------------------
;;; libguile.scm -- Basic guile interfaces
;;; 21 Dec 1994, Miles Bader <miles@eskimo.com>
;;; ----------------------------------------------------------------
;;;
(in-package guile)

(export-library guile (guile
		       guile-misc
		       time
		       vicinity
		       record
		       low-macros
		       defmacro
		       variable
		       system-timer-interface
		       system-error-interface
		       scheme
		       load
		       module
		       module-objects))

(in-module guile)

(export-interface time (current-time difftime offset-time))

(export-interface vicinity
		  (in-vicinity implementation-vicinity library-vicinity program-vicinity))

(export-interface record
		  (make-record-type record-constructor record-predicate record-accessor record-modifier))

(export-interface defmacro
		  (macroexpand
		   macroexpand-1
		   defmacro
		   define-macro
		   define-syntax-macro
		   defmacro:syntax-transformer
		   defmacro:transformer))

(export-interface low-macros
		  (procedure->syntax procedure->macro procedure->memoizing-macro))

(export-interface variable
		  (make-variable
		   make-undefined-variable
		   variable-ref
		   variable-set!
		   variable-bound?
		   builtin-variable))

(export-interface system-timer-interface
		  (ticks
		   alarm
		   ticks-interrupt
		   user-interrupt
		   alarm-interrupt))

(export-interface system-error-interface
		  (errno
		   perror
		   out-of-storage
		   could-not-open
		   end-of-program
		   hang-up
		   arithmetic-error))

(export-interface scheme
		  (;; characters
		   char?
		   char=? char-ci=? char<? char-ci<? char>? char-ci>? char<=? char-ci<=?
		   char>=? char-ci>=? char-alphabetic? char-numeric? char-whitespace?
		   char-upper-case? char-lower-case? char->integer integer->char char-upcase
		   char-downcase char-code-limit

		   ;; syntax
		   quote quasiquote unquote unquote-splicing
		   \ lambda and or if cond case define set! let let* letrec begin do 
		   delay force

		   ;; test
		   not boolean? eq? eqv? equal?

		   ;; lists
		   pair? cons car cdr set-car! set-cdr!
		   caar cadr cdar cddr caaar caadr cadar caddr cdaar cdadr cddar cdddr caaaar
		   caaadr caadar caaddr cadaar cadadr caddar cadddr cdaaar cdaadr cdadar
		   cdaddr cddaar cddadr cdddar cddddr
		   null? list? list length append reverse list-ref memq memv member assq assv
		   assoc list-tail string->list list->string delq! acons copy-tree append!

		   ;; symbols
		   symbol? symbol->string string->symbol

		   ;; numbers
		   number? complex? real? rational? integer? exact? inexact? = < > <= >= zero?
		   positive? negative? odd? even? max min + * - / abs quotient remainder
		   modulo gcd lcm numerator denominator floor ceiling truncate round
		   rationalize exp log sin cos tan asin acos atan sqrt expt make-rectangular
		   make-polar real-part imag-part magnitude angle exact->inexact
		   inexact->exact number->string string->number 1+ -1+ 1-

		   ;; strings
		   string? make-string string string-length string-ref string-set! string=?
		   string-ci=? string<? string-ci<? string>? string-ci>? string<=?
		   string-ci<=? string>=? string-ci>=? substring string-append
		   string-copy string-fill!

		   ;; vectors
		   vector? make-vector vector vector-length vector-ref vector-set!
		   vector->list list->vector vector-fill!

		   ;; procs
		   procedure? apply map for-each call-with-current-continuation 

		   ;; files
		   
		   
		   call-with-input-file call-with-output-file
		   input-port? output-port? open-input-file
		   open-output-file close-input-port close-output-port
		   eof-object? read read-char peek-char write display
		   newline write-char char-ready? with-input-from-file
		   with-output-to-file current-error-port force-output
		   call-with-input-string call-with-output-string
		   current-input-port current-output-port
		   file-exists? delete-file

		   ;; etc.
		   identity gentemp eval dynamic-wind catch throw error
		   ))


(export-interface load
		  (try-load-with-path
		   try-load
		   load-with-path
		   load
		   assert-load-verbosity
		   (%load-path %system-load-path)))

(export-interface guile-misc
		  (gc
		   (module:defined? defined?)
		   eval2 quit restart abort
		   verbose room
		   most-positive-fixnum
		   program-arguments getenv
		   system 
		   output-port-width output-port-height
		   software-type scheme-implementation-version scheme-implementation-type load))

(export-interface guile
		  guile-misc
		  time
		  vicinity
		  record
		  low-macros
		  defmacro
		  variable
		  system-timer-interface
		  system-error-interface
		  scheme
		  load
		  module)


(define-syntax-macro (module:defined? name)
  (module-bound? (current-module) name))

