// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _LYXFONT_H
#define _LYXFONT_H

struct LyXFont  {
  char family;
  char series;
  char shape;
  char size;
   
  char latex; /* a boolean flag */ 
  char bar;
};

extern char* roman_font_name;
extern char* sans_font_name;
extern char* typewriter_font_name;
extern char font_sizes[];
extern char* font_norm;

extern LyXFont GetLyXFont(char family, char series, char shape, char size, 
		   char latex, char bar);
extern int LyXStringWidth(LyXFont font, char *s);

inline
int FontEqual(LyXFont font1, LyXFont font2) {
  return (font1.family == font2.family 
	  && font1.series == font2.series
	  && font1.shape == font2.shape
	  && font1.size == font2.size
	  && font1.latex == font2.latex
	  && font1.bar == font2.bar);
}
#endif


