;; Copyright 1995 Crack dot Com,  All Rights reserved
;; See licensing information for more details on usage rights

(perm-space)

;; this is a simple check to see if they player has an engine version
;; capable of playing the game.  All games should at least check for version 1.10
;; because all version before that are beta and have known bugs.

(if (< (+ (* (major_version) 100) (minor_version)) 110)    ; require at least version 1.10
    (progn
      (print "Your engine is out of date.  This game requires version 1.1")
      (quit)))


(setq load_warn nil)
(if (not (load "lisp/common.lsp"))
    (progn
      (print "Please make sure you unzipped the game with the -d option")
      (print "so that all directories get created properly.")      
      (print "example : pkunzip -d abusXXXX.zip")      
      (quit)))
(setq load_warn T)

(if (not (get_option "-net"))   ;;  are we connecting to a server?
    (start_server))


;; this function is called at the end of every screen update
;; for death match we use this to display a list of players in the
;; game and the kills for each player

(defun display_player (player text_y)
  (if player
      (with_object player	
	(put_string (get_main_font) (+ (view_x1) 4) text_y 
		    (concatenate 'string (digstr (kills) 4) " '" (player_name) 
						     (if (local_player) 
							 "' <<"
						       "'"))
		    (aref player_text_color (player_number)))
	(display_player (next_focus player) (+ text_y (font_height (get_main_font)))))))


(defun post_render ()
  (if (not (edit_mode))      ; don't try this in edit mode
      (display_player (first_focus) (with_object (first_focus) (view_y1)))))

(load "lisp/chat.lsp")

(setq keep_backup T)                  ;; determines if Save
(setq load_warn nil)
(load "lastsave.lsp")
(load "lisp/english.lsp")             ;; load language specific stuff
(local_load "gamma.lsp")              ;; load gamma correction values if they have been saved

(if (not (load "hardness.lsp"))       ;; load hardness, if no file set to hard
    (setf difficulty        'hard))
(setq load_warn T)

; *********** Defaults **************************
(setf sfx_directory     "sfx/")
(load_big_font     "art/screen11.spe" "screen11")
(load_small_font   "art/letters.spe" "small_font")
(load_console_font "art/consfnt.spe" "fnt5x7")
(load_color_filter "art/back/backgrnd.spe")
(load_palette      "art/back/backgrnd.spe")
(setq normal_tint (def_tint "art/back/backgrnd.spe"))

(load_tiles "art/fore/foregrnd.spe"
	    "art/fore/techno.spe"
	    "art/fore/techno2.spe"
	    "art/fore/techno3.spe"
	    "art/fore/techno4.spe"
	    "art/fore/cave.spe"

	    "art/back/intro.spe"
	    "art/back/city.spe"
	    "art/back/tech.spe"
	    "art/back/cave.spe"
	    "art/back/backgrnd.spe")

(setq load_warn nil)
(load "register/tiles.lsp")       ;; load up registered artwork if it's there
(setq load_warn T)

(setf title_screen      '("art/title.spe" . "title_screen"))
(setf logo              '("art/title.spe" . "cdc_logo"))
(setq help_screens '("art/help.spe" "sell1" "sell2" "sell4"))


(load "lisp/options.lsp")     

(load "lisp/input.lsp")
(load "lisp/userfuns.lsp")
(load "lisp/sfx.lsp")
(load "lisp/gates.lsp")
(load "lisp/duong.lsp")
(load "lisp/ant.lsp")
(load "lisp/people.lsp")
(load "lisp/weapons.lsp")
(load "lisp/explo.lsp")
(load "lisp/platform.lsp")
(load "lisp/guns.lsp")
(load "lisp/jugger.lsp")
(load "lisp/flyer.lsp")
(load "lisp/teleport.lsp")
(load "lisp/general.lsp")
(load "lisp/powerup.lsp")
(load "lisp/doors.lsp")
(load "lisp/light.lsp")
(load "lisp/ladder.lsp")
(load "lisp/switch.lsp")

(if (not (get_option "-f"))
    (set_first_level "levels/netshar1.spe"))


(setq bad_guy_list (list DARNEL ANT_ROOF TRACK_GUN SPRAY_GUN JUGGER ROB1 WHO ROCKET FLYER GREEN_FLYER BOSS_ANT))

(gc)              ;; garbage collection perm space
(tmp-space)       ;; execute game code in tmp space which is not GC'ed
(create_players DARNEL)


