#ifndef MP_KEYMAP_H
#define MP_KEYMAP_H
/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
********************************************************************/
/*
**  keymap.h
*/

typedef enum {
    /* 0 */
    CK_at, CK_A, CK_B, CK_C, CK_D, CK_E, CK_F, CK_G, CK_H,
    CK_I, CK_J, CK_K, CK_L, CK_M, CK_N, CK_O, CK_P, CK_Q,
    CK_R, CK_S, CK_T, CK_U, CK_V, CK_W, CK_X, CK_Y, CK_Z,
    CK_bracketleft, CK_backslash, CK_bracketright, CK_circum,
    CK_underscore,

    /* 1 */
    K_space, K_exclam, K_quotedbl, K_numbersign, K_dollar, K_percent,
    K_ampersand, K_quoteright, K_parenleft, K_parenright, K_asterisk,
    K_plus, K_comma, K_minus, K_period, K_slash, K_0, K_1, K_2,
    K_3, K_4, K_5, K_6, K_7, K_8, K_9, K_colon, K_semicolon,
    K_less, K_equal, K_greater, K_question,

    /* 2 */
    K_at, K_A, K_B, K_C, K_D, K_E, K_F, K_G, K_H,
    K_I, K_J, K_K, K_L, K_M, K_N, K_O, K_P, K_Q,
    K_R, K_S, K_T, K_U, K_V, K_W, K_X, K_Y, K_Z,
    K_bracketleft, K_backslash, K_bracketright, K_circum,
    K_underscore,

    /* 3 */
    K_quoteleft, K_a, K_b, K_c, K_d, K_e, K_f, K_g, K_h,
    K_i, K_j, K_k, K_l, K_m, K_n, K_o, K_p, K_q,
    K_r, K_s, K_t, K_u, K_v, K_w, K_x, K_y, K_z,
    K_braceleft, K_bar, K_braceright, K_tilde,
    K_nobreakspace,

    /* 4 */
    CMK_at, CMK_A, CMK_B, CMK_C, CMK_D, CMK_E, CMK_F, CMK_G, CMK_H,
    CMK_I, CMK_J, CMK_K, CMK_L, CMK_M, CMK_N, CMK_O, CMK_P, CMK_Q,
    CMK_R, CMK_S, CMK_T, CMK_U, CMK_V, CMK_W, CMK_X, CMK_Y, CMK_Z,
    CMK_bracketleft, CMK_backslash, CMK_bracketright, CMK_circum,
    CMK_underscore,

    /* 5 */
    MK_space, MK_exclam, MK_quotedbl, MK_numbersign, MK_dollar, MK_percent,
    MK_ampersand, MK_quoteright, MK_parenleft, MK_parenright, MK_asterisk,
    MK_plus, MK_comma, MK_minus, MK_period, MK_slash, MK_0, MK_1, MK_2,
    MK_3, MK_4, MK_5, MK_6, MK_7, MK_8, MK_9, MK_colon, MK_semicolon,
    MK_less, MK_equal, MK_greater, MK_question,

    /* 6 */
    MK_at, MK_A, MK_B, MK_C, MK_D, MK_E, MK_F, MK_G, MK_H,
    MK_I, MK_J, MK_K, MK_L, MK_M, MK_N, MK_O, MK_P, MK_Q,
    MK_R, MK_S, MK_T, MK_U, MK_V, MK_W, MK_X, MK_Y, MK_Z,
    MK_bracketleft, MK_backslash, MK_bracketright, MK_circum,
    MK_underscore,

    /* 7 */
    CMK_space, CMK_exclam, CMK_quotedbl, CMK_numbersign, CMK_dollar,
    CMK_percent, CMK_ampersand, CMK_quoteright, CMK_parenleft,
    CMK_parenright, CMK_asterisk, CMK_plus, CMK_comma, CMK_minus,
    CMK_period, CMK_slash, CMK_0, CMK_1, CMK_2, CMK_3, CMK_4, CMK_5,
    CMK_6, CMK_7, CMK_8, CMK_9, CMK_colon, CMK_semicolon, CMK_less,
    CMK_equal, CMK_greater, CMK_question,

    /* 8 */
    CK_space, CK_exclam, CK_quotedbl, CK_numbersign, CK_dollar,
    CK_percent, CK_ampersand, CK_quoteright, CK_parenleft,
    CK_parenright, CK_astrisk, CK_plus, CK_comma, CK_minus,
    CK_period, CK_slash, CK_0, CK_1, CK_2, CK_3, CK_4, CK_5,
    CK_6, CK_7, CK_8, CK_9, CK_colon, CK_semicolon, CK_less,
    CK_equal, CK_greater, CK_question,

    /* 9 */
    CK_quoteleft, CK_backspace, CK_tab, CK_linefeed, CK_clear, CK_escape,
    CK_return, CK_reset, CK_system, CK_user, CK_clearline, CK_insertline,
    CK_deleteline, CK_insertchar, CK_deletechar, CK_backtab, CK_kp_backtab,
    CK_braceleft = CK_quoteleft+27, CK_bar, CK_braceright, CK_tilde,
    CK_nobreakspace,

    /* 10 */
    MK_quoteleft, MK_backspace, MK_tab, MK_linefeed, MK_clear, MK_escape,
    MK_return, MK_reset, MK_system, MK_user, MK_clearline, MK_insertline,
    MK_deleteline, MK_insertchar, MK_deletechar, MK_backtab, MK_kp_backtab,
    MK_braceleft = MK_quoteleft+27, MK_bar, MK_braceright, MK_tilde,
    MK_nobreakspace,

    /* 11 */
    CMK_quoteleft, CMK_backspace, CMK_tab, CMK_linefeed, CMK_clear, CMK_escape,
    CMK_return, CMK_reset, CMK_system, CMK_user, CMK_clearline,
    CMK_insertline, CMK_deleteline, CMK_insertchar, CMK_deletechar,
    CMK_backtab, CMK_kp_backtab,
    CMK_braceleft = CMK_quoteleft+27, CMK_bar, CMK_braceright, CMK_tilde,
    CMK_nobreakspace,

    /* 12 */
    K_F1, K_F2, K_F3, K_F4, K_F5, K_F6, K_F7, K_F8, K_F9, K_F10,
    K_F11, K_F12, K_F13, K_F14, K_F15, K_F16, K_F17, K_F18, K_F19, K_F20,
    K_F21, K_F22, K_F23, K_F24, K_F25, K_F26, K_F27, K_F28, K_F29, K_F30,
    K_F31, K_F32,

    /* 13 */
    K_F33, K_F34, K_F35, K_home, K_left, K_up, K_right, K_down, K_prior,
    K_next, K_end, K_begin, K_PF1, K_PF2, K_PF3, K_PF4, K_delete, K_pause,
    K_scrolllock, K_multikey, K_select, K_print, K_execute, K_insert,
    K_dummy, K_undo, K_redo, K_menu, K_find, K_cancel, K_help, K_break,

    /* 14 */
    CK_F1, CK_F2, CK_F3, CK_F4, CK_F5, CK_F6, CK_F7, CK_F8, CK_F9, CK_F10,
    CK_F11, CK_F12, CK_F13, CK_F14, CK_F15, CK_F16, CK_F17, CK_F18, CK_F19,
    CK_F20, CK_F21, CK_F22, CK_F23, CK_F24, CK_F25, CK_F26, CK_F27, CK_F28,
    CK_F29, CK_F30, CK_F31, CK_F32,

    /* 15 */
    CK_F33, CK_F34, CK_F35, CK_home, CK_left, CK_up, CK_right, CK_down,
    CK_prior, CK_next, CK_end, CK_begin, CK_PF1, CK_PF2, CK_PF3, CK_PF4,
    CK_delete, CK_pause, CK_scrolllock, CK_multikey, CK_select, CK_print,
    CK_execute, CK_insert, CK_dummy, CK_undo, CK_redo, CK_menu, CK_find,
    CK_cancel, CK_help, CK_break,

    /* 16 */
    CMK_F1, CMK_F2, CMK_F3, CMK_F4, CMK_F5, CMK_F6, CMK_F7, CMK_F8, CMK_F9,
    CMK_F10, CMK_F11, CMK_F12, CMK_F13, CMK_F14, CMK_F15, CMK_F16, CMK_F17,
    CMK_F18, CMK_F19, CMK_F20, CMK_F21, CMK_F22, CMK_F23, CMK_F24, CMK_F25,
    CMK_F26, CMK_F27, CMK_F28, CMK_F29, CMK_F30, CMK_F31, CMK_F32,

    /* 17 */
    CMK_F33, CMK_F34, CMK_F35, CMK_home, CMK_left, CMK_up, CMK_right,
    CMK_down, CMK_prior, CMK_next, CMK_end, CMK_begin, CMK_PF1, CMK_PF2,
    CMK_PF3, CMK_PF4, CMK_delete, CMK_pause, CMK_scrolllock, CMK_multikey,
    CMK_select, CMK_print, CMK_execute, CMK_insert, CMK_dummy, CMK_undo,
    CMK_redo, CMK_menu, CMK_find, CMK_cancel, CMK_help, CMK_break,

    /* 18 */
    MK_F1, MK_F2, MK_F3, MK_F4, MK_F5, MK_F6, MK_F7, MK_F8, MK_F9, MK_F10,
    MK_F11, MK_F12, MK_F13, MK_F14, MK_F15, MK_F16, MK_F17, MK_F18, MK_F19,
    MK_F20, MK_F21, MK_F22, MK_F23, MK_F24, MK_F25, MK_F26, MK_F27, MK_F28,
    MK_F29, MK_F30, MK_F31, MK_F32,

    /* 19 */
    MK_F33, MK_F34, MK_F35, MK_home, MK_left, MK_up, MK_right, MK_down,
    MK_prior, MK_next, MK_end, MK_begin, MK_PF1, MK_PF2, MK_PF3, MK_PF4,
    MK_delete, MK_pause, MK_scrolllock, MK_multikey, MK_select, MK_print,
    MK_execute, MK_insert, MK_dummy, MK_undo, MK_redo, MK_menu, MK_find,
    MK_cancel, MK_help, MK_break,

    /* 20 */
    SK_F1, SK_F2, SK_F3, SK_F4, SK_F5, SK_F6, SK_F7, SK_F8, SK_F9, SK_F10,
    SK_F11, SK_F12, SK_F13, SK_F14, SK_F15, SK_F16, SK_F17, SK_F18, SK_F19,
    SK_F20, SK_F21, SK_F22, SK_F23, SK_F24, SK_F25, SK_F26, SK_F27, SK_F28,
    SK_F29, SK_F30, SK_F31, SK_F32,

    /* 21 */
    SK_F33, SK_F34, SK_F35, SK_home, SK_left, SK_up, SK_right, SK_down,
    SK_prior, SK_next, SK_end, SK_begin, SK_PF1, SK_PF2, SK_PF3, SK_PF4,
    SK_delete, SK_pause, SK_scrolllock, SK_multikey, SK_select, SK_print,
    SK_execute, SK_insert, SK_dummy, SK_undo, SK_redo, SK_menu, SK_find,
    SK_cancel, SK_help, SK_break,

    /* 22 */
    NOTATION_KEY, K_backspace, K_tab, K_linefeed, K_clear, K_escape,
    K_return, K_reset, K_system, K_user, K_clearline, K_insertline,
    K_deleteline, K_insertchar, K_deletechar, K_backtab, K_kp_backtab,
    SYMBOL_KEY = NOTATION_KEY+27, MAP_string, MAP_integer, MAP_notadef,
    MAP_phindex,

    /* 23 */
    MAP_basic, SK_backspace, SK_tab, SK_linefeed, SK_clear, SK_escape,
    SK_return, SK_reset, SK_system, SK_user, SK_clearline, SK_insertline,
    SK_deleteline, SK_insertchar, SK_deletechar, SK_backtab, SK_kp_backtab,
    WMSELECT = MAP_basic+27, DBLCLICK, MAP_1, MAP_2, NO_KEY

} KEYCODE;


#define max_keycode  (NO_KEY + 1)
typedef enum { EDITMAP, STRINGMAP, DEFINEMAP } MAPTYPE;


typedef void (*PFKI)(KEYCODE, Index);
typedef PFKI FUNCMAP[512];

extern KEYCODE event2code(void *event);
extern Bool    interrupted(void);
extern void    call_func( KEYCODE key);
extern void    add_key(int mapkey, KEYCODE defkey, int funcnr, Index arg);
extern void    remove_key(int mapkey, KEYCODE undefkey);
extern void    print_key( KEYCODE keycode, Index arg);
extern void    reset_map( KEYCODE keycode, Index arg);
extern void    construct_argument( KEYCODE keycode, Index arg);
extern void    construct_string(char *cm, char *def, void (*func)(char*));
extern void    use_map(KEYCODE mapkey, Index arg);
extern void    use_map_string(KEYCODE mapkey, Index arg);
extern void    reset_map(KEYCODE mapkey, Index arg);
extern void    push_input(void);
extern void    pop_input(void);
extern void    keymap_init(void);
extern int     new_map(char *desc);
extern int     add_func(PFKI func, char *desc);
extern char*   get_string_arg(int nr);
extern Bool    keypath_exist(char *name);
extern void    load_keypath(void);
#endif
