/*
 **************************************************************************
 *
 * General header file for utility programs
 *
 * Module:  utility.h
 * Purpose: General definitions for utility programs
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/* Define for debugging output */
#undef DEBUG


#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif


/*
 * Define a 16 bit unsigned integer type.
 */
#include <limits.h>
#if CHAR_BIT != 8
#error Invalid character size, has to be 8 bits per byte
#endif
#if USHRT_MAX == 0xffff
#define USHORT	unsigned short
#else
#if UINT_MAX == 0xffff
#define USHORT	unsigned int
#else
#if ULONG_MAX == 0xffff
#define USHORT	unsigned long
#else
#error No 16 bit integer type available on your system
#endif
#endif
#endif


/* Macro to swap two bytes in a short */
#define swapbytes(a)	((((USHORT)(a) & 0x00ff) << 8) | (((USHORT)(a) & 0xff00) >> 8))


/* Define byte order of development host */
#ifdef MSDOS
#define __BYTE_ORDER	1234
#else
#ifndef __BYTE_ORDER
#include <endian.h>
#if defined(BYTE_ORDER) && !defined(__BYTE_ORDER)
#define __BYTE_ORDER	BYTE_ORDER		/* for BSDish systems */
#endif
#ifndef __BYTE_ORDER
#error Need specification of endiness
#endif
#endif
#endif

#ifndef __LITTLE_ENDIAN
#ifdef LITTLE_ENDIAN
#define __LITTLE_ENDIAN	LITTLE_ENDIAN
#else
#define __LITTLE_ENDIAN	1234
#endif
#endif
#ifndef __BIG_ENDIAN
#ifdef BIG_ENDIAN
#define __BIG_ENDIAN	BIG_ENDIAN
#else
#define __BIG_ENDIAN	1234
#endif
#endif


/*
 * Intel systems are little endian, and these utility programs are designed
 * to create files for intel systems. So define the target platform to be
 * little endian.
 */
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define htot(a)		(a)
#define ttoh(a)		(a)
#else
#if __BYTE_ORDER != __BIG_ENDIAN
#error Invalid byte order, has to be little or big endian
#endif
#define htot(a)		swapbytes(a)
#define ttoh(a)		swapbytes(a)
#endif


