/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  ip.h
 * Purpose: Definitions for implementing the internet protocol
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * IP protocols:
 */
#define IPPROTO_ICMP	1	/* Internet Control Message Protocol	*/
#define IPPROTO_IGMP	2	/* Internet Gateway Management Protocol */
#define IPPROTO_TCP	6	/* Transmission Control Protocol	*/
#define IPPROTO_EGP	8	/* Exterior Gateway Protocol		*/
#define IPPROTO_PUP	12	/* PUP protocol				*/
#define IPPROTO_UDP	17	/* User Datagram Protocol		*/

#define IPPROTO_NUM	18	/* Maximum number of IP protocols	*/



/*
 **************************************************************************
 *
 * IP header structure
 */
struct iphdr {
	unsigned char  ip_ihl_version;
	unsigned char  ip_tos;
	unsigned short ip_tot_len;
	unsigned short ip_id;
	unsigned short ip_frag_off;
	unsigned char  ip_ttl;
	unsigned char  ip_protocol;
	unsigned short ip_check;
	unsigned long  ip_saddr;
	unsigned long  ip_daddr;
};



/*
 **************************************************************************
 *
 * Miscellaneous defines. Note that the maximum receive packet size has
 * to be smaller or equal to the maximum packet size for the packet
 * driver (see pktpriv.inc).
 */
#define IP_TTL		255		/* 255 seconds TTL for each pkt	*/
#define IP_RECV_SIZE	1024		/* Maximum receive packet size	*/
#define IP_SEND_SIZE	576		/* Maximum send packet size	*/

#define IP_VERSION	4		/* IP version number		*/
#define IP_MIN_HSIZE	20		/* Minimum size of IP header	*/
#define IP_STD_TOS	0		/* Standard type of service	*/

