/*
  Copyright (C) 1997  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

/* Callbacks */

void doConnect(FL_OBJECT *, long);
void doInterrupt(FL_OBJECT *, long);
void doDisconnect(FL_OBJECT *, long);
void doQuit(FL_OBJECT *, long);
void doOptions(FL_OBJECT *, long);
void doHelp(FL_OBJECT *, long);
void doAutoRedial(FL_OBJECT *, long);

void doTelNoInput(FL_OBJECT *, long);
void doAccountInput(FL_OBJECT *, long);
void doPasswdInput(FL_OBJECT *, long);
void doAccountOK(FL_OBJECT *, long);
void doAccountCancel(FL_OBJECT *, long);

void doRetryInput(FL_OBJECT *, long);
void doDelayInput(FL_OBJECT *, long);
void doScriptInput(FL_OBJECT *, long);
void doDialOK(FL_OBJECT *, long);
void doDialCancel(FL_OBJECT *, long);

void doISPPick(FL_OBJECT *, long);
void doISPPickNEdit(FL_OBJECT *, long);
void doISPNameEdit(FL_OBJECT *, long);
void doISPOK(FL_OBJECT *, long);
void doISPCancel(FL_OBJECT *, long);

void doISPNameInput(FL_OBJECT *, long);
void doISPNameEditOK(FL_OBJECT *, long);
void doISPNameEditCancel(FL_OBJECT *, long);

void doExitOK(FL_OBJECT *, long);
void doExitCancel(FL_OBJECT *, long);

void doAboutOK(FL_OBJECT *, long);
void doHelpInfoOK(FL_OBJECT *, long);


/* Forms and Objects */

#define OPTIONS_ISP     1
#define OPTIONS_ACCOUNT 2
#define OPTIONS_DIALING 3
#define HELP_ABOUT 1
#define HELP_GENERAL 2

typedef struct {
	FL_FORM *topFrame;
	FL_OBJECT *conButton;
	FL_OBJECT *intButton;
	FL_OBJECT *disButton;
	FL_OBJECT *quitButton;
	FL_OBJECT *optMenu;
	FL_OBJECT *hlpMenu;
	FL_OBJECT *lstBrowser;
	FL_OBJECT *timeText;
	FL_OBJECT *speedText;
	FL_OBJECT *IPText;
	FL_OBJECT *statusText;
	FL_OBJECT *topIcon;
	FL_OBJECT *ISPText;
	FL_OBJECT *autoRedial;
	void *vdata;
	long ldata;
} FD_topFrame;
FD_topFrame * create_form_topFrame(void);

typedef struct {
	FL_FORM *accountInfo;
	FL_OBJECT *telInput;
	FL_OBJECT *accInput;
	FL_OBJECT *pswInput;
	FL_OBJECT *accOK;
	FL_OBJECT *accCancel;
	void *vdata;
	long ldata;
} FD_accountInfo;
FD_accountInfo * create_form_accountInfo(void);

typedef struct {
	FL_FORM *dialInfo;
	FL_OBJECT *rtrInput;
	FL_OBJECT *dlyInput;
	FL_OBJECT *scriptLine[MAXNUM_SLINES];
	FL_OBJECT *dialOK;
	FL_OBJECT *dialCancel;
	void *vdata;
	long ldata;
} FD_dialInfo;
FD_dialInfo * create_form_dialInfo(void);

typedef struct {
	FL_FORM *ISPInfo;
	FL_OBJECT *ISPBrowser;
	FL_OBJECT *ISPOK;
	FL_OBJECT *ISPCancel;
	FL_OBJECT *ISPNameEdit;
	void *vdata;
	long ldata;
} FD_ISPInfo;
FD_ISPInfo * create_form_ISPInfo(void);

typedef struct {
	FL_FORM *renameISP;
	FL_OBJECT *ISPNameInput;
	FL_OBJECT *ISPNameEditOK;
	FL_OBJECT *ISPNameEditCancel;
	void *vdata;
	long ldata;
} FD_renameISP;
FD_renameISP * create_form_renameISP(void);

typedef struct {
	FL_FORM *aboutInfo;
	FL_OBJECT *aboutOK;
	void *vdata;
	long ldata;
} FD_aboutInfo;
FD_aboutInfo * create_form_aboutInfo(void);

typedef struct {
	FL_FORM *exitDialog;
	FL_OBJECT *exitOK;
	FL_OBJECT *exitCancel;
	void *vdata;
	long ldata;
} FD_exitDialog;
FD_exitDialog * create_form_exitDialog(void);

typedef struct {
	FL_FORM *helpInfo;
	FL_OBJECT *helpBrowser;
	FL_OBJECT *helpInfoOK;
	void *vdata;
	long ldata;
} FD_helpInfo;
FD_helpInfo * create_form_helpInfo(void);


/* The data file structure for all xisp options */

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[MAXNUM_SLINES][MAXLEN_SLINE+1];
} xisprc_t;

#define XISPRC_DEFAULT {{0},0,{0},{0},MAXNUM_RETRY,MAXSEC_DELAY,0,{{0}},0,{{0}}}

/* Other xISP defines */

#define BU_INTERVAL  2.0	/* check dialer output every 2 seconds */
#define CT_INTERVAL  5.0	/* update connection time every 5 seconds */
#define SP_INTERVAL 15.0	/* check link status every 15 seconds */

#define DISCONNECTED  0		/* to specify xISP state */
#define DIALING       1
#define CONNECTED     2

#define EMPTY_TIME "00:00:00"
#define EMPTY_IP    "---.---.---.---"
#define EMPTY_SPEED "--,---"

#define RUNDIR "/var/run"	/* where the spawned pppd PID is saved */

