/* hcon.h -- header data for hcon.c (heightfield-convert)   jpb 7/15/95 */

#ifdef BIG_FLOAT
#define NUM_FMT 1
#else
#define NUM_FMT 0       /* 0 IEEE Little Endian (80x86, DEC Risc) */
#endif                  /* 1 IEEE Big Endian (SPARC, SGI, Motorola, etc.) */

#define PREC 1          /* storing Matlab file as floats rather than longs */
#define PTYPE float     /* internal representation of float numbers */
#define PIXTYPE unsigned char   /* single-byte pixels */
#define PIXMAX 255
#define BYTE unsigned char
#define U unsigned int
#define D double

#define Boolean int
#define FALSE 0
#define TRUE 1

#define PGM  0          /* PGM ascii type (arbitrary) */
#define TGA  1          /* POV-Ray 2.2 TGA heightfield format 16-bit */
#define PNG  2          /* PNG format (not yet supported) */
#define PG8  3          /* binary PGM format 8-bit */
#define OCT  4          /* Octave ascii format (arbitrary) */
#define MAT  5          /* Matlab Level 1.0 binary format 32bit float */
#define GIF  6          /* CompuServe (tm) GIF format 8-bit */
#define POT  7          /* Fractint, PoV-Ray "continuous potential" 16-bit */

#define MAX_PIXVAL 65536              /* ascii integer output max value */

#define Eh(vv, xq, yq)  vv[((yq) * (xsize+2)) + xq]  /* elmt of hf array */
#define Ehn(vv, xq, yq) vv[((yq+1)*(xsize+2))+(xq+1)] /* hf indexed +1 */

#define El(vv, xq, yq)  vv[((yq) * xsize) + xq]  /* elmt of array */
#define El2(vv, xq, yq) vv[((yq) * xsize2)+ xq]  /* elmt of 2nd array */
#define El3(vv, xq, yq) vv[((yq) * xsize3)+ xq]  /* elmt of 3rd array */

#define Elr(im, xq, yq)  im.r[((yq) * im.xsize) + xq]  /* red pixel in arr. */
#define Elg(im, xq, yq)  im.g[((yq) * im.xsize) + xq]  /* grn pixel in arr. */
#define Elb(im, xq, yq)  im.b[((yq) * im.xsize) + xq]  /* blu pixel in arr. */

#define Elrp(im, xq, yq)  im->r[((yq) * im->xsize) + xq]  /* red pixel in arr. */
#define Elgp(im, xq, yq)  im->g[((yq) * im->xsize) + xq]  /* grn pixel in arr. */
#define Elbp(im, xq, yq)  im->b[((yq) * im->xsize) + xq]  /* blu pixel in arr. */

			/* Matlab Level 1.0 format data file header */
typedef struct {
	long type;      /* type */
	long mrows;     /* row dimension */
	long ncols;     /* column dimension */
	long imagf;     /* flag indicating imag part */
	long namelen;    /* name length (including NULL) */
} Fmatrix;

/*
 * Gimp-specific structure
 */
typedef struct _gimp_active_area {
	int	upper_left_x;
	int	upper_left_y;
	int	lower_right_x;
	int	lower_right_y;
}GIMP_ACTIVE_AREA;

			/* 3 color-plane image */
typedef struct CItype {   
	PIXTYPE *r, *g, *b;
	U xsize, ysize;
	GIMP_ACTIVE_AREA	active;		/* modification for use with Gimp */
} Cimg;


void hf_print();                        /* print out hf array to stdout */


