
/* colormap analysis filter for the Gimp
 * Jim GEUTHER
 *
 * V1.00
 *
 * This filter performs some colormap analysis and displays
 * the results on stdout.
 *
 */


#include "gimp.h"


static char *prog_name;
static long amount = 9;
static int dialog_ID;

static void anal(Image image);

int
main (argc, argv)
     int argc;
     char *argv[];
{
Image	image;
  /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
	if(image=gimp_get_input_image(0)) {
		switch(gimp_image_type(image)) {
		case INDEXED_IMAGE :
			anal(image);
			break;
		default :
			gimp_message("cmapanal: can only operate on indexed color images");
			break;
		}
		gimp_free_image(image);
	}			
       /* Quit
       */
      gimp_quit ();
    }

  return 0;
}

static void anal(
Image	image
)
{

long	colors,ix;
unsigned char	*cmap,*cptr;

/* Get number of colors */
colors=gimp_image_colors(image);
printf("%s: image has %ld colors\n",prog_name,colors);
cmap=(unsigned char *)gimp_image_cmap(image);

for(ix=0,cptr=cmap;ix<colors;ix++) {
	printf("%s: r=%d, g=%d, b=%d\n",prog_name,*cptr++,*cptr++,*cptr++);
}	

return;
}



