/* tr_clear.c  93.12.21
 * Copyright 1983-1992   Albert Davis
 * Support for mark and unmark commands
 * In this file to keep diff from going nuts.
 */
#include "ecah.h"
#include "nodestat.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void trkeep(void);
	void trestor(void);
	void cmd_mark(void);
	void cmd_unmark(void);
/*--------------------------------------------------------------------------*/
extern double last_time;		/* time corresp to last voltage	    */
extern struct nodestuff ns;
extern const struct status stats;
extern const double trtime0;		/* time at this iteration	    */
static int keepold;			/* flag: keep old data		    */
/*--------------------------------------------------------------------------*/
void trkeep(void)
{
 if (!keepold){
    int ii;
    for (ii = 1;  ii <= stats.total_nodes;  ii++){
       ns.vdc[ii] = ns.v0[ii];
    }
    last_time = (trtime0>0.) ? trtime0 : 0.;
 }
}
/*--------------------------------------------------------------------------*/
void trestor(void)
{
 int ii;
 for (ii = 1;  ii <= stats.total_nodes;  ii++){
    ns.v0[ii] = ns.vdc[ii];
 }
}
/*--------------------------------------------------------------------------*/
void cmd_mark(void)
{
 keepold = YES;
}
/*--------------------------------------------------------------------------*/
void cmd_unmark(void)
{
 keepold= NO;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
