/* dealloc.c  94.11.20
 * Copyright 1983-1992   Albert Davis
 * Deallocates all heap space except the main parts list
 */
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "nodestat.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	dealloc(int);
/*--------------------------------------------------------------------------*/
extern double last_time;
extern double **rerow, **imrow;		/* array of row pointers	    */
extern double **recol, **imcol;		/* array of column pointers	    */
extern double *reals, *imags;		/* big array allocation bases	    */
extern struct nodestat *nstat;	        /* node status flags		    */
extern struct nodestuff ns;
/*--------------------------------------------------------------------------*/
void dealloc(int all)
{
 if (all){
    last_time = 0.;
    qfree((void**)&nstat);
    qfree((void**)&ns.basnode);
    qfree((void**)&ns.nm);
    qfree((void**)&ns.vdc);
 }
 qfree((void**)&rerow);
 qfree((void**)&imrow);
 qfree((void**)&recol);
 qfree((void**)&imcol);
 qfree((void**)&reals);
 qfree((void**)&imags);
 qfree((void**)&ns.i);
 qfree((void**)&ns.v0);
 qfree((void**)&ns.vt1);
 qfree((void**)&ns.fw);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
