/* d_vccs.c  94.12.10
 * Copyright 1983-1992   Albert Davis
 * functions for vccs
 */
#include "ecah.h"
#include "branch.h"
#include "mode.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
static 	int	tr_vccs(branch_t*);
static 	void	ac_vccs(branch_t*);
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
functions_t dev_vccs = {
   (generic_t*)NULL,	/* x */
   sizeof(functions_t),	/* ssize */
   sizeof(branch_t),	/* elementsize */
   (functions_t*)NULL,	/* super */
   4, 			/* numnodes */
   rnTWOPORT,		/* refnode */
   rnTWOPORT,		/* isdevice */
   create_std,		/* create */
   copy_std,		/* copy */
   parse_std,		/* parse */
   print_std,		/* print */
   NULL,		/* expand */
   probe_std,		/* probe */
   tr_probe_std,	/* tr_probe */
   ac_probe_std,	/* ac_probe */
   xprobe_std,		/* xprobe */
   tr_vccs,		/* dotr */
   unloadactive,	/* untr */
   ac_vccs,		/* doac */
   trfix1,		/* trfun1 */
   trfix0,		/* trfun0 */
   acfix,		/* acfun */
   NULL,		/* tr_guess */
   NULL,		/* tr_advance */
   NULL			/* tr_review */
};
/*--------------------------------------------------------------------------*/
static int tr_vccs(branch_t *brh)
{
 brh->m0.x = tr_volts_limited(&(brh->n[IN1]),&(brh->n[IN2]));
 brh->y0.x = brh->m0.x;
 if (brh->f->trfun1){
    (*brh->f->trfun1)(brh);
    brh->m0.c0 = brh->y0.f0 - brh->y0.x * brh->y0.f1;
 }else{
    brh->y0.f1 = brh->val;
    brh->y0.f0 = brh->y0.x * brh->y0.f1;
    brh->m0.c0 = 0.;
 }
 brh->m0.f1 = brh->y0.f1;
 trloadactive(brh);
 return brh->converged = conv_check(brh);
}
/*--------------------------------------------------------------------------*/
static void ac_vccs(branch_t *brh)
{
 if (brh->f->acfun){
    brh->acbias = dc_volts(&(brh->n[IN1]),&(brh->n[IN2]));
    brh->ev = (*brh->f->acfun)(brh);
 }else{
    brh->ev.x  = brh->y0.f1;
    brh->ev.y  = 0.;
 }
 brh->acg = brh->ev;
 acloadactive(brh);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
