/* d_cs.c  94.12.09
 * Copyright 1983-1992   Albert Davis
 * functions for fixed current source
 * x = 0, y.f0 = nothing, ev = y.f1 = amps.
 */
#include "ecah.h"
#include "branch.h"
#include "mode.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
static 	int	tr_cs(branch_t*);
static 	void	ac_cs(branch_t*);
/*--------------------------------------------------------------------------*/
functions_t dev_cs = {
   (generic_t*)NULL,	/* x */
   sizeof(functions_t),	/* ssize */
   sizeof(branch_t),	/* elementsize */
   (functions_t*)NULL,	/* super */
   2, 			/* numnodes */
   rnONEPORT,		/* refnode */
   rnSOURCE,		/* isdevice */
   create_std,		/* create */
   copy_std,		/* copy */
   parse_std,		/* parse */
   print_std,		/* print */
   NULL,		/* expand */
   probe_std,		/* probe */
   tr_probe_std,	/* tr_probe */
   ac_probe_std,	/* ac_probe */
   xprobe_std,		/* xprobe */
   tr_cs,		/* dotr */
   unloadsource,	/* untr */
   ac_cs,		/* doac */
   trfix1,		/* trfun1 */
   trfix0,		/* trfun0 */
   acfix,		/* acfun */
   NULL,		/* tr_guess */
   NULL,		/* tr_advance */
   NULL			/* tr_review */
};
/*--------------------------------------------------------------------------*/
static int tr_cs(branch_t *brh)
{
 brh->m0.x = NOT_VALID;		/* anything * 0 = 0 */
 brh->y0.x = 0.;
 if (brh->f->trfun1){
    (*brh->f->trfun1)(brh);
 }else{
    brh->y0.f1 = brh->val;
    brh->y0.f0 = 0.;
 }
 brh->m0.f1 = 0.;
 brh->m0.c0 = brh->y0.f1;
 trloadsource(brh);
 return brh->converged = conv_check(brh);
}
/*--------------------------------------------------------------------------*/
static void ac_cs(branch_t *brh)
{
 if (brh->f->acfun){
    brh->acbias = 0.;
    brh->acg = brh->ev = (*brh->f->acfun)(brh);
    acloadsource(brh);
 }else{
    brh->ev.x = brh->ev.y = 0.;	/* a DC only source	*/
 }
 brh->acg.x = brh->acg.y = 0.;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
