#!/usr/local/bin/perl
# index.cgi
# Display jabber configuration option categories

require './jabber-lib.pl';
&header($text{'index_title'}, "", "intro", 1, 1);
print "<hr>\n";

# Check if config file exists
if (!-r $config{'jabber_config'}) {
	print &text('index_econfig', "<tt>$config{'jabber_config'}</tt>",
		    "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check if base directory exists
if (!-d $config{'jabber_dir'}) {
	print &text('index_edir', "<tt>$config{'jabber_dir'}</tt>",
		    "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check the version of jabberd
$jabberd = $config{'jabber_daemon'} ? $config{'jabber_daemon'}
				    : "$config{'jabber_dir'}/bin/jabberd";
if (!-x $jabberd) {
	print &text('index_ejabberd', "<tt>$jabberd</tt>",
		    "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}
$out = `$jabberd -v 2>&1`;
if ($out !~ /\s1\.4/) {
	print &text('index_eversion', "<tt>$out</tt>", "1.4"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check if XML::Parser is installed, and if not offer to install it
if (!$got_xml_parser) {
	print &text('index_emodule', "<tt>XML::Parser</tt>",
	    "/cpan/download.cgi?source=3&cpan=XML::Parser&mode=2"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check if XML::Generator is installed, and if not offer to install it
if (!$got_xml_generator) {
	print &text('index_emodule', "<tt>XML::Generator</tt>",
	    "/cpan/download.cgi?source=3&cpan=XML::Generator&mode=2"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Show config category icons
$conf = &get_jabber_config();
if (!ref($conf)) {
	print &text('index_eparse', "<tt>XML::Parser</tt>", $conf),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}
@cats = ( "general", "messages", "modules", "karma", "ips", "filter", "admin", "file" );
@links = map { "edit_${_}.cgi" } @cats;
@titles = map { $text{"${_}_title"} } @cats;
@icons = map { "images/${_}.gif" } @cats;
&icons_table(\@links, \@titles, \@icons);

# Show warning about config file
open(CONFIG, $config{'jabber_config'});
while(<CONFIG>) {
	if (/\s+<!--/) {
		$has_comment++;
		last;
		}
	}
close(CONFIG);
print "<b>",&text('index_comments',
	  "<tt>$config{'jabber_config'}</tt>"),"</b><p>\n" if ($has_comment);

# Check if jabber is running and show the correct buttons
print "<hr>\n";
print "<table width=100%>\n";
if (open(PID, &jabber_pid_file()) && ($pid = int(<PID>)) && kill(0, $pid)) {
	# Running .. offer to restart and stop
	print "<form action=restart.cgi><tr>\n";
	print "<td><input type=submit value=\"$text{'index_restart'}\"></td>\n";
	print "<td>$text{'index_restartmsg'}</td>\n";
	print "</tr></form>\n";

	print "<form action=stop.cgi><tr>\n";
	print "<td><input type=submit value=\"$text{'index_stop'}\"></td>\n";
	print "<td>$text{'index_stopmsg'}</td>\n";
	print "</tr></form>\n";
	}
else {
	# Not running .. offer to start
	print "<form action=start.cgi><tr>\n";
	print "<td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'}</td>\n";
	print "</tr></form>\n";
	}
print "</table>\n";
close(PID);

print "<hr>\n";
&footer("/", $text{'index'});

