#!/usr/local/bin/perl
# atboot.pl
# Called by setup.sh to have webmin started at boot time

$no_acl_check++;
require './init-lib.pl';

if ($config{'darwin_setup'}) {
	# Darwin System
	open(LOCAL, ">>$config{'hostconfig'}");
	print LOCAL "WEBMIN=-YES-\n";
	close(LOCAL);
	
	$paramlist = "$config{'darwin_setup'}/Webmin/$config{'plist'}";
	$scriptfile = "$config{'darwin_setup'}/Webmin/Webmin";
	
	# On a Virgin darwin system, $config{'darwin_setup'} may not yet exist
	-d "$config{'darwin_setup'}/Webmin" || do {
		if ( -d "$config{'darwin_setup'}" ) {
			mkdir ("$config{'darwin_setup'}/Webmin", 0755);
			} else {
			mkdir ("$config{'darwin_setup'}", 0755);
			mkdir ("$config{'darwin_setup'}/Webmin",0755);
			}
		} until -d "$config{'darwin_setup'}/Webmin";

	open(PLIST, ">$paramlist");
	print PLIST "{\n";
	print PLIST "\t\tDescription\t\t= \"Webmin system administration daemon\";\n";
	print PLIST "\t\tProvides\t\t= (\"Webmin\");\n";
	print PLIST "\t\tRequires\t\t= (\"Resolver\");\n";
	print PLIST "\t\tOrderPreference\t\t= \"None\";\n";
	print PLIST "\t\tMessages =\n";
	print PLIST "\t\t{\n";
	print PLIST "\t\t\tstart\t= \"Starting Webmin Server\";\n";
	print PLIST "\t\t\tstop\t= \"Stopping Webmin Server\";\n";
	print PLIST "\t\t};\n";
	print PLIST "}\n";
	close(PLIST);
	# Create Bootup Script
	open(STARTUP, ">$scriptfile");
	print STARTUP "#!/bin/sh\n\n";
	print STARTUP ". /etc/rc.common\n\n";
	print STARTUP "if [ \"\${WEBMIN:=-NO-}\" = \"-YES-\" ]; then\n";
	print STARTUP "\tConsoleMessage \"Starting Webmin\"\n";
	print STARTUP "\t$config_directory/start\n";
	print STARTUP "fi\n";
	close(STARTUP);
	chmod(0750, $scriptfile);
	}
elsif (!$config{'init_base'}) {
	# Add to the boot time rc script
	open(LOCAL, ">>$config{'local_script'}");
	print LOCAL "$config_directory/start	# Start webmin\n";
	close(LOCAL);
	print "Added to bootup script $config{'local_script'}\n";
	}
else {
	# Create a bootup action
	($initrl) = &get_inittab_runlevel();
	$fn = &action_filename("webmin");
	open(ACTION,">$fn");
	$desc = "Start/stop Webmin";
	print ACTION "#!/bin/sh\n";
	$start_order = "9" x $config{'order_digits'};
	$stop_order = "9" x $config{'order_digits'};
	if ($config{'chkconfig'}) {
		# Redhat-style description: and chkconfig: lines
		print ACTION "# description: $desc\n";
		print ACTION "# chkconfig: $config{'chkconfig'} ",
			     "$start_order $stop_order\n";
		}
	elsif ($config{'init_info'}) {
		# Suse-style init info section
		print ACTION "### BEGIN INIT INFO\n",
			     "# Provides: webmin\n",
			     "# Default-Start: $initrl\n",
			     "# Description: $desc\n",
			     "### END INIT INFO\n";
		}
	else {
		# Just description in a comment
		print "# $desc\n";
		}
	print ACTION "\n";
	print ACTION "case \"\$1\" in\n";

	print ACTION "'start')\n";
	print ACTION "\t$config_directory/start\n";
	print ACTION "\ttouch $config{'subsys'}/webmin\n"
		if ($config{'subsys'});
	print ACTION "\t;;\n";

	print ACTION "'stop')\n";
	print ACTION "\t$config_directory/stop\n";
	print ACTION "\trm -f $config{'subsys'}/webmin\n"
		if ($config{'subsys'});
	print ACTION "\t;;\n";

	print ACTION "'status')\n";
	print ACTION "\tif [ -s $var_directory/miniserv.pid ]; then\n";
	print ACTION "\t\tpid=`cat $var_directory/miniserv.pid`\n";
	print ACTION "\t\tkill -0 \$pid >/dev/null 2>&1\n";
	print ACTION "\t\tif [ \"\$?\" = \"0\" ]; then\n";
	print ACTION "\t\t\techo \"webmin (pid \$pid) is running\"\n";
	print ACTION "\t\telse\n";
	print ACTION "\t\t\techo \"webmin is stopped\"\n";
	print ACTION "\t\tfi\n";
	print ACTION "\telse\n";
	print ACTION "\t\techo \"webmin is stopped\"\n";
	print ACTION "\tfi\n";
	print ACTION "\t;;\n";

	print ACTION "'restart')\n";
	print ACTION "\t$config_directory/stop && $config_directory/start\n";
	print ACTION "\t;;\n";

	print ACTION "*)\n";
	print ACTION "\techo \"Usage: \$0 { start | stop }\"\n";
	print ACTION "\t;;\n";
	print ACTION "esac\n";
	print ACTION "exit 0\n";
	close(ACTION);
	chmod(0755, $fn);
	&add_rl_action("webmin", $initrl, "S", $start_order);
	&add_rl_action("webmin", $initrl, "K", $stop_order);
	print "Created init script $fn\n";
	}

