#!/usr/local/bin/perl
# feedback_form.cgi
# Display a form so that the user can send in a webmin bug report

require './web-lib.pl';
&init_config();
&ReadParse();
&error_setup($text{'feedback_err'});
%access = &get_module_acl();
$access{'feedback'} || &error($text{'feedback_ecannot'});
&header($text{'feedback_title'}, "", undef, 0, 1);
print "<hr>\n";

print &text('feedback_desc', "<tt>$webmin_feedback_address</tt>"),"<p>\n";

print "<form action=feedback.cgi method=post enctype=multipart/form-data>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'feedback_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'feedback_name'}</b></td>\n";
print "<td><input name=name size=35 value='$gconfig{'feedback_name'}'></td>\n";

print "<td><b>$text{'feedback_email'}</b></td>\n";
print "<td><input name=email size=35 value='$gconfig{'feedback_email'}'></td> </tr>\n";

print "<tr> <td><b>$text{'feedback_module'}</b></td>\n";
print "<td><select name=module>\n";
printf "<option value='' %s>%s\n",
	$in{'module'} ? "" : "selected", $text{'feedback_all'};
opendir(DIR, ".");
foreach $d (readdir(DIR)) {
	local %minfo;
	if ($d !~ /^\./ && (%minfo = &get_module_info($d)) &&
	    &check_os_support(\%minfo)) {
		push(@modules, \%minfo);
		}
	}
closedir(DIR);
foreach $m (sort { $a->{'desc'} cmp $b->{'desc'} } @modules) {
	printf "<option %s value=%s>%s\n",
		$in{'module'} eq $m->{'dir'} ? "selected" : "",
		$m->{'dir'}, $m->{'desc'};
	}
print "</select></td>\n";

print "<td><b>$text{'feedback_mailserver'}</b></td>\n";
print "<td><input name=mailserver size=20 ",
      "value='$gconfig{'feedback_mailserver'}'></td> </tr>\n";

if (!$gconfig{'nofeedbackcc'}) {
	print "<tr> <td><b>$text{'feedback_cc'}</b></td>\n";
	print "<td><input name=cc size=20></td>\n";

	print "<td><b>$text{'feedback_towebmin'}</b></td>\n";
	print "<td><input type=radio name=towebmin value=0> $text{'yes'}\n";
	print "<input type=radio name=towebmin value=1 checked> $text{'no'}</td> </tr>\n";
	}

print "<tr> <td valign=top><b>$text{'feedback_text'}</b></td>\n";
print "<td colspan=3><textarea name=text rows=6 cols=70 wrap=on>",
      "</textarea></td> </tr>\n";

print "<tr> <td colspan=2><b>$text{'feedback_os'}</b>&nbsp;&nbsp;\n";
printf "<input type=radio name=os value=1> $text{'yes'}\n";
printf "<input type=radio name=os value=0 checked> $text{'no'}</td>\n";
print "<td colspan=2>($text{'feedback_osdesc'})</td> </tr>\n";

if (!$gconfig{'nofeedbackconfig'}) {
	print "<tr> <td colspan=2><b>$text{'feedback_config'}</b>&nbsp;&nbsp;\n";
	printf "<input type=radio name=config value=1> $text{'yes'}\n";
	printf "<input type=radio name=config value=0 checked> $text{'no'}</td>\n";
	print "<td colspan=2>($text{'feedback_configdesc'})</td> </tr>\n";
	}

print "<tr> <td><b>$text{'feedback_attach'}</b></td>\n";
print "<td><input type=file name=attach0></td>",
      "<td colspan=2><input type=file name=attach1></td> </tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'feedback_send'}'></form>\n";

print "<hr>\n";
&footer("", $text{'index'});

