<?php

  /**************************************************************************\
  * phpGroupWare - SyncML Synchronization                                    *
  * http://www.phpgroupware.org                                              *
  * Written by Jens P. Elsner <jpelsner@gmx.net>                             *
  *            Mark Wormgoor <mark@wormgoor.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

/*
This product includes software developed by The SyncML Initiative.
*/


	/********************************************************************\
	* Define our own SyncML class                                        *
	\********************************************************************/

	include ('./inc/class.syncml.inc.php');

	class syncml_phpgw extends syncml {
		function cb_start_message($sync_hdr) {
			echo "\n|----> message start \n";
        		echo "Version: $sync_hdr->version \n";
        		echo "Protocol: $sync_hdr->proto \n";
			echo "Session ID: $sync_hdr->sessionID \n";
        		echo "Message ID: $sync_hdr->msgID \n";
        		echo "Flags: $sync_hdr->flags \n";
			// no cred implemented yet
        		echo "Target URI: {$sync_hdr->target->locURI} \n";
                        echo "Target Name: {$sync_hdr->target->locName} \n";
                        echo "Source URI: {$sync_hdr->source->locURI} \n";
                        echo "Source Name: {$sync_hdr->source->locName} \n";
		}
		function cb_end_message($bool) {
			echo "|----> message end\nFinal: $bool\n";
		}
		function cb_start_sync($sync) {
                        echo "|----> sync start \n";
                        echo "cmdID: $sync->cmdID \n";
                        echo "Flags: $sync->flags \n";
			echo "Cred Meta: {$sync->cred->meta} \n";
			echo "Cred Data: {$sync->cred->data} \n";
                        echo "Target URI: {$sync->target->locURI} \n";
                        echo "Target Name: {$sync->target->locName} \n";
                        echo "Source URI: {$sync->source->locURI} \n";
                        echo "Source Name: {$sync->source->locName} \n";
			echo "Meta: $sync->meta \n";
		}
		function cb_end_sync() {
			echo "|----> sync end \n";	
		}
		function cb_add_cmd($generic) {
                        echo "|----> add command start \n";
                        echo "cmdID: $generic->cmdID \n";
                        echo "Flags: $generic->flags \n";
                        echo "Cred Meta: {$generic->cred->meta} \n";
                        echo "Cred Data: {$generic->cred->data} \n";
                        echo "Meta: $generic->meta \n";
			echo "Item List: \n";
			var_dump($generic->itemList);
		}
	}

	/********************************************************************\
	* Create a test message                                             *
	\********************************************************************/
	
	echo "SyncML reference toolkit PHP wrapper \n---\n";

	$test = new syncml_phpgw (2, 10000, 'woohoo');

	$hdr = new sml_sync_hdr();
	$hdr->version = '1.0';
	$hdr->proto = 'SyncML/1.0';
	$hdr->sessionID = 1;
	$hdr->msgID = 1;
	$hdr->flags = 0x0100;
	$hdr->target->locURI = 'http://www.target.com';
	$hdr->target->locName = 'this is my target site.';
        $hdr->source->locURI = 'http://www.source.com';
	$hdr->source->locName = 'this is my source site.';
	$hdr->cred->meta = 'credmeta';
	$hdr->cred->data = 'creddata';
	$test->start_message($hdr);

        echo "Free mem in test buffer: ", $test->get_free_buffer(), " bytes \n";

	$sync = new sml_sync();
	$sync->cmdID = "99";
        $sync->flags = 0x0100;
        $sync->target->locURI = 'http://www.target.com';
        $sync->target->locName = 'this is my target site.';
        $sync->source->locURI = 'http://www.source.com';
        $sync->source->locName = 'this is my source site.';
        $sync->cred->meta = 'credmeta';
        $sync->cred->data = 'creddata';
	$sync->meta = "meeeetaaaaaaaaa";
        $test->start_sync($sync);

	$item1 = new sml_item();
	$item1->target->locURI="item1 target loc";
	$item1->target->locName="item1 target name";
        $item1->source->locURI="item1 source loc";
        $item1->source->locName="item1 source name";
        $item1->data="item1 data";
	$item1->meta="item1 meta";
	$item2 = new sml_item();
        $item2->target->locURI="item2 target loc";
        $item2->target->locName="item2 target name";
        $item2->source->locURI="item2 source loc";
        $item2->source->locName="item2 source name";
        $item2->data="item2 data"; 
        $item2->meta="item2 meta";
	$item3 = new sml_item();
        $item3->target->locURI="item3 target loc";
        $item3->target->locName="item3 target name";
        $item3->source->locURI="item3 source loc";
        $item3->source->locName="item3 source name";
        $item3->data="item3 data"; 
        $item3->meta="item3 meta";

	$add = new sml_generic();
	$add->cmdID = "1001";
	$add->flags = 0x0100;
	$add->cred->meta = "humpf.";
	$add->cred->data = "plonk!";
	$add->meta = "meat";
	$add->itemList[] = $item1;
	$add->itemList[] = $item2;
        $add->itemList[] = $item3;
        $test->add_cmd($add);

        $test->end_sync();
        $test->end_message(True);

        echo "Assembled SyncML request: \n---\n", $data=$test->read_out_buffer(), "\n---\n";
        echo "Wrote ", $test->write_in_buffer($data), " bytes to in-buffer. \n---\n";

	echo "Processing request: \n";
        $test->process_data();

?>
