<?php
	/**************************************************************************\
	* phpGroupWare - Shopping cart                                             *
	* http://www.phpgroupware.org                                              *
	* Written by Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: list_products.php,v 1.4 2001/06/29 02:37:56 bettina Exp $ */

	$phpgw_info['flags'] = array('currentapp' => 'cart',
					'enable_nextmatchs_class' => True);

	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('listproducts_t' => 'list_products.tpl',
						'listproducts' => 'list_products.tpl'));

	$t->set_block('listproducts_t','listproducts','list');

	$inventory = CreateObject('inv.inventory');
	$grants = $phpgw->acl->get_grants('inv');
	$c = CreateObject('phpgwapi.categories');
	$c->app_name = 'inv';
    $t->set_var('action_url',$phpgw->link('/cart/list_products.php'));

	$currency = $phpgw_info['user']['preferences']['common']['currency'];

	$archive_id = $inventory->get_status_id('archive');

	if (!$start)
	{
		$start = '0';
	}

	if ($query)
	{
		$querymethod = " AND (id like '%$query%' OR serial like '%$query%' OR name like '%$query%' OR descr like '%$query%' "
					. "OR cost like '%$query%' OR price like '%$query%' OR stock like '%$query%' OR mstock like '%$query%' OR url like '%$query%' "
					. "OR ftp like '%$query%' OR pdate like '%$query%' OR sdate like '%$query%' OR product_note like '%$query%')";
	}

	if ($cat_id)
	{
		$filter = $cat_id;
	}

	if (! $filter) 
	{
		$phpgw->db->query("SELECT category from phpgw_inv_products WHERE status != '$archive_id' $querymethod");    
		$phpgw->db->next_record();
		$category = $c->return_single($phpgw->db->f('category'));
		if ($category)
		{
			if ($inventory->check_perms($grants[$category[0]['owner']],PHPGW_ACL_READ) || $category[0]['owner'] == $phpgw_info['user']['account_id']) 
			{
				$filter = $phpgw->db->f('category');
			}
		}
		else 
		{
			$filter = '999';
		}
	}
	else
	{
		$category = $c->return_single($filter);
	}

	$products = $inventory->read_products($start,True,$query,'category',$filter,$sort,$order,'active');

//--------------------------------- nextmatch --------------------------------------------

	$left = $phpgw->nextmatchs->left('/cart/list_products.php',$start,$inventory->total_records);
	$right = $phpgw->nextmatchs->right('/cart/list_products.php',$start,$inventory->total_records);
	$t->set_var('left',$left);
	$t->set_var('right',$right);

	$t->set_var('lang_showing',$phpgw->nextmatchs->show_hits($inventory->total_records,$start)); 

// ------------------------------ end nextmatch ------------------------------------------

//---------------------------- list variable template-declarations -------------------------

	$t->set_var('th_bg',$phpgw_info['theme']['th_bg']);
	$t->set_var('sort_id',$phpgw->nextmatchs->show_sort_order($sort,'id',$order,'/cart/list_products.php',lang('Product ID')));
	$t->set_var('sort_name',$phpgw->nextmatchs->show_sort_order($sort,'name',$order,'/cart/list_products.php',lang('Name')));
	$t->set_var('sort_retail',$phpgw->nextmatchs->show_sort_order($sort,'retail',$order,'/cart/list_products.php',lang('Price')));
	$t->set_var('lang_view',lang('View'));
	$t->set_var('currency',$currency);
	$t->set_var('search_action',$phpgw->link('/cart/list_products.php'));
	$t->set_var('lang_search',lang('Search'));
	$t->set_var('category_list',$c->formated_list('list','all',$filter,False,'/cart/list_products.php'));
	$t->set_var('lang_submit',lang('Submit'));
	$t->set_var('lang_choose',lang('Choose'));
	$t->set_var('lang_piece',lang('Piece'));
    $t->set_var('lang_add',lang('Add to Shopping cart'));

// -------------------------------- end declaration -----------------------------------------

	$taxpercent = select_tax($filter);
	for ($i=0;$i<count($products);$i++) 
	{
		$phpgw->templater_color = $phpgw->nextmatchs->alternate_row_color($phpgw->templater_color);
		$t->set_var('tr_color',$phpgw->templater_color);
		$choose = '<input type="checkbox" name="choose[' . $products[$i]['con'] . ']" value="True">';
		$piece = '<input type="text" name="piece[]" value="" size="5">';
		$name = $phpgw->strip_html($products[$i]['name']);
		if (! $name)
		{
			$name = '&nbsp;';
		}
		$id = $phpgw->strip_html($products[$i]['id']);
		$price = $products[$i]['price'];
		$retail = round(($price)*(1+$taxpercent),2);

//---------------------------------- list records -------------------------------------

		$t->set_var(array('choose' => $choose,
							'piece' => $piece,
							'id' => $id,
							'name' => $name,
						'retail' => sprintf("%01.2f",$retail)));

		$t->set_var('view',$phpgw->link('/cart/view_product.php','con=' . $products[$i]['con'] . '&filter=' . $filter));

		$t->parse('list','listproducts',True);
	}

// ---------------------------- end list records -----------------------------------------

	$t->parse('out','listproducts_t',True);
	$t->p('out');

	$phpgw->common->phpgw_footer();
?>
