<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_brewer                                              *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: functions.inc.php,v 1.2 2001/09/11 12:38:28 milosch Exp $ */

	// Return a select form element with the categories option dialog in it
	function cat_option($cat_id='',$notall=False,$java=True)
	{
		if ($java)
		{
			$jselect = ' onChange="this.form.submit();"';
		}
		// Setup all and none first
		$cats_link  = "\n" .'<select name="cat_id"' .$jselect .">\n";
		if (!$notall)
		{
			$cats_link .= '<option value=""';
			if ($cat_id=="all")
			{
				$cats_link .= ' selected';
			}
			$cats_link .= '>'.lang("all").'</option>'."\n";
		}

		// Get global and app-specific category listings
		$cats       = CreateObject('phpgwapi.categories');
		$cats_link .= $cats->formated_list('select','all',$cat_id,False);
		$cats_link .= '</select>'."\n";
		return $cats_link;
	}

	function formatted_list($name,$list,$id='',$java=False)
	{
		if ($java)
		{
			$jselect = ' onChange="this.form.submit();"';
		}

		$select  = "\n" .'<select name="' . $name . '"' . $jselect . ">\n";
		$select .= '<option value="">' . lang('Please Select') . '</option>'."\n";
		while (list($key,$val) = each($list))
		{
			$select .= '<option value="' . $key . '"';
			if ($key == $id && $id != '')
			{
				$select .= ' selected';
			}
			$select .= '>' . $val['name'] . '</option>'."\n";
		}

		$select .= '</select>'."\n";
		$select .= '<noscript><input type="submit" name="' . $name . '_select" value="{lang_select}"></noscript>' . "\n";

		return $select;
	}
?>
