.TH "ZIP_FILE_GET_COMMENT" "3" "September 19, 2013" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_get_comment\fR
\- get comment for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIconst char *\fR
.PD 0
.HP 4n
\fBzip_file_get_comment\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_uint32_t\ *lenp\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_file_get_comment\fR()
function returns the comment for the file at position
\fIindex\fR
in the zip archive.
The name is in UTF-8 encoding unless
\fRZIP_FL_ENC_RAW\fR
was specified (see below).
This pointer should not be modified or
free(3)'d,
and becomes invalid when
\fIarchive\fR
is closed.
If
\fIlenp\fR
is not
\fRNULL\fR,
the integer to which it points will be set to the length of the
comment.
If
\fIflags\fR
is set to
\fRZIP_FL_UNCHANGED\fR,
the original unchanged comment is returned.
.PP
Additionally, the following
\fIflags\fR
are supported:
.RS 6n
.TP 21n
\fRZIP_FL_ENC_RAW\fR
Return the unmodified comment as it is in the ZIP archive.
.TP 21n
\fRZIP_FL_ENC_GUESS\fR
(Default.)
Guess the encoding of the comment in the ZIP archive and convert it
to UTF-8, if necessary.
.TP 21n
\fRZIP_FL_ENC_STRICT\fR
Follow the ZIP specification for file names and extend it to file
comments, expecting them to be encoded in CP-437 in the ZIP archive
(except if it is a UTF-8 comment from the special extra field).
Convert it to UTF-8.
.RE
\fINote\fR:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
Upon successful completion, a pointer to the comment is returned,
or
\fRNULL\fR
if there is no comment.
In case of an error,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_file_get_comment\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR.
.SH "SEE ALSO"
libzip(3),
zip_file_set_comment(3),
zip_get_archive_comment(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
