/***************************************************************************
                          kcoloreditdoc.h  -  description
                             -------------------
    begin                : Sat Jul  8 09:57:28 CEST 2000
    copyright            : (C) 2000 by Artur Rataj
    email                : art@zeus.polsl.gliwice.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOLOREDITDOC_H
#define KCOLOREDITDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>

// application specific includes
#include "palette.h"
#include "palettehistory.h"

// forward declaration of the KColorEdit classes
class KColorEditView;

/**	KColorEditDoc provides a document object for a document-view model.
  *
  * The KColorEditDoc class provides a document object that can be used in conjunction with the classes KColorEditApp and KColorEditView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KColorEditApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KColorEditView objects. Also, KColorEditDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 0.4 code generation
  */
class KColorEditDoc : public QObject
{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    KColorEditDoc(QWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~KColorEditDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KColorEditView *view);
    /** removes a view from the list of currently connected views */
    void removeView(KColorEditView *view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool modified);
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; };
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();	
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the actual document */
    void closeDocument();
    /** loads the document */
    bool openDocument(const QString& filename);
    /** saves the document */	
    bool saveDocument(const QString& filename);
    /** sets the path to the file connected with the document */
    void setAbsFilePath(const QString &filename);
    /** returns the pathname of the current document file*/
    const QString& getAbsFilePath() const;
    /** sets the filename of the document */
    void setTitle(const QString &_t);
    /** returns the title of the document */
    const QString& getTitle() const;
		/** @return a description of a possible unsuccessfull IO operation */
		const QString& getErrorString() const;
		/** returns a pointer to paletteHistory */
		PaletteHistory* getPaletteHistory();
		/** sets a palette cursor position */
		void setPaletteCursorPos(const int pos);
		/** @return a palette cursor position */
		int getPaletteCursorPos();
		/** Sets palette selection and enables or disables cut/paste
		 *  depending on whether any colors are selected
		 */
		void setPaletteSelection(const int begin, const int end);
		/** Gets lesser selection position or equal selection position
		 *  if no colors are selected
		 */
		int getPaletteSelectionBegin();
		/** Gets greater selection position or equal selection position
		 *  if no colors are selected
		 */
		int getPaletteSelectionEnd();
		/** Copies a selection into a clipboard */
		void copy();
		/** Cuts a selection into a clipboard */
		void cut();
		/** Pastes a selection from a clipboard */
		void paste();
		/** Inserts a color at index */
		void insert(int index, const Color& color);
		/** Replaces a color at index */
		void replace(int index, const Color& color);
		
	protected:
		/** Sets an error string if an IO operation was unsuccesfull */
		void setErrorString(const QString& string);
		/** Updates color menu */
		void updateColorMenu();
		/** Copies a palette to clipboard */
		void copyToClipboard(Palette& palette) const;
	
  public slots:
    /** Calls redraw() on all views connected to the document object,
     *  except for sender if sender is not null
     */
    void slotRedrawAllViews(KColorEditView* sender, bool newDocument = false);
    /** Sets a view mode */
	void slotChangeViewMode(bool viewColorNames);

  public:	
    /** the list of the views currently connected to the document */
    QList<KColorEditView> *pViewList;	

  private:
    /** the modified flag of the current document */
    bool modified;
    QString title;
    QString absFilePath;
    QString errorString;

	protected:
		Palette palette;
		PaletteHistory paletteHistory;
		int paletteCursorPos;
		int paletteSelectionBegin;
		int paletteSelectionEnd;
};

#endif // KCOLOREDITDOC_H
