/**
 * $Horde: imp/js/src/unblockImages.js,v 1.7.2.1 2007/12/20 13:59:22 jan Exp $
 *
 * Use DOM manipulation to un-block images that had been redirected.
 */

var IMP = window.IMP || {};

IMP.unblockImages = function(parent, message)
{
    if (!parent) {
        return true;
    }

    $(parent).descendants().each(function(elt) {
        if (elt.hasAttribute('blocked')) {
            var src = decodeURIComponent(elt.readAttribute('blocked'));
            if (elt.hasAttribute('src')) {
                elt.setAttribute('src', src);
            } else if (elt.hasAttribute('background')) {
                elt.setAttribute('background', src);
            } else if (elt.style.backgroundImage) {
                elt.setStyle({ backgroundImage: 'url(' + src + ')' });
            }
        }
    });

    message = $(message);
    if (message) {
        message.remove();
    }

    // On success return false to stop event propagation.
    return false;
};
