///////
   //   Interface class for a MySQL Database client application
   //
   //    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: Htmysql.h,v 1.7 2002/02/06 11:04:34 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 02.07.1999
   //
///////

#ifndef _HTMYSQL_H
#define _HTMYSQL_H

#include "mysql.h"
#include "mysqld_error.h"
#include "htString.h"
#include <iostream.h>


class HtmysqlQueryResult;

class Htmysql
{
   public:

      Htmysql();
      virtual ~Htmysql();

      // Initializes the Database
      int Init();

      // Connects with a MySQL database

      virtual int Connect( const char *host=NULL, const char *user=NULL,
                           const char *passwd=NULL, const char *db=NULL,
                           uint port=0, char *unix_socket=NULL,
                           uint client_flag=0);
	 
      // Close the connection
      void Close();
	 
      // Ping: checks whether or not the connection to the server is working
      //       Reconnect if necessary
      //    	Returns zero if alive, non-zero if an error occured
      int Ping();
	 
      // Select the current database
      int SelectDB(const String db);
	 
      // Execute a query
      int ExecQuery (const String query);

      enum Query_Type
      {
         Htmysql_Stored,
         Htmysql_Temporary
      };
	 
      // Store the result of a query
      HtmysqlQueryResult *StoreResult(HtmysqlQueryResult &);
      HtmysqlQueryResult *StoreResult();

      // Get next record directly from the connection
      HtmysqlQueryResult *UseResult(HtmysqlQueryResult &);
      HtmysqlQueryResult *UseResult();

      // Retrieve the database list with an optional pattern
      HtmysqlQueryResult *ListDBs (const char *wild = NULL);

      // Returns the ID that was most recently generated for AUTO_INCREMENT field
      int GetLastID();
      
      // Check if a database exists (with wilcards -- foo%)
      // Returns -1 if an error occurs, else the number of times
      // the database has been found (0, 1, >1 in a wildcard case)
      
      int Exists (const String &dbname);
            
      // Gets the error number
      int GetError();
	 
      // Displays an error message
      int DisplayError (ostream & _stream = cout);

      // Set SQL big tables option (for MySQL)
      virtual int SetSQLBigTableOption() = 0;

      // Optimize a database
      virtual int Optimize() = 0 ;

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}
      
   protected:
      MYSQL mysql;

      static int debug;    // Run-time debugging level

};



///////
   //    Class containing query results
///////


class HtmysqlQueryResult
{
   friend class Htmysql;    // declaring friendship

   public:

      HtmysqlQueryResult();
      ~HtmysqlQueryResult();

         bool Empty() const { return !result;}
         Htmysql::Query_Type Type() const { return _query_type; }
      	 
	 unsigned int GetRows() const  	{return rows;}
	 unsigned int GetFields() const 	{return fields;}
         
	 void Free();
	 
	 MYSQL_ROW GetNextRecord();

         // View the whole database
         void View (ostream & _stream = cout);
	 
   protected:

   	 void Set(MYSQL_RES *);
	 void Refresh();
	    
   	 MYSQL_RES   *result;
         MYSQL_ROW   _record;
	 
	 unsigned int rows;
	 unsigned int fields;
         
         Htmysql::Query_Type  _query_type;

};

#endif
