#!/bin/sh
# CVE-2011-2381
set -e

echo "> $0 $*"

cd "$1" && patch -p1 < "$0"

exit 0

Description: CVE-2011-2381 Email Header Injection
Origin: http://bzr.mozilla.org/bugzilla/3.6/revision/7250
Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=657158

--- a/Bugzilla/Template.pm	2011-02-14 21:56:52 +0000
+++ b/Bugzilla/Template.pm	2011-08-04 19:24:00 +0000
@@ -549,6 +549,9 @@
             # as prefix. In addition it replaces a ' ' by a '_'.
             css_class_quote => \&Bugzilla::Util::css_class_quote ,
 
+            # Removes control characters and trims extra whitespace.
+            clean_text => \&Bugzilla::Util::clean_text ,
+
             quoteUrls => [ sub {
                                my ($context, $bug, $comment) = @_;
                                return sub {

--- a/template/en/default/request/email.txt.tmpl	2009-09-03 19:05:33 +0000
+++ b/template/en/default/request/email.txt.tmpl	2011-08-04 19:24:00 +0000
@@ -50,7 +50,7 @@
 To: [% to %]
 Subject: [% flagtype_name %] [%+ subject_status %]: [[% terms.Bug %] [%+ bug.bug_id %]] [% bug.short_desc %]
 [%- IF attachment %] :
-  [Attachment [% attachment.id %]] [% attachment.description %][% END %]
+  [Attachment [% attachment.id %]] [% attachment.description FILTER clean_text %][% END %]
 X-Bugzilla-Type: request
 [%+ threadingmarker %]
 

