.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkCvtHir.man,v 7.1 1994/04/21 06:51:27 kuma Exp $ NEC;
.TH "RKCVTHIRA" "3"
.SH "NAME"
\f4RkCvtHira\f1 \- convert double-width katakana to double-width hiragana
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkCvtHira(dst, maxdst, src, srclen)
unsigned char *dst;
int maxdst;
unsigned char *src;
int srclen;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkCvtHira\f1 converts the \f2srclen\f1 bytes of double-width katakana data to double-width hiragana, starting at the area \f2src\f1.  A null character in \f2src\f1 is not interpreted as the end of the string.  The conversion result is stored in the area \f2dst\f1.  Characters that are not subject to conversion are copied as they area.  The conversion result is truncated to adjust to character boundaries in the EUC code when its byte length exceeds \f2maxdst\f1 -1.  \f2dst\f1 is padded with null characters at the end if possible.  EUC code is used to represent both \f2src\f1 and \f2dst\f1. 
.P
\f4NULL\f1 can be specified in \f2dst\f1.  \f4NULL\f1 overrides the entire conversion result.
.SH "RETURN VALUE"
This function returns the byte length of the conversion result, or returns \f40\f1 if the value of \f2maxdst\f1 is invalid.
