/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};


static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;

static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);


static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}


/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}


ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* expr = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _expr_index;
			_expr_index = _tmp7_ + 1;
			_tmp8_ = _expr_index;
			_tmp9_ = _expr_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _expr_list;
			_tmp11_ = _expr_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			expr = (ValaExpression*) _tmp12_;
			_tmp13_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	gint _tmp3_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	_tmp3_ = index;
	if (_tmp3_ >= 0) {
		ValaList* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->argument_list;
		_tmp5_ = index;
		vala_list_set (_tmp4_, _tmp5_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp15_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp16_;
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = method_type;
			_tmp17_ = vala_method_type_get_method_symbol (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "GLib.NC_") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 1);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				result = _tmp25_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}


static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp12_ = vala_method_call_get_call (self);
	_tmp13_ = _tmp12_;
	result = vala_expression_is_accessible (_tmp13_, sym);
	return result;
}


static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp108_;
	ValaExpression* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	gboolean _tmp113_ = FALSE;
	ValaProfile _tmp114_;
	ValaProfile _tmp115_;
	gboolean gobject_chainup = FALSE;
	gboolean _tmp123_;
	gboolean _tmp124_;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp147_;
	gboolean _tmp241_ = FALSE;
	ValaExpression* _tmp242_;
	ValaExpression* _tmp243_;
	gboolean _tmp317_ = FALSE;
	gboolean _tmp318_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp333_;
	ValaDataType* _tmp334_;
	ValaList* params = NULL;
	ValaDataType* _tmp335_;
	ValaList* _tmp336_;
	ValaDataType* _tmp337_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp410_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp411_;
	ValaIterator* _tmp412_;
	gboolean _tmp465_ = FALSE;
	ValaDataType* _tmp466_;
	gboolean _tmp490_ = FALSE;
	ValaDataType* _tmp491_;
	ValaDataType* _tmp566_;
	ValaDataType* _tmp577_;
	ValaDataType* _tmp578_;
	ValaDataType* _tmp579_;
	ValaDataType* _tmp580_;
	ValaDataType* _tmp581_;
	ValaDataType* _tmp582_;
	ValaList* _tmp583_;
	ValaDataType* _tmp584_;
	ValaDataType* _tmp585_;
	gboolean may_throw = FALSE;
	ValaDataType* _tmp586_;
	ValaSemanticAnalyzer* _tmp907_;
	ValaSemanticAnalyzer* _tmp908_;
	ValaDataType* _tmp909_;
	ValaList* _tmp910_;
	ValaList* _tmp911_;
	ValaList* _tmp912_;
	gboolean _tmp913_;
	gboolean _tmp914_ = FALSE;
	gboolean _tmp915_ = FALSE;
	ValaCreationMethod* _tmp916_;
	gboolean _tmp945_;
	gboolean _tmp998_;
	gboolean _tmp999_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			ValaMemberAccess* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaMemberAccess* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp91_ = FALSE;
			ValaMemberAccess* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp19_;
			_tmp20_ = ma;
			_tmp21_ = vala_member_access_get_prototype_access (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_method_call_get_call (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_expression_get_symbol_reference (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_type_arguments (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp60_;
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				ValaMethod* _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaMethod* _tmp65_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_SIGNAL)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					ValaMemberAccess* _tmp53_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp51_) : NULL);
					sig = _tmp52_;
					_tmp53_ = sig;
					if (_tmp53_ != NULL) {
						ValaMemberAccess* _tmp54_;
						ValaExpression* _tmp55_;
						ValaExpression* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						_tmp54_ = sig;
						_tmp55_ = vala_member_access_get_inner (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_expression_get_value_type (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = _vala_code_node_ref0 (_tmp58_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp59_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp60_ = ma;
				_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp62_) : NULL);
				m = _tmp63_;
				_tmp65_ = m;
				if (_tmp65_ != NULL) {
					ValaMethod* _tmp66_;
					gboolean _tmp67_;
					gboolean _tmp68_;
					_tmp66_ = m;
					_tmp67_ = vala_method_get_coroutine (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp64_ = _tmp68_;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					gboolean _tmp69_ = FALSE;
					ValaMemberAccess* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = ma;
					_tmp71_ = vala_member_access_get_member_name (_tmp70_);
					_tmp72_ = _tmp71_;
					if (g_strcmp0 (_tmp72_, "begin") == 0) {
						_tmp69_ = TRUE;
					} else {
						ValaMemberAccess* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						_tmp73_ = ma;
						_tmp74_ = vala_member_access_get_member_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp69_ = g_strcmp0 (_tmp75_, "end") == 0;
					}
					if (_tmp69_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp76_;
						ValaExpression* _tmp77_;
						ValaExpression* _tmp78_;
						ValaMemberAccess* _tmp79_;
						gboolean _tmp80_ = FALSE;
						ValaMemberAccess* _tmp81_;
						_tmp76_ = ma;
						_tmp77_ = vala_member_access_get_inner (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp78_) : NULL);
						method_access = _tmp79_;
						_tmp81_ = method_access;
						if (_tmp81_ != NULL) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp80_ = _tmp84_ != NULL;
						} else {
							_tmp80_ = FALSE;
						}
						if (_tmp80_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaDataType* _tmp88_;
							ValaDataType* _tmp89_;
							ValaDataType* _tmp90_;
							_tmp85_ = method_access;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_value_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp90_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp92_ = ma;
			_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
			_tmp94_ = _tmp93_;
			if (_tmp94_ != NULL) {
				ValaMemberAccess* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaAttribute* _tmp98_;
				_tmp95_ = ma;
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp97_, "Assert");
				_tmp91_ = _tmp98_ != NULL;
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaList* args = NULL;
				ValaList* _tmp99_;
				ValaList* _tmp100_;
				gint _tmp101_;
				gint _tmp102_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp99_ = vala_method_call_get_argument_list (self);
				args = _tmp99_;
				_tmp100_ = args;
				_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp102_ == 1) {
					ValaList* _tmp103_;
					gpointer _tmp104_;
					ValaExpression* _tmp105_;
					ValaSourceReference* _tmp106_;
					ValaSourceReference* _tmp107_;
					_tmp103_ = args;
					_tmp104_ = vala_list_get (_tmp103_, 0);
					_tmp105_ = (ValaExpression*) _tmp104_;
					_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp105_);
					_tmp107_ = _tmp106_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp107_);
					_vala_code_node_unref0 (_tmp105_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp108_ = vala_method_call_get_call (self);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_expression_get_value_type (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = _vala_code_node_ref0 (_tmp111_);
	mtype = _tmp112_;
	_tmp114_ = vala_code_context_get_profile (context);
	_tmp115_ = _tmp114_;
	if (_tmp115_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp116_;
		ValaExpression* _tmp117_;
		ValaSymbol* _tmp118_;
		ValaSymbol* _tmp119_;
		ValaSemanticAnalyzer* _tmp120_;
		ValaSemanticAnalyzer* _tmp121_;
		ValaClass* _tmp122_;
		_tmp116_ = vala_method_call_get_call (self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_expression_get_symbol_reference (_tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_code_context_get_analyzer (context);
		_tmp121_ = _tmp120_;
		_tmp122_ = _tmp121_->object_type;
		_tmp113_ = _tmp119_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp113_ = FALSE;
	}
	gobject_chainup = _tmp113_;
	_tmp123_ = gobject_chainup;
	vala_method_call_set_is_chainup (self, _tmp123_);
	_tmp124_ = gobject_chainup;
	if (!_tmp124_) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp128_;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp130_ = FALSE;
		ValaMemberAccess* _tmp131_;
		gboolean _tmp141_ = FALSE;
		ValaMemberAccess* _tmp142_;
		_tmp125_ = vala_method_call_get_call (self);
		_tmp126_ = _tmp125_;
		_tmp127_ = _vala_code_node_ref0 (_tmp126_);
		expr = _tmp127_;
		_tmp128_ = expr;
		_tmp129_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp128_) : NULL);
		ma = _tmp129_;
		_tmp131_ = ma;
		if (_tmp131_ != NULL) {
			ValaMemberAccess* _tmp132_;
			ValaSymbol* _tmp133_;
			ValaSymbol* _tmp134_;
			_tmp132_ = ma;
			_tmp133_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp132_);
			_tmp134_ = _tmp133_;
			_tmp130_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp134_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp130_ = FALSE;
		}
		if (_tmp130_) {
			ValaMemberAccess* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaExpression* _tmp138_;
			ValaExpression* _tmp139_;
			ValaMemberAccess* _tmp140_;
			_tmp135_ = ma;
			_tmp136_ = vala_member_access_get_inner (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = _vala_code_node_ref0 (_tmp137_);
			_vala_code_node_unref0 (expr);
			expr = _tmp138_;
			_tmp139_ = expr;
			_tmp140_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp139_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp139_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp140_;
		}
		_tmp142_ = ma;
		if (_tmp142_ != NULL) {
			ValaMemberAccess* _tmp143_;
			const gchar* _tmp144_;
			const gchar* _tmp145_;
			_tmp143_ = ma;
			_tmp144_ = vala_member_access_get_member_name (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp141_ = g_strcmp0 (_tmp145_, "this") == 0;
		} else {
			_tmp141_ = FALSE;
		}
		if (_tmp141_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp146_;
			_tmp146_ = expr;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp146_, VALA_TYPE_BASE_ACCESS)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp147_ = self->priv->_is_chainup;
	if (_tmp147_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp148_;
		ValaSemanticAnalyzer* _tmp149_;
		ValaMethod* _tmp150_;
		ValaCreationMethod* _tmp151_;
		ValaCreationMethod* _tmp152_;
		ValaCreationMethod* _tmp160_;
		ValaDataType* _tmp161_;
		_tmp148_ = vala_code_context_get_analyzer (context);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_semantic_analyzer_find_current_method (_tmp149_);
		_tmp151_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp150_, VALA_TYPE_CREATION_METHOD) ? ((ValaCreationMethod*) _tmp150_) : NULL;
		if (_tmp151_ == NULL) {
			_vala_code_node_unref0 (_tmp150_);
		}
		cm = _tmp151_;
		_tmp152_ = cm;
		if (_tmp152_ == NULL) {
			ValaSourceReference* _tmp153_;
			ValaSourceReference* _tmp154_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp154_ = _tmp153_;
			vala_report_error (_tmp154_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp155_;
			gboolean _tmp156_;
			gboolean _tmp157_;
			_tmp155_ = cm;
			_tmp156_ = vala_creation_method_get_chain_up (_tmp155_);
			_tmp157_ = _tmp156_;
			if (_tmp157_) {
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				vala_report_error (_tmp159_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp160_ = cm;
		vala_creation_method_set_chain_up (_tmp160_, TRUE);
		_tmp161_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp162_;
			ValaObjectType* _tmp163_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp164_;
			ValaObjectTypeSymbol* _tmp165_;
			ValaObjectTypeSymbol* _tmp166_;
			ValaClass* _tmp167_;
			ValaClass* _tmp168_;
			ValaCreationMethod* _tmp169_;
			ValaCreationMethod* _tmp170_;
			ValaCreationMethod* _tmp171_;
			ValaCreationMethod* _tmp172_;
			_tmp162_ = mtype;
			_tmp163_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp163_;
			_tmp164_ = otype;
			_tmp165_ = vala_object_type_get_type_symbol (_tmp164_);
			_tmp166_ = _tmp165_;
			_tmp167_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp166_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp167_;
			_tmp168_ = cl;
			_tmp169_ = vala_class_get_default_construction_method (_tmp168_);
			_tmp170_ = _tmp169_;
			_tmp171_ = _vala_code_node_ref0 (_tmp170_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp171_;
			_tmp172_ = base_cm;
			if (_tmp172_ == NULL) {
				ValaSourceReference* _tmp173_;
				ValaSourceReference* _tmp174_;
				ValaClass* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp174_ = _tmp173_;
				_tmp175_ = cl;
				_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = g_strdup_printf ("chain up to `%s' not supported", _tmp177_);
				_tmp179_ = _tmp178_;
				vala_report_error (_tmp174_, _tmp179_);
				_g_free0 (_tmp179_);
				_g_free0 (_tmp177_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp180_;
				gboolean _tmp181_;
				gboolean _tmp182_;
				_tmp180_ = base_cm;
				_tmp181_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp180_);
				_tmp182_ = _tmp181_;
				if (!_tmp182_) {
					ValaSourceReference* _tmp183_;
					ValaSourceReference* _tmp184_;
					ValaCreationMethod* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					gchar* _tmp188_;
					gchar* _tmp189_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp184_ = _tmp183_;
					_tmp185_ = base_cm;
					_tmp186_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp185_);
					_tmp187_ = _tmp186_;
					_tmp188_ = g_strdup_printf ("chain up to `%s' not supported", _tmp187_);
					_tmp189_ = _tmp188_;
					vala_report_error (_tmp184_, _tmp189_);
					_g_free0 (_tmp189_);
					_g_free0 (_tmp187_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp190_ = FALSE;
			ValaExpression* _tmp191_;
			ValaExpression* _tmp192_;
			ValaSymbol* _tmp193_;
			ValaSymbol* _tmp194_;
			_tmp191_ = vala_method_call_get_call (self);
			_tmp192_ = _tmp191_;
			_tmp193_ = vala_expression_get_symbol_reference (_tmp192_);
			_tmp194_ = _tmp193_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp194_, VALA_TYPE_CREATION_METHOD)) {
				ValaExpression* _tmp195_;
				ValaExpression* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaSymbol* _tmp200_;
				_tmp195_ = vala_method_call_get_call (self);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_expression_get_symbol_reference (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_symbol_get_parent_symbol (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp190_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp200_, VALA_TYPE_CLASS);
			} else {
				_tmp190_ = FALSE;
			}
			if (_tmp190_) {
				ValaExpression* _tmp201_;
				ValaExpression* _tmp202_;
				ValaSymbol* _tmp203_;
				ValaSymbol* _tmp204_;
				ValaCreationMethod* _tmp205_;
				ValaCreationMethod* _tmp206_;
				gboolean _tmp207_;
				gboolean _tmp208_;
				_tmp201_ = vala_method_call_get_call (self);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_expression_get_symbol_reference (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp205_;
				_tmp206_ = base_cm;
				_tmp207_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp206_);
				_tmp208_ = _tmp207_;
				if (!_tmp208_) {
					ValaSourceReference* _tmp209_;
					ValaSourceReference* _tmp210_;
					ValaCreationMethod* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					gchar* _tmp215_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp210_ = _tmp209_;
					_tmp211_ = base_cm;
					_tmp212_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp211_);
					_tmp213_ = _tmp212_;
					_tmp214_ = g_strdup_printf ("chain up to `%s' not supported", _tmp213_);
					_tmp215_ = _tmp214_;
					vala_report_error (_tmp210_, _tmp215_);
					_g_free0 (_tmp215_);
					_g_free0 (_tmp213_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				gboolean _tmp216_;
				_tmp216_ = gobject_chainup;
				if (_tmp216_) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp217_;
					ValaSymbol* _tmp218_;
					ValaSymbol* _tmp219_;
					ValaClass* _tmp220_;
					gboolean _tmp221_ = FALSE;
					ValaClass* _tmp222_;
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaSemanticAnalyzer* _tmp231_;
					ValaSemanticAnalyzer* _tmp232_;
					ValaClass* _tmp233_;
					ValaObjectType* _tmp234_;
					ValaObjectType* _tmp235_;
					ValaExpression* _tmp236_;
					ValaExpression* _tmp237_;
					ValaDataType* _tmp238_;
					ValaDataType* _tmp239_;
					ValaDataType* _tmp240_;
					_tmp217_ = cm;
					_tmp218_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp219_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp219_) : NULL);
					cl = _tmp220_;
					_tmp222_ = cl;
					if (_tmp222_ == NULL) {
						_tmp221_ = TRUE;
					} else {
						ValaClass* _tmp223_;
						ValaSemanticAnalyzer* _tmp224_;
						ValaSemanticAnalyzer* _tmp225_;
						ValaClass* _tmp226_;
						_tmp223_ = cl;
						_tmp224_ = vala_code_context_get_analyzer (context);
						_tmp225_ = _tmp224_;
						_tmp226_ = _tmp225_->object_type;
						_tmp221_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp223_, (ValaTypeSymbol*) _tmp226_);
					}
					if (_tmp221_) {
						ValaSourceReference* _tmp227_;
						ValaSourceReference* _tmp228_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp228_ = _tmp227_;
						vala_report_error (_tmp228_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp229_ = vala_method_call_get_call (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_code_context_get_analyzer (context);
					_tmp232_ = _tmp231_;
					_tmp233_ = _tmp232_->object_type;
					_tmp234_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp233_);
					_tmp235_ = _tmp234_;
					vala_expression_set_value_type (_tmp230_, (ValaDataType*) _tmp235_);
					_vala_code_node_unref0 (_tmp235_);
					_tmp236_ = vala_method_call_get_call (self);
					_tmp237_ = _tmp236_;
					_tmp238_ = vala_expression_get_value_type (_tmp237_);
					_tmp239_ = _tmp238_;
					_tmp240_ = _vala_code_node_ref0 (_tmp239_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp240_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp242_ = vala_method_call_get_call (self);
	_tmp243_ = _tmp242_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp243_, VALA_TYPE_MEMBER_ACCESS)) {
		gboolean _tmp244_ = FALSE;
		gboolean _tmp245_ = FALSE;
		ValaExpression* _tmp246_;
		ValaExpression* _tmp247_;
		ValaSymbol* _tmp248_;
		ValaSymbol* _tmp249_;
		_tmp246_ = vala_method_call_get_call (self);
		_tmp247_ = _tmp246_;
		_tmp248_ = vala_expression_get_symbol_reference (_tmp247_);
		_tmp249_ = _tmp248_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp249_, VALA_TYPE_CREATION_METHOD)) {
			ValaExpression* _tmp250_;
			ValaExpression* _tmp251_;
			ValaSymbol* _tmp252_;
			ValaSymbol* _tmp253_;
			ValaSymbol* _tmp254_;
			ValaSymbol* _tmp255_;
			_tmp250_ = vala_method_call_get_call (self);
			_tmp251_ = _tmp250_;
			_tmp252_ = vala_expression_get_symbol_reference (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_symbol_get_parent_symbol (_tmp253_);
			_tmp255_ = _tmp254_;
			_tmp245_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp255_, VALA_TYPE_STRUCT);
		} else {
			_tmp245_ = FALSE;
		}
		if (_tmp245_) {
			_tmp244_ = TRUE;
		} else {
			ValaExpression* _tmp256_;
			ValaExpression* _tmp257_;
			ValaSymbol* _tmp258_;
			ValaSymbol* _tmp259_;
			_tmp256_ = vala_method_call_get_call (self);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_expression_get_symbol_reference (_tmp257_);
			_tmp259_ = _tmp258_;
			_tmp244_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp259_, VALA_TYPE_STRUCT);
		}
		_tmp241_ = _tmp244_;
	} else {
		_tmp241_ = FALSE;
	}
	if (_tmp241_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp260_;
		ValaExpression* _tmp261_;
		ValaSymbol* _tmp262_;
		ValaSymbol* _tmp263_;
		ValaStruct* _tmp264_;
		gboolean _tmp265_ = FALSE;
		gboolean _tmp266_ = FALSE;
		ValaStruct* _tmp267_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp278_;
		ValaExpression* _tmp279_;
		ValaSourceReference* _tmp280_;
		ValaSourceReference* _tmp281_;
		ValaObjectCreationExpression* _tmp282_;
		ValaObjectCreationExpression* _tmp283_;
		ValaObjectCreationExpression* _tmp296_;
		ValaDataType* _tmp297_;
		ValaDataType* _tmp298_;
		ValaSemanticAnalyzer* _tmp299_;
		ValaSemanticAnalyzer* _tmp300_;
		ValaList* _tmp301_;
		ValaCodeNode* _tmp302_;
		ValaCodeNode* _tmp303_;
		ValaObjectCreationExpression* _tmp304_;
		ValaObjectCreationExpression* _tmp305_;
		_tmp260_ = vala_method_call_get_call (self);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_expression_get_symbol_reference (_tmp261_);
		_tmp263_ = _tmp262_;
		_tmp264_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp263_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp263_) : NULL);
		st = _tmp264_;
		_tmp267_ = st;
		if (_tmp267_ != NULL) {
			ValaStruct* _tmp268_;
			ValaMethod* _tmp269_;
			ValaMethod* _tmp270_;
			_tmp268_ = st;
			_tmp269_ = vala_struct_get_default_construction_method (_tmp268_);
			_tmp270_ = _tmp269_;
			_tmp266_ = _tmp270_ == NULL;
		} else {
			_tmp266_ = FALSE;
		}
		if (_tmp266_) {
			gboolean _tmp271_ = FALSE;
			gboolean _tmp272_ = FALSE;
			ValaStruct* _tmp273_;
			_tmp273_ = st;
			if (vala_struct_is_boolean_type (_tmp273_)) {
				_tmp272_ = TRUE;
			} else {
				ValaStruct* _tmp274_;
				_tmp274_ = st;
				_tmp272_ = vala_struct_is_integer_type (_tmp274_);
			}
			if (_tmp272_) {
				_tmp271_ = TRUE;
			} else {
				ValaStruct* _tmp275_;
				_tmp275_ = st;
				_tmp271_ = vala_struct_is_floating_type (_tmp275_);
			}
			_tmp265_ = _tmp271_;
		} else {
			_tmp265_ = FALSE;
		}
		if (_tmp265_) {
			ValaSourceReference* _tmp276_;
			ValaSourceReference* _tmp277_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp277_ = _tmp276_;
			vala_report_error (_tmp277_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp278_ = vala_method_call_get_call (self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp281_ = _tmp280_;
		_tmp282_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp279_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp281_);
		struct_creation_expression = _tmp282_;
		_tmp283_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp283_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp284_;
			gint _arg_size = 0;
			ValaList* _tmp285_;
			gint _tmp286_;
			gint _tmp287_;
			gint _arg_index = 0;
			_tmp284_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp284_;
			_tmp285_ = _arg_list;
			_tmp286_ = vala_collection_get_size ((ValaCollection*) _tmp285_);
			_tmp287_ = _tmp286_;
			_arg_size = _tmp287_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp288_;
				gint _tmp289_;
				gint _tmp290_;
				ValaExpression* arg = NULL;
				ValaList* _tmp291_;
				gint _tmp292_;
				gpointer _tmp293_;
				ValaObjectCreationExpression* _tmp294_;
				ValaExpression* _tmp295_;
				_tmp288_ = _arg_index;
				_arg_index = _tmp288_ + 1;
				_tmp289_ = _arg_index;
				_tmp290_ = _arg_size;
				if (!(_tmp289_ < _tmp290_)) {
					break;
				}
				_tmp291_ = _arg_list;
				_tmp292_ = _arg_index;
				_tmp293_ = vala_list_get (_tmp291_, _tmp292_);
				arg = (ValaExpression*) _tmp293_;
				_tmp294_ = struct_creation_expression;
				_tmp295_ = arg;
				vala_object_creation_expression_add_argument (_tmp294_, _tmp295_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp296_ = struct_creation_expression;
		_tmp297_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp298_ = _tmp297_;
		vala_expression_set_target_type ((ValaExpression*) _tmp296_, _tmp298_);
		_tmp299_ = vala_code_context_get_analyzer (context);
		_tmp300_ = _tmp299_;
		_tmp301_ = _tmp300_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp301_, (ValaCodeNode*) self);
		_tmp302_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp303_ = _tmp302_;
		_tmp304_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp303_, (ValaExpression*) self, (ValaExpression*) _tmp304_);
		_tmp305_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp305_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp306_ = FALSE;
		gboolean _tmp307_ = FALSE;
		gboolean _tmp308_;
		_tmp308_ = self->priv->_is_chainup;
		if (!_tmp308_) {
			ValaExpression* _tmp309_;
			ValaExpression* _tmp310_;
			_tmp309_ = vala_method_call_get_call (self);
			_tmp310_ = _tmp309_;
			_tmp307_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp310_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp307_ = FALSE;
		}
		if (_tmp307_) {
			ValaExpression* _tmp311_;
			ValaExpression* _tmp312_;
			ValaSymbol* _tmp313_;
			ValaSymbol* _tmp314_;
			_tmp311_ = vala_method_call_get_call (self);
			_tmp312_ = _tmp311_;
			_tmp313_ = vala_expression_get_symbol_reference (_tmp312_);
			_tmp314_ = _tmp313_;
			_tmp306_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp314_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp306_ = FALSE;
		}
		if (_tmp306_) {
			ValaSourceReference* _tmp315_;
			ValaSourceReference* _tmp316_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp315_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp316_ = _tmp315_;
			vala_report_error (_tmp316_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp318_ = self->priv->_is_chainup;
	if (!_tmp318_) {
		ValaDataType* _tmp319_;
		_tmp319_ = mtype;
		_tmp317_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, VALA_TYPE_OBJECT_TYPE);
	} else {
		_tmp317_ = FALSE;
	}
	if (_tmp317_) {
		ValaSourceReference* _tmp320_;
		ValaSourceReference* _tmp321_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp321_ = _tmp320_;
		vala_report_error (_tmp321_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp322_ = FALSE;
		ValaDataType* _tmp323_;
		_tmp323_ = mtype;
		if (_tmp323_ != NULL) {
			ValaDataType* _tmp324_;
			_tmp324_ = mtype;
			_tmp322_ = vala_data_type_is_invokable (_tmp324_);
		} else {
			_tmp322_ = FALSE;
		}
		if (_tmp322_) {
		} else {
			ValaExpression* _tmp325_;
			ValaExpression* _tmp326_;
			ValaSymbol* _tmp327_;
			ValaSymbol* _tmp328_;
			_tmp325_ = vala_method_call_get_call (self);
			_tmp326_ = _tmp325_;
			_tmp327_ = vala_expression_get_symbol_reference (_tmp326_);
			_tmp328_ = _tmp327_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp328_, VALA_TYPE_CLASS)) {
				ValaSourceReference* _tmp329_;
				ValaSourceReference* _tmp330_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp329_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp330_ = _tmp329_;
				vala_report_error (_tmp330_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp331_;
				ValaSourceReference* _tmp332_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp331_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp332_ = _tmp331_;
				vala_report_error (_tmp332_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp333_ = mtype;
	_tmp334_ = vala_data_type_get_return_type (_tmp333_);
	ret_type = _tmp334_;
	_tmp335_ = mtype;
	_tmp336_ = vala_data_type_get_parameters (_tmp335_);
	params = _tmp336_;
	_tmp337_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp337_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp338_;
		ValaMethod* _tmp339_;
		ValaMethod* _tmp340_;
		ValaMethod* _tmp341_;
		gboolean _tmp342_ = FALSE;
		ValaMethod* _tmp343_;
		ValaMethod* _tmp380_;
		_tmp338_ = mtype;
		_tmp339_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp338_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp340_ = _tmp339_;
		_tmp341_ = _vala_code_node_ref0 (_tmp340_);
		m = _tmp341_;
		_tmp343_ = m;
		if (_tmp343_ != NULL) {
			ValaMethod* _tmp344_;
			gboolean _tmp345_;
			gboolean _tmp346_;
			_tmp344_ = m;
			_tmp345_ = vala_method_get_coroutine (_tmp344_);
			_tmp346_ = _tmp345_;
			_tmp342_ = _tmp346_;
		} else {
			_tmp342_ = FALSE;
		}
		if (_tmp342_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp347_;
			ValaExpression* _tmp348_;
			ValaMemberAccess* _tmp349_;
			gboolean _tmp350_;
			_tmp347_ = vala_method_call_get_call (self);
			_tmp348_ = _tmp347_;
			_tmp349_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp348_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp349_;
			_tmp350_ = self->priv->_is_yield_expression;
			if (!_tmp350_) {
				ValaMemberAccess* _tmp351_;
				const gchar* _tmp352_;
				const gchar* _tmp353_;
				_tmp351_ = ma;
				_tmp352_ = vala_member_access_get_member_name (_tmp351_);
				_tmp353_ = _tmp352_;
				if (g_strcmp0 (_tmp353_, "end") != 0) {
					ValaMemberAccess* _tmp354_;
					const gchar* _tmp355_;
					const gchar* _tmp356_;
					ValaMethod* _tmp360_;
					ValaList* _tmp361_;
					ValaVoidType* _tmp362_;
					_tmp354_ = ma;
					_tmp355_ = vala_member_access_get_member_name (_tmp354_);
					_tmp356_ = _tmp355_;
					if (g_strcmp0 (_tmp356_, "begin") != 0) {
						ValaMemberAccess* _tmp357_;
						ValaSourceReference* _tmp358_;
						ValaSourceReference* _tmp359_;
						_tmp357_ = ma;
						_tmp358_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp357_);
						_tmp359_ = _tmp358_;
						vala_report_deprecated (_tmp359_, "implicit .begin is deprecated");
					}
					_tmp360_ = m;
					_tmp361_ = vala_method_get_async_begin_parameters (_tmp360_);
					_vala_iterable_unref0 (params);
					params = _tmp361_;
					_tmp362_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp362_;
				} else {
					ValaMethod* _tmp363_;
					ValaList* _tmp364_;
					_tmp363_ = m;
					_tmp364_ = vala_method_get_async_end_parameters (_tmp363_);
					_vala_iterable_unref0 (params);
					params = _tmp364_;
				}
			} else {
				gboolean _tmp365_ = FALSE;
				ValaMemberAccess* _tmp366_;
				const gchar* _tmp367_;
				const gchar* _tmp368_;
				_tmp366_ = ma;
				_tmp367_ = vala_member_access_get_member_name (_tmp366_);
				_tmp368_ = _tmp367_;
				if (g_strcmp0 (_tmp368_, "begin") == 0) {
					_tmp365_ = TRUE;
				} else {
					ValaMemberAccess* _tmp369_;
					const gchar* _tmp370_;
					const gchar* _tmp371_;
					_tmp369_ = ma;
					_tmp370_ = vala_member_access_get_member_name (_tmp369_);
					_tmp371_ = _tmp370_;
					_tmp365_ = g_strcmp0 (_tmp371_, "end") == 0;
				}
				if (_tmp365_) {
					ValaMemberAccess* _tmp372_;
					ValaSourceReference* _tmp373_;
					ValaSourceReference* _tmp374_;
					ValaMemberAccess* _tmp375_;
					const gchar* _tmp376_;
					const gchar* _tmp377_;
					gchar* _tmp378_;
					gchar* _tmp379_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp372_ = ma;
					_tmp373_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp372_);
					_tmp374_ = _tmp373_;
					_tmp375_ = ma;
					_tmp376_ = vala_member_access_get_member_name (_tmp375_);
					_tmp377_ = _tmp376_;
					_tmp378_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp377_);
					_tmp379_ = _tmp378_;
					vala_report_error (_tmp374_, _tmp379_);
					_g_free0 (_tmp379_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp380_ = m;
		if (_tmp380_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp381_;
			ValaExpression* _tmp382_;
			ValaMemberAccess* _tmp383_;
			gint n_type_params = 0;
			ValaMethod* _tmp384_;
			ValaList* _tmp385_;
			ValaList* _tmp386_;
			gint _tmp387_;
			gint _tmp388_;
			gint _tmp389_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp390_;
			ValaList* _tmp391_;
			ValaList* _tmp392_;
			gint _tmp393_;
			gint _tmp394_;
			gint _tmp395_;
			gboolean _tmp396_ = FALSE;
			gint _tmp397_;
			_tmp381_ = vala_method_call_get_call (self);
			_tmp382_ = _tmp381_;
			_tmp383_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp382_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp383_;
			_tmp384_ = m;
			_tmp385_ = vala_method_get_type_parameters (_tmp384_);
			_tmp386_ = _tmp385_;
			_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
			_tmp388_ = _tmp387_;
			_tmp389_ = _tmp388_;
			_vala_iterable_unref0 (_tmp386_);
			n_type_params = _tmp389_;
			_tmp390_ = ma;
			_tmp391_ = vala_member_access_get_type_arguments (_tmp390_);
			_tmp392_ = _tmp391_;
			_tmp393_ = vala_collection_get_size ((ValaCollection*) _tmp392_);
			_tmp394_ = _tmp393_;
			_tmp395_ = _tmp394_;
			_vala_iterable_unref0 (_tmp392_);
			n_type_args = _tmp395_;
			_tmp397_ = n_type_args;
			if (_tmp397_ > 0) {
				gint _tmp398_;
				gint _tmp399_;
				_tmp398_ = n_type_args;
				_tmp399_ = n_type_params;
				_tmp396_ = _tmp398_ < _tmp399_;
			} else {
				_tmp396_ = FALSE;
			}
			if (_tmp396_) {
				ValaMemberAccess* _tmp400_;
				ValaSourceReference* _tmp401_;
				ValaSourceReference* _tmp402_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp400_ = ma;
				_tmp401_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp400_);
				_tmp402_ = _tmp401_;
				vala_report_error (_tmp402_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp403_ = FALSE;
				gint _tmp404_;
				_tmp404_ = n_type_args;
				if (_tmp404_ > 0) {
					gint _tmp405_;
					gint _tmp406_;
					_tmp405_ = n_type_args;
					_tmp406_ = n_type_params;
					_tmp403_ = _tmp405_ > _tmp406_;
				} else {
					_tmp403_ = FALSE;
				}
				if (_tmp403_) {
					ValaMemberAccess* _tmp407_;
					ValaSourceReference* _tmp408_;
					ValaSourceReference* _tmp409_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp407_ = ma;
					_tmp408_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp407_);
					_tmp409_ = _tmp408_;
					vala_report_error (_tmp409_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp410_ = vala_method_call_get_argument_list (self);
	args = _tmp410_;
	_tmp411_ = args;
	_tmp412_ = vala_iterable_iterator ((ValaIterable*) _tmp411_);
	arg_it = _tmp412_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp413_;
		ValaList* _tmp414_;
		gint _param_size = 0;
		ValaList* _tmp415_;
		gint _tmp416_;
		gint _tmp417_;
		gint _param_index = 0;
		_tmp413_ = params;
		_tmp414_ = _vala_iterable_ref0 (_tmp413_);
		_param_list = _tmp414_;
		_tmp415_ = _param_list;
		_tmp416_ = vala_collection_get_size ((ValaCollection*) _tmp415_);
		_tmp417_ = _tmp416_;
		_param_size = _tmp417_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp418_;
			gint _tmp419_;
			gint _tmp420_;
			ValaParameter* param = NULL;
			ValaList* _tmp421_;
			gint _tmp422_;
			gpointer _tmp423_;
			ValaParameter* _tmp424_;
			ValaParameter* _tmp425_;
			gboolean _tmp426_;
			gboolean _tmp427_;
			ValaParameter* _tmp428_;
			gboolean _tmp429_;
			gboolean _tmp430_;
			ValaIterator* _tmp448_;
			_tmp418_ = _param_index;
			_param_index = _tmp418_ + 1;
			_tmp419_ = _param_index;
			_tmp420_ = _param_size;
			if (!(_tmp419_ < _tmp420_)) {
				break;
			}
			_tmp421_ = _param_list;
			_tmp422_ = _param_index;
			_tmp423_ = vala_list_get (_tmp421_, _tmp422_);
			param = (ValaParameter*) _tmp423_;
			_tmp424_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp424_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp425_ = param;
			_tmp426_ = vala_parameter_get_ellipsis (_tmp425_);
			_tmp427_ = _tmp426_;
			if (_tmp427_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp428_ = param;
			_tmp429_ = vala_parameter_get_params_array (_tmp428_);
			_tmp430_ = _tmp429_;
			if (_tmp430_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp431_;
				ValaDataType* _tmp432_;
				ValaDataType* _tmp433_;
				ValaArrayType* _tmp434_;
				_tmp431_ = param;
				_tmp432_ = vala_variable_get_variable_type ((ValaVariable*) _tmp431_);
				_tmp433_ = _tmp432_;
				_tmp434_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp433_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp434_;
				while (TRUE) {
					ValaIterator* _tmp435_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp436_;
					gpointer _tmp437_;
					ValaExpression* _tmp438_;
					ValaArrayType* _tmp439_;
					ValaDataType* _tmp440_;
					ValaDataType* _tmp441_;
					ValaExpression* _tmp442_;
					ValaDataType* _tmp443_;
					ValaDataType* _tmp444_;
					ValaArrayType* _tmp445_;
					gboolean _tmp446_;
					gboolean _tmp447_;
					_tmp435_ = arg_it;
					if (!vala_iterator_next (_tmp435_)) {
						break;
					}
					_tmp436_ = arg_it;
					_tmp437_ = vala_iterator_get (_tmp436_);
					arg = (ValaExpression*) _tmp437_;
					_tmp438_ = arg;
					_tmp439_ = array_type;
					_tmp440_ = vala_array_type_get_element_type (_tmp439_);
					_tmp441_ = _tmp440_;
					vala_expression_set_target_type (_tmp438_, _tmp441_);
					_tmp442_ = arg;
					_tmp443_ = vala_expression_get_target_type (_tmp442_);
					_tmp444_ = _tmp443_;
					_tmp445_ = array_type;
					_tmp446_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp445_);
					_tmp447_ = _tmp446_;
					vala_data_type_set_value_owned (_tmp444_, _tmp447_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp448_ = arg_it;
			if (vala_iterator_next (_tmp448_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp449_;
				gpointer _tmp450_;
				ValaExpression* _tmp451_;
				ValaParameter* _tmp452_;
				ValaDataType* _tmp453_;
				ValaDataType* _tmp454_;
				ValaExpression* _tmp455_;
				ValaExpression* _tmp456_;
				ValaDataType* _tmp457_;
				ValaDataType* _tmp458_;
				ValaDataType* _tmp459_;
				ValaList* _tmp460_;
				ValaDataType* _tmp461_;
				ValaDataType* _tmp462_;
				ValaExpression* _tmp463_;
				ValaExpression* _tmp464_;
				_tmp449_ = arg_it;
				_tmp450_ = vala_iterator_get (_tmp449_);
				arg = (ValaExpression*) _tmp450_;
				_tmp451_ = arg;
				_tmp452_ = param;
				_tmp453_ = vala_variable_get_variable_type ((ValaVariable*) _tmp452_);
				_tmp454_ = _tmp453_;
				vala_expression_set_formal_target_type (_tmp451_, _tmp454_);
				_tmp455_ = arg;
				_tmp456_ = arg;
				_tmp457_ = vala_expression_get_formal_target_type (_tmp456_);
				_tmp458_ = _tmp457_;
				_tmp459_ = target_object_type;
				_tmp460_ = method_type_args;
				_tmp461_ = vala_data_type_get_actual_type (_tmp458_, _tmp459_, _tmp460_, (ValaCodeNode*) self);
				_tmp462_ = _tmp461_;
				vala_expression_set_target_type (_tmp455_, _tmp462_);
				_vala_code_node_unref0 (_tmp462_);
				_tmp463_ = arg;
				_tmp464_ = _vala_code_node_ref0 (_tmp463_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp464_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp466_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp466_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp467_;
		ValaMethod* _tmp468_;
		ValaMethod* _tmp469_;
		ValaAttribute* _tmp470_;
		_tmp467_ = mtype;
		_tmp468_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp467_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp469_, "Print");
		_tmp465_ = _tmp470_ != NULL;
	} else {
		_tmp465_ = FALSE;
	}
	if (_tmp465_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp471_;
		ValaSourceReference* _tmp472_;
		ValaTemplate* _tmp473_;
		ValaList* _tmp488_;
		ValaTemplate* _tmp489_;
		_tmp471_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp472_ = _tmp471_;
		_tmp473_ = vala_template_new (_tmp472_);
		template = _tmp473_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp474_;
			ValaList* _tmp475_;
			gint _arg_size = 0;
			ValaList* _tmp476_;
			gint _tmp477_;
			gint _tmp478_;
			gint _arg_index = 0;
			_tmp474_ = self->priv->argument_list;
			_tmp475_ = _vala_iterable_ref0 (_tmp474_);
			_arg_list = _tmp475_;
			_tmp476_ = _arg_list;
			_tmp477_ = vala_collection_get_size ((ValaCollection*) _tmp476_);
			_tmp478_ = _tmp477_;
			_arg_size = _tmp478_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp479_;
				gint _tmp480_;
				gint _tmp481_;
				ValaExpression* arg = NULL;
				ValaList* _tmp482_;
				gint _tmp483_;
				gpointer _tmp484_;
				ValaExpression* _tmp485_;
				ValaTemplate* _tmp486_;
				ValaExpression* _tmp487_;
				_tmp479_ = _arg_index;
				_arg_index = _tmp479_ + 1;
				_tmp480_ = _arg_index;
				_tmp481_ = _arg_size;
				if (!(_tmp480_ < _tmp481_)) {
					break;
				}
				_tmp482_ = _arg_list;
				_tmp483_ = _arg_index;
				_tmp484_ = vala_list_get (_tmp482_, _tmp483_);
				arg = (ValaExpression*) _tmp484_;
				_tmp485_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp485_, NULL);
				_tmp486_ = template;
				_tmp487_ = arg;
				vala_template_add_expression (_tmp486_, _tmp487_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp488_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp488_);
		_tmp489_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp489_);
		_vala_code_node_unref0 (template);
	}
	_tmp491_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp491_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp492_;
		ValaMethod* _tmp493_;
		ValaMethod* _tmp494_;
		gboolean _tmp495_;
		gboolean _tmp496_;
		_tmp492_ = mtype;
		_tmp493_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp492_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp494_ = _tmp493_;
		_tmp495_ = vala_method_get_printf_format (_tmp494_);
		_tmp496_ = _tmp495_;
		_tmp490_ = _tmp496_;
	} else {
		_tmp490_ = FALSE;
	}
	if (_tmp490_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp497_;
		ValaStringLiteral* _tmp546_;
		format_literal = NULL;
		_tmp497_ = last_arg;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp497_, VALA_TYPE_NULL_LITERAL)) {
		} else {
			ValaExpression* _tmp498_;
			_tmp498_ = last_arg;
			if (_tmp498_ != NULL) {
				ValaExpression* _tmp499_;
				ValaStringLiteral* _tmp500_;
				gboolean _tmp501_ = FALSE;
				ValaStringLiteral* _tmp502_;
				_tmp499_ = last_arg;
				_tmp500_ = vala_string_literal_get_format_literal (_tmp499_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp500_;
				_tmp502_ = format_literal;
				if (_tmp502_ == NULL) {
					ValaList* _tmp503_;
					gint _tmp504_;
					gint _tmp505_;
					ValaList* _tmp506_;
					gint _tmp507_;
					gint _tmp508_;
					_tmp503_ = args;
					_tmp504_ = vala_collection_get_size ((ValaCollection*) _tmp503_);
					_tmp505_ = _tmp504_;
					_tmp506_ = params;
					_tmp507_ = vala_collection_get_size ((ValaCollection*) _tmp506_);
					_tmp508_ = _tmp507_;
					_tmp501_ = _tmp505_ == (_tmp508_ - 1);
				} else {
					_tmp501_ = FALSE;
				}
				if (_tmp501_) {
					ValaStringLiteral* _tmp509_;
					ValaStringLiteral* _tmp510_;
					ValaSemanticAnalyzer* _tmp511_;
					ValaSemanticAnalyzer* _tmp512_;
					ValaDataType* _tmp513_;
					ValaDataType* _tmp514_;
					ValaDataType* _tmp515_;
					ValaList* _tmp516_;
					ValaList* _tmp517_;
					gint _tmp518_;
					gint _tmp519_;
					ValaStringLiteral* _tmp520_;
					ValaList* _tmp521_;
					ValaIterator* _tmp522_;
					_tmp509_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp509_;
					_tmp510_ = format_literal;
					_tmp511_ = vala_code_context_get_analyzer (context);
					_tmp512_ = _tmp511_;
					_tmp513_ = _tmp512_->string_type;
					_tmp514_ = vala_data_type_copy (_tmp513_);
					_tmp515_ = _tmp514_;
					vala_expression_set_target_type ((ValaExpression*) _tmp510_, _tmp515_);
					_vala_code_node_unref0 (_tmp515_);
					_tmp516_ = self->priv->argument_list;
					_tmp517_ = args;
					_tmp518_ = vala_collection_get_size ((ValaCollection*) _tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = format_literal;
					vala_list_insert (_tmp516_, _tmp519_ - 1, (ValaExpression*) _tmp520_);
					_tmp521_ = self->priv->argument_list;
					_tmp522_ = vala_iterable_iterator ((ValaIterable*) _tmp521_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp522_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp523_;
						ValaList* _tmp524_;
						gint _param_size = 0;
						ValaList* _tmp525_;
						gint _tmp526_;
						gint _tmp527_;
						gint _param_index = 0;
						_tmp523_ = params;
						_tmp524_ = _vala_iterable_ref0 (_tmp523_);
						_param_list = _tmp524_;
						_tmp525_ = _param_list;
						_tmp526_ = vala_collection_get_size ((ValaCollection*) _tmp525_);
						_tmp527_ = _tmp526_;
						_param_size = _tmp527_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp528_;
							gint _tmp529_;
							gint _tmp530_;
							ValaParameter* param = NULL;
							ValaList* _tmp531_;
							gint _tmp532_;
							gpointer _tmp533_;
							ValaParameter* _tmp534_;
							gboolean _tmp535_;
							gboolean _tmp536_;
							ValaIterator* _tmp537_;
							_tmp528_ = _param_index;
							_param_index = _tmp528_ + 1;
							_tmp529_ = _param_index;
							_tmp530_ = _param_size;
							if (!(_tmp529_ < _tmp530_)) {
								break;
							}
							_tmp531_ = _param_list;
							_tmp532_ = _param_index;
							_tmp533_ = vala_list_get (_tmp531_, _tmp532_);
							param = (ValaParameter*) _tmp533_;
							_tmp534_ = param;
							_tmp535_ = vala_parameter_get_ellipsis (_tmp534_);
							_tmp536_ = _tmp535_;
							if (_tmp536_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp537_ = arg_it;
							vala_iterator_next (_tmp537_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp538_;
				ValaExpression* _tmp539_;
				ValaMemberAccess* _tmp540_;
				ValaMemberAccess* _tmp541_;
				_tmp538_ = vala_method_call_get_call (self);
				_tmp539_ = _tmp538_;
				_tmp540_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp539_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp539_) : NULL);
				ma = _tmp540_;
				_tmp541_ = ma;
				if (_tmp541_ != NULL) {
					ValaMemberAccess* _tmp542_;
					ValaExpression* _tmp543_;
					ValaExpression* _tmp544_;
					ValaStringLiteral* _tmp545_;
					_tmp542_ = ma;
					_tmp543_ = vala_member_access_get_inner (_tmp542_);
					_tmp544_ = _tmp543_;
					_tmp545_ = vala_string_literal_get_format_literal (_tmp544_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp545_;
				}
				_vala_code_node_unref0 (ma);
			}
		}
		_tmp546_ = format_literal;
		if (_tmp546_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp547_;
			gchar* _tmp548_;
			ValaSemanticAnalyzer* _tmp549_;
			ValaSemanticAnalyzer* _tmp550_;
			const gchar* _tmp551_;
			ValaIterator* _tmp552_;
			ValaSourceReference* _tmp553_;
			ValaSourceReference* _tmp554_;
			_tmp547_ = format_literal;
			_tmp548_ = vala_string_literal_eval (_tmp547_);
			format = _tmp548_;
			_tmp549_ = vala_code_context_get_analyzer (context);
			_tmp550_ = _tmp549_;
			_tmp551_ = format;
			_tmp552_ = arg_it;
			_tmp553_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp554_ = _tmp553_;
			if (!vala_semantic_analyzer_check_print_format (_tmp550_, _tmp551_, _tmp552_, _tmp554_)) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp555_;
		gint _arg_size = 0;
		ValaList* _tmp556_;
		gint _tmp557_;
		gint _tmp558_;
		gint _arg_index = 0;
		_tmp555_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp555_;
		_tmp556_ = _arg_list;
		_tmp557_ = vala_collection_get_size ((ValaCollection*) _tmp556_);
		_tmp558_ = _tmp557_;
		_arg_size = _tmp558_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp559_;
			gint _tmp560_;
			gint _tmp561_;
			ValaExpression* arg = NULL;
			ValaList* _tmp562_;
			gint _tmp563_;
			gpointer _tmp564_;
			ValaExpression* _tmp565_;
			_tmp559_ = _arg_index;
			_arg_index = _tmp559_ + 1;
			_tmp560_ = _arg_index;
			_tmp561_ = _arg_size;
			if (!(_tmp560_ < _tmp561_)) {
				break;
			}
			_tmp562_ = _arg_list;
			_tmp563_ = _arg_index;
			_tmp564_ = vala_list_get (_tmp562_, _tmp563_);
			arg = (ValaExpression*) _tmp564_;
			_tmp565_ = arg;
			vala_code_node_check ((ValaCodeNode*) _tmp565_, context);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp566_ = ret_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp566_, VALA_TYPE_VOID_TYPE)) {
		gboolean _tmp567_ = FALSE;
		gboolean _tmp568_ = FALSE;
		ValaCodeNode* _tmp569_;
		ValaCodeNode* _tmp570_;
		_tmp569_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp570_ = _tmp569_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp570_, VALA_TYPE_EXPRESSION_STATEMENT)) {
			ValaCodeNode* _tmp571_;
			ValaCodeNode* _tmp572_;
			_tmp571_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp572_ = _tmp571_;
			_tmp568_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp572_, VALA_TYPE_FOR_STATEMENT);
		} else {
			_tmp568_ = FALSE;
		}
		if (_tmp568_) {
			ValaCodeNode* _tmp573_;
			ValaCodeNode* _tmp574_;
			_tmp573_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp574_ = _tmp573_;
			_tmp567_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp574_, VALA_TYPE_YIELD_STATEMENT);
		} else {
			_tmp567_ = FALSE;
		}
		if (_tmp567_) {
			ValaSourceReference* _tmp575_;
			ValaSourceReference* _tmp576_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp575_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp576_ = _tmp575_;
			vala_report_error (_tmp576_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp577_ = ret_type;
	_tmp578_ = vala_data_type_copy (_tmp577_);
	_tmp579_ = _tmp578_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp579_);
	_vala_code_node_unref0 (_tmp579_);
	_tmp580_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp581_ = _tmp580_;
	_tmp582_ = target_object_type;
	_tmp583_ = method_type_args;
	_tmp584_ = vala_data_type_get_actual_type (_tmp581_, _tmp582_, _tmp583_, (ValaCodeNode*) self);
	_tmp585_ = _tmp584_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp585_);
	_vala_code_node_unref0 (_tmp585_);
	may_throw = FALSE;
	_tmp586_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp586_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp587_;
		ValaMethod* _tmp588_;
		ValaMethod* _tmp589_;
		ValaMethod* _tmp590_;
		gboolean _tmp591_;
		gboolean _tmp610_ = FALSE;
		gboolean _tmp611_ = FALSE;
		gboolean _tmp612_ = FALSE;
		ValaMethod* _tmp613_;
		ValaMethod* _tmp639_;
		gboolean _tmp640_;
		gboolean _tmp641_;
		ValaMethod* _tmp644_;
		gboolean _tmp645_;
		gboolean _tmp646_;
		gboolean _tmp651_ = FALSE;
		gboolean _tmp652_ = FALSE;
		gboolean _tmp653_ = FALSE;
		gboolean _tmp654_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp666_;
		ValaSymbol* _tmp667_;
		ValaSymbol* _tmp668_;
		ValaDynamicSignal* _tmp669_;
		gboolean _tmp670_ = FALSE;
		ValaDynamicSignal* _tmp671_;
		gboolean _tmp718_ = FALSE;
		ValaMethod* _tmp719_;
		gboolean _tmp844_ = FALSE;
		ValaMethod* _tmp845_;
		_tmp587_ = mtype;
		_tmp588_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp587_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp589_ = _tmp588_;
		_tmp590_ = _vala_code_node_ref0 (_tmp589_);
		m = _tmp590_;
		_tmp591_ = self->priv->_is_yield_expression;
		if (_tmp591_) {
			ValaMethod* _tmp592_;
			gboolean _tmp593_;
			gboolean _tmp594_;
			gboolean _tmp597_ = FALSE;
			ValaSemanticAnalyzer* _tmp598_;
			ValaSemanticAnalyzer* _tmp599_;
			ValaMethod* _tmp600_;
			ValaMethod* _tmp601_;
			_tmp592_ = m;
			_tmp593_ = vala_method_get_coroutine (_tmp592_);
			_tmp594_ = _tmp593_;
			if (!_tmp594_) {
				ValaSourceReference* _tmp595_;
				ValaSourceReference* _tmp596_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp595_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp596_ = _tmp595_;
				vala_report_error (_tmp596_, "yield expression requires async method");
			}
			_tmp598_ = vala_code_context_get_analyzer (context);
			_tmp599_ = _tmp598_;
			_tmp600_ = vala_semantic_analyzer_get_current_method (_tmp599_);
			_tmp601_ = _tmp600_;
			if (_tmp601_ == NULL) {
				_tmp597_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp602_;
				ValaSemanticAnalyzer* _tmp603_;
				ValaMethod* _tmp604_;
				ValaMethod* _tmp605_;
				gboolean _tmp606_;
				gboolean _tmp607_;
				_tmp602_ = vala_code_context_get_analyzer (context);
				_tmp603_ = _tmp602_;
				_tmp604_ = vala_semantic_analyzer_get_current_method (_tmp603_);
				_tmp605_ = _tmp604_;
				_tmp606_ = vala_method_get_coroutine (_tmp605_);
				_tmp607_ = _tmp606_;
				_tmp597_ = !_tmp607_;
			}
			if (_tmp597_) {
				ValaSourceReference* _tmp608_;
				ValaSourceReference* _tmp609_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp608_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp609_ = _tmp608_;
				vala_report_error (_tmp609_, "yield expression not available outside async method");
			}
		}
		_tmp613_ = m;
		if (_tmp613_ != NULL) {
			ValaMethod* _tmp614_;
			gboolean _tmp615_;
			gboolean _tmp616_;
			_tmp614_ = m;
			_tmp615_ = vala_method_get_coroutine (_tmp614_);
			_tmp616_ = _tmp615_;
			_tmp612_ = _tmp616_;
		} else {
			_tmp612_ = FALSE;
		}
		if (_tmp612_) {
			gboolean _tmp617_;
			_tmp617_ = self->priv->_is_yield_expression;
			_tmp611_ = !_tmp617_;
		} else {
			_tmp611_ = FALSE;
		}
		if (_tmp611_) {
			ValaExpression* _tmp618_;
			ValaExpression* _tmp619_;
			const gchar* _tmp620_;
			const gchar* _tmp621_;
			_tmp618_ = vala_method_call_get_call (self);
			_tmp619_ = _tmp618_;
			_tmp620_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp619_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp621_ = _tmp620_;
			_tmp610_ = g_strcmp0 (_tmp621_, "end") != 0;
		} else {
			_tmp610_ = FALSE;
		}
		if (_tmp610_) {
		} else {
			{
				ValaList* _error_type_list = NULL;
				ValaMethod* _tmp622_;
				ValaList* _tmp623_;
				gint _error_type_size = 0;
				ValaList* _tmp624_;
				gint _tmp625_;
				gint _tmp626_;
				gint _error_type_index = 0;
				_tmp622_ = m;
				_tmp623_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp622_);
				_error_type_list = _tmp623_;
				_tmp624_ = _error_type_list;
				_tmp625_ = vala_collection_get_size ((ValaCollection*) _tmp624_);
				_tmp626_ = _tmp625_;
				_error_type_size = _tmp626_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp627_;
					gint _tmp628_;
					gint _tmp629_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp630_;
					gint _tmp631_;
					gpointer _tmp632_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp633_;
					ValaDataType* _tmp634_;
					ValaDataType* _tmp635_;
					ValaSourceReference* _tmp636_;
					ValaSourceReference* _tmp637_;
					ValaDataType* _tmp638_;
					_tmp627_ = _error_type_index;
					_error_type_index = _tmp627_ + 1;
					_tmp628_ = _error_type_index;
					_tmp629_ = _error_type_size;
					if (!(_tmp628_ < _tmp629_)) {
						break;
					}
					_tmp630_ = _error_type_list;
					_tmp631_ = _error_type_index;
					_tmp632_ = vala_list_get (_tmp630_, _tmp631_);
					error_type = (ValaDataType*) _tmp632_;
					may_throw = TRUE;
					_tmp633_ = error_type;
					_tmp634_ = vala_data_type_copy (_tmp633_);
					call_error_type = _tmp634_;
					_tmp635_ = call_error_type;
					_tmp636_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp637_ = _tmp636_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp635_, _tmp637_);
					_tmp638_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp638_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
		}
		_tmp639_ = m;
		_tmp640_ = vala_method_get_returns_floating_reference (_tmp639_);
		_tmp641_ = _tmp640_;
		if (_tmp641_) {
			ValaDataType* _tmp642_;
			ValaDataType* _tmp643_;
			_tmp642_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp643_ = _tmp642_;
			vala_data_type_set_floating_reference (_tmp643_, TRUE);
		}
		_tmp644_ = m;
		_tmp645_ = vala_method_get_returns_modified_pointer (_tmp644_);
		_tmp646_ = _tmp645_;
		if (_tmp646_) {
			ValaExpression* _tmp647_;
			ValaExpression* _tmp648_;
			ValaExpression* _tmp649_;
			ValaExpression* _tmp650_;
			_tmp647_ = vala_method_call_get_call (self);
			_tmp648_ = _tmp647_;
			_tmp649_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp648_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp650_ = _tmp649_;
			vala_expression_set_lvalue (_tmp650_, TRUE);
		}
		_tmp654_ = may_throw;
		if (_tmp654_) {
			ValaDataType* _tmp655_;
			ValaDataType* _tmp656_;
			gboolean _tmp657_;
			gboolean _tmp658_;
			_tmp655_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp656_ = _tmp655_;
			_tmp657_ = vala_data_type_get_nullable (_tmp656_);
			_tmp658_ = _tmp657_;
			_tmp653_ = !_tmp658_;
		} else {
			_tmp653_ = FALSE;
		}
		if (_tmp653_) {
			ValaDataType* _tmp659_;
			ValaDataType* _tmp660_;
			gboolean _tmp661_;
			gboolean _tmp662_;
			_tmp659_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp660_ = _tmp659_;
			_tmp661_ = vala_data_type_get_floating_reference (_tmp660_);
			_tmp662_ = _tmp661_;
			_tmp652_ = _tmp662_;
		} else {
			_tmp652_ = FALSE;
		}
		if (_tmp652_) {
			ValaDataType* _tmp663_;
			_tmp663_ = ret_type;
			_tmp651_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp663_, VALA_TYPE_OBJECT_TYPE);
		} else {
			_tmp651_ = FALSE;
		}
		if (_tmp651_) {
			ValaDataType* _tmp664_;
			ValaDataType* _tmp665_;
			_tmp664_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp665_ = _tmp664_;
			vala_data_type_set_nullable (_tmp665_, TRUE);
		}
		_tmp666_ = m;
		_tmp667_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp666_);
		_tmp668_ = _tmp667_;
		_tmp669_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp668_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp668_) : NULL);
		dynamic_sig = _tmp669_;
		_tmp671_ = dynamic_sig;
		if (_tmp671_ != NULL) {
			ValaDynamicSignal* _tmp672_;
			ValaExpression* _tmp673_;
			ValaExpression* _tmp674_;
			_tmp672_ = dynamic_sig;
			_tmp673_ = vala_dynamic_signal_get_handler (_tmp672_);
			_tmp674_ = _tmp673_;
			_tmp670_ = _tmp674_ != NULL;
		} else {
			_tmp670_ = FALSE;
		}
		if (_tmp670_) {
			ValaDynamicSignal* _tmp675_;
			ValaDynamicSignal* _tmp676_;
			ValaExpression* _tmp677_;
			ValaExpression* _tmp678_;
			ValaDataType* _tmp679_;
			ValaDataType* _tmp680_;
			ValaDataType* _tmp681_;
			ValaDataType* _tmp682_;
			ValaDataType* _tmp683_;
			ValaDataType* _tmp684_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp705_;
			ValaExpression* _tmp706_;
			ValaExpression* _tmp707_;
			ValaDynamicSignal* _tmp708_;
			ValaDynamicSignal* _tmp709_;
			ValaSymbol* _tmp710_;
			ValaSymbol* _tmp711_;
			ValaObjectType* _tmp712_;
			ValaObjectType* _tmp713_;
			ValaDelegate* _tmp714_;
			ValaDelegate* _tmp715_;
			ValaDelegateType* _tmp716_;
			ValaDelegateType* _tmp717_;
			_tmp675_ = dynamic_sig;
			_tmp676_ = dynamic_sig;
			_tmp677_ = vala_dynamic_signal_get_handler (_tmp676_);
			_tmp678_ = _tmp677_;
			_tmp679_ = vala_expression_get_value_type (_tmp678_);
			_tmp680_ = _tmp679_;
			_tmp681_ = vala_data_type_get_return_type (_tmp680_);
			_tmp682_ = _tmp681_;
			_tmp683_ = vala_data_type_copy (_tmp682_);
			_tmp684_ = _tmp683_;
			vala_callable_set_return_type ((ValaCallable*) _tmp675_, _tmp684_);
			_vala_code_node_unref0 (_tmp684_);
			_vala_code_node_unref0 (_tmp682_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp685_;
				ValaExpression* _tmp686_;
				ValaExpression* _tmp687_;
				ValaDataType* _tmp688_;
				ValaDataType* _tmp689_;
				ValaList* _tmp690_;
				gint _param_size = 0;
				ValaList* _tmp691_;
				gint _tmp692_;
				gint _tmp693_;
				gint _param_index = 0;
				_tmp685_ = dynamic_sig;
				_tmp686_ = vala_dynamic_signal_get_handler (_tmp685_);
				_tmp687_ = _tmp686_;
				_tmp688_ = vala_expression_get_value_type (_tmp687_);
				_tmp689_ = _tmp688_;
				_tmp690_ = vala_data_type_get_parameters (_tmp689_);
				_param_list = _tmp690_;
				_tmp691_ = _param_list;
				_tmp692_ = vala_collection_get_size ((ValaCollection*) _tmp691_);
				_tmp693_ = _tmp692_;
				_param_size = _tmp693_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp694_;
					gint _tmp695_;
					gint _tmp696_;
					ValaParameter* param = NULL;
					ValaList* _tmp697_;
					gint _tmp698_;
					gpointer _tmp699_;
					gboolean _tmp700_;
					_tmp694_ = _param_index;
					_param_index = _tmp694_ + 1;
					_tmp695_ = _param_index;
					_tmp696_ = _param_size;
					if (!(_tmp695_ < _tmp696_)) {
						break;
					}
					_tmp697_ = _param_list;
					_tmp698_ = _param_index;
					_tmp699_ = vala_list_get (_tmp697_, _tmp698_);
					param = (ValaParameter*) _tmp699_;
					_tmp700_ = first;
					if (_tmp700_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp701_;
						ValaParameter* _tmp702_;
						ValaParameter* _tmp703_;
						ValaParameter* _tmp704_;
						_tmp701_ = dynamic_sig;
						_tmp702_ = param;
						_tmp703_ = vala_parameter_copy (_tmp702_);
						_tmp704_ = _tmp703_;
						vala_callable_add_parameter ((ValaCallable*) _tmp701_, _tmp704_);
						_vala_code_node_unref0 (_tmp704_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp705_ = dynamic_sig;
			_tmp706_ = vala_dynamic_signal_get_handler (_tmp705_);
			_tmp707_ = _tmp706_;
			_tmp708_ = dynamic_sig;
			_tmp709_ = dynamic_sig;
			_tmp710_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp711_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_signal_get_delegate ((ValaSignal*) _tmp708_, (ValaDataType*) _tmp713_, (ValaCodeNode*) self);
			_tmp715_ = _tmp714_;
			_tmp716_ = vala_delegate_type_new (_tmp715_);
			_tmp717_ = _tmp716_;
			vala_expression_set_target_type (_tmp707_, (ValaDataType*) _tmp717_);
			_vala_code_node_unref0 (_tmp717_);
			_vala_code_node_unref0 (_tmp715_);
			_vala_code_node_unref0 (_tmp713_);
		}
		_tmp719_ = m;
		if (_tmp719_ != NULL) {
			ValaMethod* _tmp720_;
			ValaList* _tmp721_;
			ValaList* _tmp722_;
			gint _tmp723_;
			gint _tmp724_;
			_tmp720_ = m;
			_tmp721_ = vala_method_get_type_parameters (_tmp720_);
			_tmp722_ = _tmp721_;
			_tmp723_ = vala_collection_get_size ((ValaCollection*) _tmp722_);
			_tmp724_ = _tmp723_;
			_tmp718_ = _tmp724_ > 0;
			_vala_iterable_unref0 (_tmp722_);
		} else {
			_tmp718_ = FALSE;
		}
		if (_tmp718_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp725_;
			ValaExpression* _tmp726_;
			ValaMemberAccess* _tmp727_;
			ValaMemberAccess* _tmp728_;
			ValaList* _tmp729_;
			ValaList* _tmp730_;
			gint _tmp731_;
			gint _tmp732_;
			gboolean _tmp733_;
			_tmp725_ = vala_method_call_get_call (self);
			_tmp726_ = _tmp725_;
			_tmp727_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp726_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp727_;
			_tmp728_ = ma;
			_tmp729_ = vala_member_access_get_type_arguments (_tmp728_);
			_tmp730_ = _tmp729_;
			_tmp731_ = vala_collection_get_size ((ValaCollection*) _tmp730_);
			_tmp732_ = _tmp731_;
			_tmp733_ = _tmp732_ == 0;
			_vala_iterable_unref0 (_tmp730_);
			if (_tmp733_) {
				ValaList* _tmp807_;
				ValaIterator* _tmp808_;
				ValaDataType* _tmp838_;
				ValaDataType* _tmp839_;
				ValaDataType* _tmp840_;
				ValaList* _tmp841_;
				ValaDataType* _tmp842_;
				ValaDataType* _tmp843_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp734_;
					ValaList* _tmp735_;
					gint _type_param_size = 0;
					ValaList* _tmp736_;
					gint _tmp737_;
					gint _tmp738_;
					gint _type_param_index = 0;
					_tmp734_ = m;
					_tmp735_ = vala_method_get_type_parameters (_tmp734_);
					_type_param_list = _tmp735_;
					_tmp736_ = _type_param_list;
					_tmp737_ = vala_collection_get_size ((ValaCollection*) _tmp736_);
					_tmp738_ = _tmp737_;
					_type_param_size = _tmp738_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp739_;
						gint _tmp740_;
						gint _tmp741_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp742_;
						gint _tmp743_;
						gpointer _tmp744_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp745_;
						ValaIterator* _tmp746_;
						gboolean _tmp785_ = FALSE;
						ValaDataType* _tmp786_;
						ValaDataType* _tmp796_;
						ValaMemberAccess* _tmp805_;
						ValaDataType* _tmp806_;
						_tmp739_ = _type_param_index;
						_type_param_index = _tmp739_ + 1;
						_tmp740_ = _type_param_index;
						_tmp741_ = _type_param_size;
						if (!(_tmp740_ < _tmp741_)) {
							break;
						}
						_tmp742_ = _type_param_list;
						_tmp743_ = _type_param_index;
						_tmp744_ = vala_list_get (_tmp742_, _tmp743_);
						type_param = (ValaTypeParameter*) _tmp744_;
						type_arg = NULL;
						_tmp745_ = args;
						_tmp746_ = vala_iterable_iterator ((ValaIterable*) _tmp745_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp746_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp747_;
							ValaList* _tmp748_;
							gint _param_size = 0;
							ValaList* _tmp749_;
							gint _tmp750_;
							gint _tmp751_;
							gint _param_index = 0;
							_tmp747_ = params;
							_tmp748_ = _vala_iterable_ref0 (_tmp747_);
							_param_list = _tmp748_;
							_tmp749_ = _param_list;
							_tmp750_ = vala_collection_get_size ((ValaCollection*) _tmp749_);
							_tmp751_ = _tmp750_;
							_param_size = _tmp751_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp752_;
								gint _tmp753_;
								gint _tmp754_;
								ValaParameter* param = NULL;
								ValaList* _tmp755_;
								gint _tmp756_;
								gpointer _tmp757_;
								gboolean _tmp758_ = FALSE;
								ValaParameter* _tmp759_;
								gboolean _tmp760_;
								gboolean _tmp761_;
								ValaIterator* _tmp765_;
								_tmp752_ = _param_index;
								_param_index = _tmp752_ + 1;
								_tmp753_ = _param_index;
								_tmp754_ = _param_size;
								if (!(_tmp753_ < _tmp754_)) {
									break;
								}
								_tmp755_ = _param_list;
								_tmp756_ = _param_index;
								_tmp757_ = vala_list_get (_tmp755_, _tmp756_);
								param = (ValaParameter*) _tmp757_;
								_tmp759_ = param;
								_tmp760_ = vala_parameter_get_ellipsis (_tmp759_);
								_tmp761_ = _tmp760_;
								if (_tmp761_) {
									_tmp758_ = TRUE;
								} else {
									ValaParameter* _tmp762_;
									gboolean _tmp763_;
									gboolean _tmp764_;
									_tmp762_ = param;
									_tmp763_ = vala_parameter_get_params_array (_tmp762_);
									_tmp764_ = _tmp763_;
									_tmp758_ = _tmp764_;
								}
								if (_tmp758_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp765_ = arg_it;
								if (vala_iterator_next (_tmp765_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp766_;
									gpointer _tmp767_;
									ValaParameter* _tmp768_;
									ValaDataType* _tmp769_;
									ValaDataType* _tmp770_;
									ValaTypeParameter* _tmp771_;
									ValaExpression* _tmp772_;
									ValaDataType* _tmp773_;
									ValaDataType* _tmp774_;
									ValaDataType* _tmp775_;
									ValaDataType* _tmp776_;
									ValaExpression* _tmp777_;
									ValaExpression* _tmp778_;
									ValaDataType* _tmp779_;
									ValaDataType* _tmp780_;
									ValaDataType* _tmp781_;
									ValaList* _tmp782_;
									ValaDataType* _tmp783_;
									ValaDataType* _tmp784_;
									_tmp766_ = arg_it;
									_tmp767_ = vala_iterator_get (_tmp766_);
									arg = (ValaExpression*) _tmp767_;
									_tmp768_ = param;
									_tmp769_ = vala_variable_get_variable_type ((ValaVariable*) _tmp768_);
									_tmp770_ = _tmp769_;
									_tmp771_ = type_param;
									_tmp772_ = arg;
									_tmp773_ = vala_expression_get_value_type (_tmp772_);
									_tmp774_ = _tmp773_;
									_tmp775_ = vala_data_type_infer_type_argument (_tmp770_, _tmp771_, _tmp774_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp775_;
									_tmp776_ = type_arg;
									if (_tmp776_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp777_ = arg;
									_tmp778_ = arg;
									_tmp779_ = vala_expression_get_formal_target_type (_tmp778_);
									_tmp780_ = _tmp779_;
									_tmp781_ = target_object_type;
									_tmp782_ = method_type_args;
									_tmp783_ = vala_data_type_get_actual_type (_tmp780_, _tmp781_, _tmp782_, (ValaCodeNode*) self);
									_tmp784_ = _tmp783_;
									vala_expression_set_target_type (_tmp777_, _tmp784_);
									_vala_code_node_unref0 (_tmp784_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp786_ = type_arg;
						if (_tmp786_ == NULL) {
							ValaDataType* _tmp787_;
							ValaDataType* _tmp788_;
							_tmp787_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp788_ = _tmp787_;
							_tmp785_ = _tmp788_ != NULL;
						} else {
							_tmp785_ = FALSE;
						}
						if (_tmp785_) {
							ValaMethod* _tmp789_;
							ValaDataType* _tmp790_;
							ValaDataType* _tmp791_;
							ValaTypeParameter* _tmp792_;
							ValaDataType* _tmp793_;
							ValaDataType* _tmp794_;
							ValaDataType* _tmp795_;
							_tmp789_ = m;
							_tmp790_ = vala_callable_get_return_type ((ValaCallable*) _tmp789_);
							_tmp791_ = _tmp790_;
							_tmp792_ = type_param;
							_tmp793_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp794_ = _tmp793_;
							_tmp795_ = vala_data_type_infer_type_argument (_tmp791_, _tmp792_, _tmp794_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp795_;
						}
						_tmp796_ = type_arg;
						if (_tmp796_ == NULL) {
							ValaMemberAccess* _tmp797_;
							ValaSourceReference* _tmp798_;
							ValaSourceReference* _tmp799_;
							ValaTypeParameter* _tmp800_;
							gchar* _tmp801_;
							gchar* _tmp802_;
							gchar* _tmp803_;
							gchar* _tmp804_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp797_ = ma;
							_tmp798_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp797_);
							_tmp799_ = _tmp798_;
							_tmp800_ = type_param;
							_tmp801_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp800_);
							_tmp802_ = _tmp801_;
							_tmp803_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp802_);
							_tmp804_ = _tmp803_;
							vala_report_error (_tmp799_, _tmp804_);
							_g_free0 (_tmp804_);
							_g_free0 (_tmp802_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp805_ = ma;
						_tmp806_ = type_arg;
						vala_member_access_add_type_argument (_tmp805_, _tmp806_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp807_ = args;
				_tmp808_ = vala_iterable_iterator ((ValaIterable*) _tmp807_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp808_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp809_;
					ValaList* _tmp810_;
					gint _param_size = 0;
					ValaList* _tmp811_;
					gint _tmp812_;
					gint _tmp813_;
					gint _param_index = 0;
					_tmp809_ = params;
					_tmp810_ = _vala_iterable_ref0 (_tmp809_);
					_param_list = _tmp810_;
					_tmp811_ = _param_list;
					_tmp812_ = vala_collection_get_size ((ValaCollection*) _tmp811_);
					_tmp813_ = _tmp812_;
					_param_size = _tmp813_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp814_;
						gint _tmp815_;
						gint _tmp816_;
						ValaParameter* param = NULL;
						ValaList* _tmp817_;
						gint _tmp818_;
						gpointer _tmp819_;
						gboolean _tmp820_ = FALSE;
						ValaParameter* _tmp821_;
						gboolean _tmp822_;
						gboolean _tmp823_;
						ValaIterator* _tmp827_;
						_tmp814_ = _param_index;
						_param_index = _tmp814_ + 1;
						_tmp815_ = _param_index;
						_tmp816_ = _param_size;
						if (!(_tmp815_ < _tmp816_)) {
							break;
						}
						_tmp817_ = _param_list;
						_tmp818_ = _param_index;
						_tmp819_ = vala_list_get (_tmp817_, _tmp818_);
						param = (ValaParameter*) _tmp819_;
						_tmp821_ = param;
						_tmp822_ = vala_parameter_get_ellipsis (_tmp821_);
						_tmp823_ = _tmp822_;
						if (_tmp823_) {
							_tmp820_ = TRUE;
						} else {
							ValaParameter* _tmp824_;
							gboolean _tmp825_;
							gboolean _tmp826_;
							_tmp824_ = param;
							_tmp825_ = vala_parameter_get_params_array (_tmp824_);
							_tmp826_ = _tmp825_;
							_tmp820_ = _tmp826_;
						}
						if (_tmp820_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp827_ = arg_it;
						if (vala_iterator_next (_tmp827_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp828_;
							gpointer _tmp829_;
							ValaExpression* _tmp830_;
							ValaExpression* _tmp831_;
							ValaDataType* _tmp832_;
							ValaDataType* _tmp833_;
							ValaDataType* _tmp834_;
							ValaList* _tmp835_;
							ValaDataType* _tmp836_;
							ValaDataType* _tmp837_;
							_tmp828_ = arg_it;
							_tmp829_ = vala_iterator_get (_tmp828_);
							arg = (ValaExpression*) _tmp829_;
							_tmp830_ = arg;
							_tmp831_ = arg;
							_tmp832_ = vala_expression_get_formal_target_type (_tmp831_);
							_tmp833_ = _tmp832_;
							_tmp834_ = target_object_type;
							_tmp835_ = method_type_args;
							_tmp836_ = vala_data_type_get_actual_type (_tmp833_, _tmp834_, _tmp835_, (ValaCodeNode*) self);
							_tmp837_ = _tmp836_;
							vala_expression_set_target_type (_tmp830_, _tmp837_);
							_vala_code_node_unref0 (_tmp837_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp838_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp839_ = _tmp838_;
				_tmp840_ = target_object_type;
				_tmp841_ = method_type_args;
				_tmp842_ = vala_data_type_get_actual_type (_tmp839_, _tmp840_, _tmp841_, (ValaCodeNode*) self);
				_tmp843_ = _tmp842_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp843_);
				_vala_code_node_unref0 (_tmp843_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp845_ = m;
		if (_tmp845_ != NULL) {
			ValaMethod* _tmp846_;
			gboolean _tmp847_;
			gboolean _tmp848_;
			_tmp846_ = m;
			_tmp847_ = vala_method_get_coroutine (_tmp846_);
			_tmp848_ = _tmp847_;
			_tmp844_ = _tmp848_;
		} else {
			_tmp844_ = FALSE;
		}
		if (_tmp844_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp849_;
			ValaExpression* _tmp850_;
			ValaMemberAccess* _tmp851_;
			ValaMemberAccess* _tmp852_;
			const gchar* _tmp853_;
			const gchar* _tmp854_;
			_tmp849_ = vala_method_call_get_call (self);
			_tmp850_ = _tmp849_;
			_tmp851_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp850_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp851_;
			_tmp852_ = ma;
			_tmp853_ = vala_member_access_get_member_name (_tmp852_);
			_tmp854_ = _tmp853_;
			if (g_strcmp0 (_tmp854_, "end") == 0) {
				ValaMethod* _tmp855_;
				ValaMethod* _tmp856_;
				ValaMethod* _tmp857_;
				ValaMethodType* _tmp858_;
				_tmp855_ = m;
				_tmp856_ = vala_method_get_end_method (_tmp855_);
				_tmp857_ = _tmp856_;
				_tmp858_ = vala_method_type_new (_tmp857_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp858_;
				_vala_code_node_unref0 (_tmp857_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp859_;
		_tmp859_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp859_, VALA_TYPE_OBJECT_TYPE)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp860_;
			ValaObjectTypeSymbol* _tmp861_;
			ValaObjectTypeSymbol* _tmp862_;
			ValaClass* _tmp863_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp864_;
			ValaCreationMethod* _tmp865_;
			ValaCreationMethod* _tmp866_;
			ValaCreationMethod* _tmp867_;
			_tmp860_ = mtype;
			_tmp861_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp860_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp862_ = _tmp861_;
			_tmp863_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp862_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp863_;
			_tmp864_ = cl;
			_tmp865_ = vala_class_get_default_construction_method (_tmp864_);
			_tmp866_ = _tmp865_;
			_tmp867_ = _vala_code_node_ref0 (_tmp866_);
			m = _tmp867_;
			{
				ValaList* _error_type_list = NULL;
				ValaCreationMethod* _tmp868_;
				ValaList* _tmp869_;
				gint _error_type_size = 0;
				ValaList* _tmp870_;
				gint _tmp871_;
				gint _tmp872_;
				gint _error_type_index = 0;
				_tmp868_ = m;
				_tmp869_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp868_);
				_error_type_list = _tmp869_;
				_tmp870_ = _error_type_list;
				_tmp871_ = vala_collection_get_size ((ValaCollection*) _tmp870_);
				_tmp872_ = _tmp871_;
				_error_type_size = _tmp872_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp873_;
					gint _tmp874_;
					gint _tmp875_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp876_;
					gint _tmp877_;
					gpointer _tmp878_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp879_;
					ValaDataType* _tmp880_;
					ValaDataType* _tmp881_;
					ValaSourceReference* _tmp882_;
					ValaSourceReference* _tmp883_;
					ValaDataType* _tmp884_;
					_tmp873_ = _error_type_index;
					_error_type_index = _tmp873_ + 1;
					_tmp874_ = _error_type_index;
					_tmp875_ = _error_type_size;
					if (!(_tmp874_ < _tmp875_)) {
						break;
					}
					_tmp876_ = _error_type_list;
					_tmp877_ = _error_type_index;
					_tmp878_ = vala_list_get (_tmp876_, _tmp877_);
					error_type = (ValaDataType*) _tmp878_;
					may_throw = TRUE;
					_tmp879_ = error_type;
					_tmp880_ = vala_data_type_copy (_tmp879_);
					call_error_type = _tmp880_;
					_tmp881_ = call_error_type;
					_tmp882_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp883_ = _tmp882_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp881_, _tmp883_);
					_tmp884_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp884_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp885_;
			_tmp885_ = mtype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp885_, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp886_;
				ValaDelegate* _tmp887_;
				ValaDelegate* _tmp888_;
				ValaDelegate* _tmp889_;
				_tmp886_ = mtype;
				_tmp887_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp886_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp888_ = _tmp887_;
				_tmp889_ = _vala_code_node_ref0 (_tmp888_);
				d = _tmp889_;
				{
					ValaList* _error_type_list = NULL;
					ValaDelegate* _tmp890_;
					ValaList* _tmp891_;
					gint _error_type_size = 0;
					ValaList* _tmp892_;
					gint _tmp893_;
					gint _tmp894_;
					gint _error_type_index = 0;
					_tmp890_ = d;
					_tmp891_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp890_);
					_error_type_list = _tmp891_;
					_tmp892_ = _error_type_list;
					_tmp893_ = vala_collection_get_size ((ValaCollection*) _tmp892_);
					_tmp894_ = _tmp893_;
					_error_type_size = _tmp894_;
					_error_type_index = -1;
					while (TRUE) {
						gint _tmp895_;
						gint _tmp896_;
						gint _tmp897_;
						ValaDataType* error_type = NULL;
						ValaList* _tmp898_;
						gint _tmp899_;
						gpointer _tmp900_;
						ValaDataType* call_error_type = NULL;
						ValaDataType* _tmp901_;
						ValaDataType* _tmp902_;
						ValaDataType* _tmp903_;
						ValaSourceReference* _tmp904_;
						ValaSourceReference* _tmp905_;
						ValaDataType* _tmp906_;
						_tmp895_ = _error_type_index;
						_error_type_index = _tmp895_ + 1;
						_tmp896_ = _error_type_index;
						_tmp897_ = _error_type_size;
						if (!(_tmp896_ < _tmp897_)) {
							break;
						}
						_tmp898_ = _error_type_list;
						_tmp899_ = _error_type_index;
						_tmp900_ = vala_list_get (_tmp898_, _tmp899_);
						error_type = (ValaDataType*) _tmp900_;
						may_throw = TRUE;
						_tmp901_ = error_type;
						_tmp902_ = vala_data_type_copy (_tmp901_);
						call_error_type = _tmp902_;
						_tmp903_ = call_error_type;
						_tmp904_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp905_ = _tmp904_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp903_, _tmp905_);
						_tmp906_ = call_error_type;
						vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp906_);
						_vala_code_node_unref0 (call_error_type);
						_vala_code_node_unref0 (error_type);
					}
					_vala_iterable_unref0 (_error_type_list);
				}
				_vala_code_node_unref0 (d);
			}
		}
	}
	_tmp907_ = vala_code_context_get_analyzer (context);
	_tmp908_ = _tmp907_;
	_tmp909_ = mtype;
	_tmp910_ = params;
	_tmp911_ = vala_method_call_get_argument_list (self);
	_tmp912_ = _tmp911_;
	_tmp913_ = !vala_semantic_analyzer_check_arguments (_tmp908_, (ValaExpression*) self, _tmp909_, _tmp910_, _tmp912_);
	_vala_iterable_unref0 (_tmp912_);
	if (_tmp913_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	_tmp916_ = base_cm;
	if (_tmp916_ != NULL) {
		ValaCreationMethod* _tmp917_;
		_tmp917_ = base_cm;
		_tmp915_ = vala_method_is_variadic ((ValaMethod*) _tmp917_);
	} else {
		_tmp915_ = FALSE;
	}
	if (_tmp915_) {
		ValaList* _tmp918_;
		gint _tmp919_;
		gint _tmp920_;
		ValaCreationMethod* _tmp921_;
		ValaList* _tmp922_;
		ValaList* _tmp923_;
		gint _tmp924_;
		gint _tmp925_;
		_tmp918_ = args;
		_tmp919_ = vala_collection_get_size ((ValaCollection*) _tmp918_);
		_tmp920_ = _tmp919_;
		_tmp921_ = base_cm;
		_tmp922_ = vala_callable_get_parameters ((ValaCallable*) _tmp921_);
		_tmp923_ = _tmp922_;
		_tmp924_ = vala_collection_get_size ((ValaCollection*) _tmp923_);
		_tmp925_ = _tmp924_;
		_tmp914_ = _tmp920_ == _tmp925_;
		_vala_iterable_unref0 (_tmp923_);
	} else {
		_tmp914_ = FALSE;
	}
	if (_tmp914_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp926_;
		ValaList* _tmp927_;
		gint _tmp928_;
		gint _tmp929_;
		gpointer _tmp930_;
		gboolean _tmp931_ = FALSE;
		ValaExpression* _tmp932_;
		ValaDataType* _tmp933_;
		ValaDataType* _tmp934_;
		_tmp926_ = args;
		_tmp927_ = args;
		_tmp928_ = vala_collection_get_size ((ValaCollection*) _tmp927_);
		_tmp929_ = _tmp928_;
		_tmp930_ = vala_list_get (_tmp926_, _tmp929_ - 1);
		this_last_arg = (ValaExpression*) _tmp930_;
		_tmp932_ = this_last_arg;
		_tmp933_ = vala_expression_get_value_type (_tmp932_);
		_tmp934_ = _tmp933_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp934_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
			ValaExpression* _tmp935_;
			ValaDataType* _tmp936_;
			ValaDataType* _tmp937_;
			ValaTypeSymbol* _tmp938_;
			ValaTypeSymbol* _tmp939_;
			ValaSemanticAnalyzer* _tmp940_;
			ValaSemanticAnalyzer* _tmp941_;
			ValaDataType* _tmp942_;
			ValaTypeSymbol* _tmp943_;
			ValaTypeSymbol* _tmp944_;
			_tmp935_ = this_last_arg;
			_tmp936_ = vala_expression_get_value_type (_tmp935_);
			_tmp937_ = _tmp936_;
			_tmp938_ = vala_data_type_get_data_type (_tmp937_);
			_tmp939_ = _tmp938_;
			_tmp940_ = vala_code_context_get_analyzer (context);
			_tmp941_ = _tmp940_;
			_tmp942_ = _tmp941_->va_list_type;
			_tmp943_ = vala_data_type_get_data_type (_tmp942_);
			_tmp944_ = _tmp943_;
			_tmp931_ = _tmp939_ == _tmp944_;
		} else {
			_tmp931_ = FALSE;
		}
		if (_tmp931_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp945_ = may_throw;
	if (_tmp945_) {
		gboolean _tmp946_ = FALSE;
		ValaCodeNode* _tmp947_;
		ValaCodeNode* _tmp948_;
		_tmp947_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp948_ = _tmp947_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp948_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp946_ = TRUE;
		} else {
			ValaCodeNode* _tmp949_;
			ValaCodeNode* _tmp950_;
			_tmp949_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp950_ = _tmp949_;
			_tmp946_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp950_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp946_) {
		} else {
			ValaSemanticAnalyzer* _tmp951_;
			ValaSemanticAnalyzer* _tmp952_;
			ValaSymbol* _tmp953_;
			ValaSymbol* _tmp954_;
			_tmp951_ = vala_code_context_get_analyzer (context);
			_tmp952_ = _tmp951_;
			_tmp953_ = vala_semantic_analyzer_get_current_symbol (_tmp952_);
			_tmp954_ = _tmp953_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp954_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp955_;
				ValaSourceReference* _tmp956_;
				_tmp955_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp956_ = _tmp955_;
				vala_report_error (_tmp956_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp957_;
				ValaCodeNode* _tmp958_;
				ValaCodeNode* _tmp959_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp960_;
				ValaDataType* _tmp961_;
				ValaDataType* _tmp962_;
				ValaDataType* _tmp963_;
				gchar* _tmp964_;
				gchar* _tmp965_;
				ValaSourceReference* _tmp966_;
				ValaSourceReference* _tmp967_;
				ValaLocalVariable* _tmp968_;
				ValaLocalVariable* _tmp969_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp970_;
				ValaSourceReference* _tmp971_;
				ValaSourceReference* _tmp972_;
				ValaDeclarationStatement* _tmp973_;
				ValaSemanticAnalyzer* _tmp974_;
				ValaSemanticAnalyzer* _tmp975_;
				ValaBlock* _tmp976_;
				ValaDeclarationStatement* _tmp977_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp978_;
				ValaDataType* _tmp979_;
				ValaDataType* _tmp980_;
				ValaExpression* _tmp981_;
				ValaLocalVariable* _tmp982_;
				ValaDeclarationStatement* _tmp983_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp984_;
				ValaSemanticAnalyzer* _tmp985_;
				ValaSymbol* _tmp986_;
				ValaSymbol* _tmp987_;
				ValaBlock* _tmp988_;
				ValaBlock* _tmp989_;
				ValaLocalVariable* _tmp990_;
				ValaSemanticAnalyzer* _tmp991_;
				ValaSemanticAnalyzer* _tmp992_;
				ValaBlock* _tmp993_;
				ValaLocalVariable* _tmp994_;
				ValaCodeNode* _tmp995_;
				ValaExpression* _tmp996_;
				ValaExpression* _tmp997_;
				_tmp957_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp958_ = _tmp957_;
				_tmp959_ = _vala_code_node_ref0 (_tmp958_);
				old_parent_node = _tmp959_;
				_tmp960_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp961_ = _tmp960_;
				_tmp962_ = vala_data_type_copy (_tmp961_);
				_tmp963_ = _tmp962_;
				_tmp964_ = vala_code_node_get_temp_name ();
				_tmp965_ = _tmp964_;
				_tmp966_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp967_ = _tmp966_;
				_tmp968_ = vala_local_variable_new (_tmp963_, _tmp965_, NULL, _tmp967_);
				_tmp969_ = _tmp968_;
				_g_free0 (_tmp965_);
				_vala_code_node_unref0 (_tmp963_);
				local = _tmp969_;
				_tmp970_ = local;
				_tmp971_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp972_ = _tmp971_;
				_tmp973_ = vala_declaration_statement_new ((ValaSymbol*) _tmp970_, _tmp972_);
				decl = _tmp973_;
				_tmp974_ = vala_code_context_get_analyzer (context);
				_tmp975_ = _tmp974_;
				_tmp976_ = _tmp975_->insert_block;
				_tmp977_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp976_, (ValaStatement*) _tmp977_);
				_tmp978_ = local;
				_tmp979_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp980_ = _tmp979_;
				_tmp981_ = vala_semantic_analyzer_create_temp_access (_tmp978_, _tmp980_);
				temp_access = _tmp981_;
				_tmp982_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp982_, (ValaExpression*) self);
				_tmp983_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp983_, context);
				_tmp984_ = vala_code_context_get_analyzer (context);
				_tmp985_ = _tmp984_;
				_tmp986_ = vala_semantic_analyzer_get_current_symbol (_tmp985_);
				_tmp987_ = _tmp986_;
				_tmp988_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp987_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp988_;
				_tmp989_ = block;
				_tmp990_ = local;
				vala_block_remove_local_variable (_tmp989_, _tmp990_);
				_tmp991_ = vala_code_context_get_analyzer (context);
				_tmp992_ = _tmp991_;
				_tmp993_ = _tmp992_->insert_block;
				_tmp994_ = local;
				vala_block_add_local_variable (_tmp993_, _tmp994_);
				_tmp995_ = old_parent_node;
				_tmp996_ = temp_access;
				vala_code_node_replace_expression (_tmp995_, (ValaExpression*) self, _tmp996_);
				_tmp997_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp997_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp998_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp999_ = _tmp998_;
	result = !_tmp999_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}


static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		_tmp18_ = vala_method_call_get_call (self);
		_tmp19_ = _tmp18_;
		vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _expr_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _expr_index = 0;
		_tmp20_ = self->priv->argument_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_expr_list = _tmp21_;
		_tmp22_ = _expr_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_expr_size = _tmp24_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValaExpression* expr = NULL;
			ValaList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValaExpression* _tmp31_;
			_tmp25_ = _expr_index;
			_expr_index = _tmp25_ + 1;
			_tmp26_ = _expr_index;
			_tmp27_ = _expr_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _expr_list;
			_tmp29_ = _expr_index;
			_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
			expr = (ValaExpression*) _tmp30_;
			_tmp31_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp31_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}


static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _arg_index;
			_arg_index = _tmp7_ + 1;
			_tmp8_ = _arg_index;
			_tmp9_ = _arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = _arg_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _arg_index;
			_arg_index = _tmp7_ + 1;
			_tmp8_ = _arg_index;
			_tmp9_ = _arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = _arg_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		format_arg = vala_method_get_format_arg_index (_tmp8_);
		_tmp10_ = format_arg;
		if (_tmp10_ >= 0) {
			gint _tmp11_;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp11_ = format_arg;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp9_ = _tmp11_ < _tmp14_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaStringLiteral* _tmp19_;
			ValaStringLiteral* _tmp20_;
			_tmp15_ = self->priv->argument_list;
			_tmp16_ = format_arg;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_tmp19_ = vala_string_literal_get_format_literal (_tmp18_);
			_tmp20_ = _tmp19_;
			_vala_code_node_unref0 (_tmp18_);
			result = _tmp20_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}


static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	gchar* result = NULL;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			ValaExpression* expr = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			gboolean _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp15_ = _expr_index;
			_expr_index = _tmp15_ + 1;
			_tmp16_ = _expr_index;
			_tmp17_ = _expr_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _expr_list;
			_tmp19_ = _expr_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			expr = (ValaExpression*) _tmp20_;
			_tmp21_ = first;
			if (!_tmp21_) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp27_ = b;
	g_string_append (_tmp27_, "))");
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}


ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_assert;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}


gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_constructv_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}


gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}


static void
vala_method_call_class_init (ValaMethodCallClass * klass)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}


static void
vala_method_call_instance_init (ValaMethodCall * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}


static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}


/**
 * Represents an invocation expression in the source code.
 */
GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}



