// Variable numbers (varno@body) :
SET  $u  =  3 ;                  //   upper air u component     
SET  $v  =  4 ;                  //   upper air v component     
SET  $z  =  1 ;                  //   geopotential              
SET  $dz  =  57 ;                //   thickness                 
SET  $rh  =  29 ;                //   upper air rel. humidity   
SET  $pwc  =  9 ;                //   precipitable water content      
SET  $rh2m  =  58 ;              //   2m rel. humidity          
SET  $t  =  2 ;                  //   upper air temperature (K)
SET  $td  =  59 ;                //   upper air dew point (K) 
SET  $t2m  =  39 ;               //   2m temperature (K)           
SET  $td2m  =  40 ;              //   2m dew point (K)             
SET  $ts  =  11 ;                //   surface temperature (K)      
SET  $ptend  =  30 ;             //   pressure tendency         
SET  $w  =  60 ;                 //   past weather (w)          
SET  $ww  =  61 ;                //   present weather (ww)      
SET  $vv  =  62 ;                //   visibility                
SET  $ch  =  63 ;                //   type of high clouds (ch)  
SET  $cm  =  64 ;                //   type of middle clouds (cm)   
SET  $cl  =  65 ;                //   type of low clouds (cl)   
SET  $nh  =  66 ;                //   cloud base height (nh)    
SET  $nn  =  67 ;                //   low cloud amount (n)      
SET  $hshs  =  68 ;              //   additional cloud group height (hh)   
SET  $c  =  69 ;                 //   additional cloud group type (c)   
SET  $ns  =  70 ;                //   additional cloud group amount (ns)   
SET  $sdepth  =  71 ;            //   snow depth                
SET  $e  =  72 ;                 //   state of ground (e)       
SET  $tgtg  =  73 ;              //   ground temperature (tgtg)   
SET  $spsp1  =  74 ;             //   special phenomena (spsp)#1   
SET  $spsp2  =  75 ;             //   special phenomena (spsp)#2   
SET  $rs  =  76 ;                //   ice code type (rs)        
SET  $eses  =  77 ;              //   ice thickness (eses)      
SET  $is  =  78 ;                //   ice (is)                  
SET  $trtr  =  79 ;              //   original time period of rain obs. (trtr)   
SET  $rr  =  80 ;                //   6hr rain (liquid part)    
SET  $jj  =  81 ;                //   max. temperature (jj)     
SET  $vs  =  82 ;                //   ship speed (vs)           
SET  $ds  =  83 ;                //   ship direction (ds)       
SET  $hwhw  =  84 ;              //   wave height               
SET  $pwpw  =  85 ;              //   wave period               
SET  $dwdw  =  86 ;              //   wave direction            
SET  $gclg  =  87 ;              //   general cloud group       
SET  $rhlc  =  88 ;              //   rel. humidity from low clouds      
SET  $rhmc  =  89 ;              //   rel. humidity from middle clouds   
SET  $rhhc  =  90 ;              //   rel. humidity from high clouds     
SET  $n  =  91 ;                 //   total amount of clouds    
SET  $sfall  =  92 ;             //   6hr snowfall (solid part of rain)   
SET  $ps  =  110 ;               //   surface pressure          
SET  $dd  =  111 ;               //   wind direction            
SET  $ff  =  112 ;               //   wind force                
SET  $rawbt  =  119 ;            //   brightness temperature (K)
SET  $rawra  =  120 ;            //   raw radiance              
SET  $satcl  =  121 ;            //   cloud amount from satellite   
SET  $scatss  =  122 ;           //   sigma 0   
SET  $du  =  5 ;                 //   wind shear (du)   
SET  $dv  =  6 ;                 //   wind shear (dv)   
SET  $u10m  =  41 ;              //   10m u component (m/s)
SET  $v10m  =  42 ;              //   10m v component (m/s)  
SET  $rhlay  =  19 ;             //   layer rel. humidity   
SET  $cllqw  =  123 ;            //   cloud liquid water   
SET  $scatv  =  124 ;            //   ambiguous v component   
SET  $scatu  =  125 ;            //   ambiguous u component   
SET  $q  =  7 ;                  //   specific humidity (q)   
SET  $scatwd  =  126 ;           //   ambiguous wind direction   
SET  $scatws  =  127 ;           //   ambiguous wind speed       
SET  $vsp  =  8 ;                //   vertical speed   
SET  $vt  =  56 ;                //   virtual temperature   
SET  $o3lay  =  206 ;            //   layer ozone   
SET  $height  =  156 ;           //   height   
SET  $1dvar  =  215 ;            //   1d-var model level (pseudo)-variable   
SET  $w2  =  160 ;               //   past weather 2 (used in synoptic maps)   
SET  $cpt  =  130 ;              //   characteristic of pressure tendency (used in synoptic maps)   
SET  $tsts  =  12 ;              //   sea water temperature (used in synoptic maps)   
SET  $refl  =  192 ;             //   radar reflectivity  
SET  $apdss  =  128 ;            //   atmospheric path delay in satellite signal   
SET  $bend_angle  =  162 ;       //   radio occultation bending angle   
SET  $los  =  187 ;              //   horizontal line-of-sight wind component     
SET  $aerod  =  174 ;            //   aerosol optical depth at 0.55 microns  
SET  $limb_radiance =  163 ;     //   Limb Radiances  
SET  $chem1  =  181 ;            //   chem1: no2/nox   
SET  $chem2  =  182 ;            //   chem2: so2   
SET  $chem3  =  183 ;            //   chem3: so   
SET  $chem4  =  184 ;            //   chem4: hcho   
SET  $chem5  =  185 ;            //   chem5: go3   
SET  $cod  =  175 ;              //   cloud optical depth   
SET  $rao  =  176 ;              //   Ratio of fine mode to total aerosol optical depth at 0.55 microns   
SET  $od  =  177 ;               //   optical depth   
SET  $rfltnc  =  178 ;           //   Aerosol reflectance multi-channel   
SET  $nsoilm  =  179 ;           //   normalized soil moisture  (0-100%) 
SET  $soilm  =  180 ;            //   soil moisture   
SET  $flgt_phase  =  201 ;       //   phase of aircraft flight  
SET  $height_assignment_method  =  211 ;                  //  Height assignment method   
SET  $dopp  =  195 ;             //   radar doppler wind   
SET  $ghg1  =  186 ;             //   ghg1: carbon dioxide   
SET  $ghg2  =  188 ;             //   ghg2: methane   
SET  $ghg3  =  189 ;             //   ghg3: nitrous oxide   
SET  $bt_real  =  190 ;          //   brightness temperature real part  
SET  $bt_imaginary  =  191 ;     //   brightness temperature imaginary part  
SET  $prc  =  202 ;              //   radar rain rate   
SET  $lnprc  =  203 ;            //   log(radar rain rate mm/h + epsilon)   
SET  $libksc  =  222 ;           //   lidar backscattering  
SET  $ralt_swh  =  220 ;         //   significant wave height (m)           
SET  $ralt_sws  =  221 ;         //   surface wind speed (m/s)              
SET  $rawbt_clear  =  193 ;      //   brightness temperature for clear  (K) 
SET  $rawbt_cloudy  =  194 ;     //   brightness temperature for cloudy (K)
SET  $binary_snow_cover = 223;   //   binary snow cover (0: no snow / 1: presence of snow)
SET  $salinity = 224;            //   ocean salinity (PSU)
SET  $potential_temp = 225;      //   potential temperature (Kelvin)
SET  $humidity_mixing_ratio = 226;    // humidity mixing ratio (kg/kg)
SET  $airframe_icing = 227;           // airframe icing
SET  $turbulence_index = 228;         // turbulence index
SET  $lidar_aerosol_extinction = 236; // lidar aerosol extinction
SET  $lidar_cloud_backscatter  = 237; // lidar cloud backscatter
SET  $lidar_cloud_extinction   = 238; // lidar cloud extinction
SET  $cloud_radar_reflectivity = 239; // cloud radar reflectivity

// Additional variable numbers required by Met Office
SET $pstation = 107;             // Station pressure (Pa)
SET $pmsl = 108;                 // Mean sea-level pressure (Pa)
SET $pstandard = 109;            // Standard level pressure (Pa)
SET $vert_vv = 218;              // Vertical visibility (m)
SET $max_wind_shear1 = 219;      // Wind shear above and below 1st maximum wind in sonde profile (s-1)
SET $tot_zen_delay = 229;        // Total zenith delay (GPS)
SET $tot_zen_delay_err = 230;    // Total zenith delay error (GPS)
SET $cloud_top_temp = 231;       // Cloud top temperature (K)
SET $rawsca = 233;               // Scaled radiance
SET $cloud_top_press = 235;      // Cloud top pressure (Pa)
SET $mean_freq = 241;            // GPSRO mean frequency
SET $u_amb = 242;                // Ambiguous u-wind component (m/s)
SET $v_amb = 243;                // Ambiguous v-wind component (m/s)
SET $lwp = 244;                  // Liquid water path
SET $tcwv = 245;                 // Total column water vapour
SET $theta = 225;                // [alias to $potential_temp]
SET $cloud_frac_clear = 247;     // Cloud clear fraction
SET $rawbt_hirs = 248;           // Raw brightness temperature specific to HIRS (K)
SET $rawbt_amsu = 249;           // Raw brightness temperature specific to AMSU (K)
SET $rawbt_hirs20 = 250;         // Raw brightness temperature specific to HIRS (K)
SET $sea_ice = 253;              // Sea ice fraction
SET $cloud_frac_covered = 257;   // Cloud covered fraction
SET $level_mixing_ratio = 258;   // [alias for $humidity_mixing_ratio]
SET $radial_velocity = 259;      // Radial velocity from doppler radar
SET $cloud_ice_water = 260;      // Cloud ice water
SET $wind_gust = 261;            // Maximum wind gust (m/s)
SET $mass_density = 262;         // Mass density
SET $atmosphere_number = 263;    // SFERICS number of atmospheres
SET $lightning = 265;            // Lightning strike observation (ATDNET)
SET $level_cloud = 266;          // Cloud fraction (multi-level)
SET $rawbt_amsr_89ghz = 267;     // Raw brightness temperature specific to AMSR 89GHz channels (K)
SET $max_wind_shear2 = 268;      // Wind shear above and below 2nd maximum wind in sonde profile
SET $lower_layer_p = 269;        // Pressure at bottom of layer SBUV (Pa)
SET $upper_layer_p = 270;        // Pressure at top of later SBUV (Pa)
SET $cloud_cover = 271;          // Total cloud cover
SET $depth = 272;                // Depth (m)
SET $ssh = 273;                  // Sea surface height (m)
SET $rawbt_mwts = 274;           // Raw brightness temperature specific to MWTS (K)
SET $rawbt_mwhs = 275;           // Raw brightness temperature specific to MWHS (K)
