C
C $Id: tdstri.f,v 1.4 2008-07-27 00:17:33 haley Exp $
C                                                                      
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
      SUBROUTINE TDSTRI (U,NU,V,NV,W,LW1D,RTRI,MTRI,NTRI,IRST)
C
        DIMENSION U(NU),V(NV),W(LW1D,*),RTRI(10,MTRI)
C
C The routine TDSTRI, given a two-dimensional array of function values,
C generates a set of triangles representing the surface defined by those
C values and adds them to a list of triangles tendered by the user.  The
C arguments are as follows:
C
C   U is an input array of real values of the independent variable U.
C
C   NU is an input integer specifying the dimension of the array U.
C
C   V is an input array of real values of the independent variable V.
C
C   NV is an input integer specifying the dimension of the array V.
C
C   W is the two-dimensional real array of function values.  For each
C   I from 1 to NU and for each J from 1 to NV, (U(I),V(J),W(I,J)) is
C   a point on the surface represented by the arrays U, V, and W.
C
C   LW1D is an input integer specifying the first (FORTRAN) dimension of
C   the array W.  It must be the case that LW1D is greater than or equal
C   to NU.
C
C   RTRI is a real array in which a list of triangles is being
C   generated; it is dimensioned 10 x MTRI.  Each 10-word entry in
C   the list consists of the U, V, and W coordinates of each of three
C   points, followed by a rendering style index.
C
C   MTRI is an input integer specifying the second dimension of the
C   array RTRI: the maximum number of triangles the list will hold.
C
C   NTRI is an input/output integer specifying the number of triangles
C   currently in the array RTRI.  Initially, NTRI must be zeroed by the
C   user.  Each call to one of the routines TDSTRI or TDITRI updates the
C   value of NTRI to reflect the number of triangles added to the list.
C
C   IRST is an input integer specifying the rendering style index to be
C   used for all the triangles generated by a particular call to TDSTRI.
C   Note that more than one surface can be represented by the triangles
C   in the triangle list and that each surface can be rendered in its
C   own particular style.
C
C Get the real equivalent of the rendering style index.
C
        RRST=REAL(IRST)
C
C Loop through the grid boxes, generating two triangles apiece.  Note
C that each triangle is traced in a counterclockwise direction as
C viewed from above; this is important, as it enables the renderer to
C tell which side of a triangle is being looked at.
C
        DO 102 I=1,NU-1
          DO 101 J=1,NV-1
            IF (NTRI.LT.MTRI) THEN
              NTRI=NTRI+1
              RTRI(1,NTRI)=U(I)
              RTRI(2,NTRI)=V(J+1)
              RTRI(3,NTRI)=W(I,J+1)
              RTRI(4,NTRI)=U(I)
              RTRI(5,NTRI)=V(J)
              RTRI(6,NTRI)=W(I,J)
              RTRI(7,NTRI)=U(I+1)
              RTRI(8,NTRI)=V(J)
              RTRI(9,NTRI)=W(I+1,J)
              RTRI(10,NTRI)=RRST
            END IF
            IF (NTRI.LT.MTRI) THEN
              NTRI=NTRI+1
              RTRI(1,NTRI)=U(I+1)
              RTRI(2,NTRI)=V(J)
              RTRI(3,NTRI)=W(I+1,J)
              RTRI(4,NTRI)=U(I+1)
              RTRI(5,NTRI)=V(J+1)
              RTRI(6,NTRI)=W(I+1,J+1)
              RTRI(7,NTRI)=U(I)
              RTRI(8,NTRI)=V(J+1)
              RTRI(9,NTRI)=W(I,J+1)
              RTRI(10,NTRI)=RRST
            END IF
  101     CONTINUE
  102   CONTINUE
C
C Done.
C
        RETURN
C
      END
