/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <stdio.h>
#include <limits.h>
#include <assert.h>

#include "umutil.h"

/*
 * Create path from name and prefix.
 */
const char *
buildpath(const char *prefix, const char *name)
{
	static char path[PATH_MAX];
	int ret;

	ret = snprintf(path, sizeof(path), "%s/%s", prefix, name);
	assert(ret < sizeof path);
	return path;
}
