/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "system.h"
#include "glue-gui.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-fi.h"
#include "glue.h"
#include "sig_integer.h"

#include "network_cable_gui_gtk.h"

#define COMP	"network_cable"

struct cpssp {
	GtkWidget *fi_dialog;

	unsigned int comp_id;

	unsigned int fault_packet_loss_sigid;
	struct sig_integer *fault_packet_loss;
};

/*
 * Simulator Callbacks
 */

/*
 * GUI Callbacks
 */
static void
network_cable_gui_gtk_packet_loss_event(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = _fault;
	struct cpssp *cpssp = _cpssp;

	sig_integer_set(cpssp->fault_packet_loss, cpssp, fault->state);

	free(fault);
}

void *
network_cable_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *manage,
	struct sig_eth_conn *port_end0,
	struct sig_eth_conn *port_end1
)
{
	struct cpssp *cpssp;
	char path[1024];
	GtkWidget *w;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	system_name_push(name);

	cpssp->comp_id = system_comp_lookup(name);

	cpssp->fi_dialog = gtk_vbox_new(FALSE, 1);

	w = gui_gtk_fi_new("Packet Loss", "Percentage");
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(network_cable_gui_gtk_packet_loss_event),
			cpssp);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->fi_dialog), w, FALSE, FALSE, 1);

	gui_gtk_comp_add(page, COMP, name, NULL,
			FALSE, FALSE, cpssp->fi_dialog);

	/* Fault Signals */
	snprintf(path, sizeof(path)-1, "%s:packet_loss", system_path());
	path[sizeof(path)-1] = '\0';
	cpssp->fault_packet_loss_sigid = system_sig_create("integer", path);
	assert(0 <= cpssp->fault_packet_loss_sigid);
	system_comp_connect(cpssp->comp_id, "packet_loss",
			cpssp->fault_packet_loss_sigid);
	cpssp->fault_packet_loss = system_sig_get(cpssp->fault_packet_loss_sigid);

	system_name_pop();

	return cpssp;
}

void
network_cable_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	system_comp_disconnect(cpssp->comp_id, "packet_loss");
	system_sig_unget(cpssp->fault_packet_loss);
	system_sig_destroy(cpssp->fault_packet_loss_sigid);

	shm_free(cpssp);
}

void
network_cable_gui_gtk_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
network_cable_gui_gtk_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	GtkWidget *savefi_dialog = cpssp->fi_dialog;

	generic_resume(cpssp, sizeof(*cpssp), fComp);

	cpssp->fi_dialog = savefi_dialog;

	fprintf(stdout, "\t\t\ttoDo: Handle GtkWidget fi_dialog\n");
}
