.\"
.\" lpr man page for CUPS.
.\"
.\" Copyright 2007-2016 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lpr 1 "CUPS" "2 May 2016" "Apple Inc."
.SH NAME
lpr \- print files
.SH SYNOPSIS
.B lpr
[
.B \-E
] [
\fB\-H \fIserver\fR[\fB:\fIport\fR]
] [
.B \-U
.I username
] [
\fB\-P \fIdestination\fR[\fB/\fIinstance\fR]
] [
.B \-#
.I num-copies
[
.B \-h
] [
.B \-l
] [
.B \-m
] [
\fB\-o \fIoption\fR[\fB=\fIvalue\fR]
] [
.B \-p
] [
.B \-q
] [
.B \-r
] [
.B \-C
.I title
] [
.B \-J
.I title
] [
.B \-T
.I title
] [
.I file(s)
]
.SH DESCRIPTION
\fBlpr\fR submits files for printing.
Files named on the command line are sent to the named printer or the default destination if no destination is specified.
If no files are listed on the command-line, \fBlpr\fR reads the print file from the standard input.
.SS THE DEFAULT DESTINATION
CUPS provides many ways to set the default destination. The \fBLPDEST\fR and \fBPRINTER\fR environment variables are consulted first.
If neither are set, the current default set using the
.BR lpoptions (1)
command is used, followed by the default set using the
.BR lpadmin (8)
command.
.SH OPTIONS
The following options are recognized by \fIlpr\fR:
.TP 5
.B \-E
Forces encryption when connecting to the server.
.TP 5
\fB\-H \fIserver\fR[\fB:\fIport\fR]
Specifies an alternate server.
.TP 5
\fB\-C "\fIname\fB"\fR
.TP 5
\fB\-J "\fIname\fB"\fR
.TP 5
\fB\-T "\fIname\fB"\fR
Sets the job name/title.
.TP 5
\fB\-P \fIdestination\fR[\fB/\fIinstance\fR]
Prints files to the named printer.
.TP 5
\fB\-U \fIusername\fR
Specifies an alternate username.
.TP 5
\fB\-# \fIcopies\fR
Sets the number of copies to print.
.TP 5
.B \-h
Disables banner printing. This option is equivalent to \fI-o job\-sheets=none\fR.
.TP 5
.B \-l
Specifies that the print file is already formatted for the destination and should be sent without filtering.
This option is equivalent to \fI-o raw\fR.
.TP 5
.B \-m
Send an email on job completion.
.TP 5
\fB\-o \fIoption\fR[\fB=\fIvalue\fR]
Sets a job option.
See "COMMON JOB OPTIONS" below.
.TP 5
.B \-p
Specifies that the print file should be formatted with a shaded header with the date, time, job name, and page number.
This option is equivalent to \fI\-o prettyprint\fR and is only useful when printing text files.
.TP 5
.B \-q
Hold job for printing.
.TP 5
.B \-r
Specifies that the named print files should be deleted after submitting them.
.SS COMMON JOB OPTIONS
Aside from the printer-specific options reported by the
.BR lpoptions (1)
command, the following generic options are available:
.TP 5
\fB\-o collate=true\fR
Prints collated copies.
.TP 5
\fB\-o fit\-to\-page\fR
Scales the print file to fit on the page.
.TP 5
\fB\-o job-hold-until=\fIwhen\fR
Holds the job until the specified local time.
"when" can be "indefinite" to hold the until released, "day-time" to print the job between 6am and 6pm local time, "night" to print the job between 6pm and 6am local time, "second-shift" to print the job between 4pm and 12am local time, "third-shift" to print the job between 12am and 8am local time, or "weekend" to print the job on Saturday or Sunday.
.TP 5
\fB\-o job-hold-until=\fIhh:mm\fR
Holds the job until the specified time in hours and minutes UTC.
.TP 5
\fB\-o job-priority=\fIpriority\fR
Set the priority to a value from 1 (lowest) to 100 (highest), which influences when a job is scheduled for printing.
The default priority is typically 50.
.TP 5
\fB\-o job-sheets=\fIname\fR\fR
Prints a cover page (banner) with the document.
The "name" can be "classified", "confidential", "secret", "standard", "topsecret", or "unclassified".
.TP 5
\fB\-o job-sheets=\fIstart-name,end-name\fR\fR
Prints cover pages (banners) with the document.
.TP 5
\fB\-o media=\fIsize\fR
Sets the page size to \fIsize\fR. Most printers support at least the size names "a4", "letter", and "legal".
.TP 5
\fB\-o mirror\fR
Mirrors each page.
.TP 5
\fB\-o number\-up=\fR{\fI2|4|6|9|16\fR}
Prints 2, 4, 6, 9, or 16 document (input) pages on each output page.
.TP 5
\fB\-o number\-up\-layout=\fIlayout\fR
Specifies the layout of pages with the "number-up" option.
The "layout" string can be "btlr", "btrl", "lrbt", "lrtb", "rlbt", "rltb", "tblr", or "tbrl" - the first two letters determine the column order while the second two letters determine the row order.
"bt" is bottom-to-top, "lr" is left-to-right, "rl" is right-to-left, and "tb" is top-to-bottom.
.TP 5
\fB\-o orientation\-requested=4\fR
Prints the job in landscape (rotated 90 degrees counter-clockwise).
.TP 5
\fB\-o orientation\-requested=5\fR
Prints the job in landscape (rotated 90 degrees clockwise).
.TP 5
\fB\-o orientation\-requested=6\fR
Prints the job in reverse portrait (rotated 180 degrees).
.TP 5
\fB\-o outputorder=reverse\fR
Prints pages in reverse order.
.TP 5
\fB\-o page\-border=\fIborder\fR
Prints a border around each document page.
"border" is "double", "double\-thick", "single", or "single\-thick".
.TP 5
\fB\-o page\-ranges=\fIpage-list\fR
Specifies which pages to print in the document.
The list can contain a list of numbers and ranges (#-#) separated by commas, e.g., "1,3-5,16".
The page numbers refer to the output pages and not the document's original pages - options like "number-up" can affect the numbering of the pages.
.TP 5
\fB\-o sides=one\-sided\fR
Prints on one side of the paper.
.TP 5
\fB\-o sides=two\-sided\-long\-edge\fR
Prints on both sides of the paper for portrait output.
.TP 5
\fB\-o sides=two\-sided\-short\-edge\fR
Prints on both sides of the paper for landscape output.
.SH NOTES
The \fI\-c\fR, \fI\-d\fR, \fI\-f\fR, \fI\-g\fR, \fI\-i\fR, \fI\-n\fR, \fI\-t\fR, \fI\-v\fR, and \fI\-w\fR options are not supported by CUPS and produce a warning message if used.
.SH EXAMPLES
Print two copies of a document to the default printer:
.nf

    lpr -# 2 filename

.fi
Print a double-sided legal document to a printer called "foo":
.nf

    lpr -P foo -o media=legal -o sides=two-sided-long-edge filename

.fi
Print a presentation document 2-up to a printer called "foo":
.nf

    lpr -P foo -o number-up=2 filename
.fi
.SH SEE ALSO
.BR cancel (1),
.BR lp (1),
.BR lpadmin (8),
.BR lpoptions (1),
.BR lpq (1),
.BR lprm (1),
.BR lpstat (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2016 by Apple Inc.
