#ifndef __AMP_SHAPEDESCRIPTOR__
#define __AMP_SHAPEDESCRIPTOR__

#include "ShapeLd.hpp"

static short kShapeDescriptor[kNumShapes][5] = {	// Items

	// ID  x   y   dx  dy
	//---------------------
	{4100, 0, 576, 32, 32},	// Schwert
	{4101, 32, 576, 32, 32}, // Phiole
	{4102, 64, 576, 32, 32}, 
	{4103, 96, 576, 32, 32},
	{4104, 128, 576, 32, 32},
	{4105, 160, 576, 32, 32},
	{4106, 192, 576, 32, 32},
	{4107, 224, 576, 32, 32},
	{4110, 0, 608, 32, 32}, // Munition
	{4111, 32, 608, 32, 32},
	{4112, 64, 608, 32, 32},
	{4113, 96, 608, 32, 32},
	{4114, 128, 608, 32, 32},
	{4115, 160, 608, 32, 32},
	{4120, 192, 608, 32, 32}, // Helppacket
	{4121, 224, 608, 32, 32}, // Sauerstoff
	{4122, 256, 608, 32, 32}, // Feuerstein
	{4000, 0, 512, 32, 32},		// Fenster 1
	{4001, 32, 512, 32, 32},  // Fenster 2
	{4002, 64, 512, 32, 32}, // Tor solid
	{4003, 96, 512, 32, 32}, // Gitter
	{4004, 128, 512, 32, 32}, // Dach l
	{4005, 160, 512, 32, 32}, // Dach R
	{4006, 192, 512, 32, 32}, // Busch 1
	{4007, 224, 512, 32, 32}, // Busch 2
	{4008, 256, 512, 32, 32}, // Tropfstein
	{4009, 288, 512, 32, 32},
	{4010, 320, 512, 32, 32},
	{4011, 352, 512, 32, 32},
	{4012, 384, 512, 32, 32},
	{4013, 416, 512, 32, 32},
	{4014, 448, 512, 32, 32},
	{4015, 0, 544, 32, 32},
	{4016, 32, 544, 32, 32},
	{4017, 64, 544, 32, 32},
	{4018, 96, 544, 32, 32},
	{4020, 128, 544, 32, 32},
	{4019, 416, 544, 64, 64},
// Player
	{500, 0 * 32, 32, 32, 32},	// Sword
	{501, 1 * 32, 32, 32, 32},
	{502, 2 * 32, 32, 32, 32},
	{503, 3 * 32, 32, 32, 32},
	{504, 4 * 32, 32, 32, 32},
	{505, 5 * 32, 32, 32, 32},
	{506, 6 * 32, 32, 32, 32},
	{507, 7 * 32, 32, 32, 32},
	{520, 0 * 32, 64, 32, 32},	// Phiole
	{521, 1 * 32, 64, 32, 32},
	{522, 2 * 32, 64, 32, 32},
	{523, 3 * 32, 64, 32, 32},
	{524, 4 * 32, 64, 32, 32},
	{510, 5 * 32, 64, 32, 32},	// Bacchetta
	{511, 6 * 32, 64, 32, 32},
	{512, 7 * 32, 64, 32, 32},
	{513, 8 * 32, 64, 32, 32},
	{514, 9 * 32, 64, 32, 32},
	{530, 10 * 32, 64, 32, 32},	// Bow
	{531, 11 * 32, 64, 32, 32},
	{532, 12 * 32, 64, 32, 32},
	{533, 13 * 32, 64, 32, 32},
	{534, 14 * 32, 64, 32, 32},
	{535, 15 * 32, 64, 32, 32},
	{540, 0 * 32, 96, 32, 32},	// Scie
	{541, 1 * 32, 96, 32, 32},
	{542, 2 * 32, 96, 32, 32},
	{543, 3 * 32, 96, 32, 32},
	{544, 4 * 32, 96, 32, 32},
	{545, 5 * 32, 96, 32, 32},
	{546, 6 * 32, 96, 32, 32},
	{550, 7 * 32, 96, 32, 32},	// Hands
	{551, 8 * 32, 96, 32, 32},
	{552, 9 * 32, 96, 32, 32},
	{553, 10 * 32, 96, 32, 32},
	{554, 11 * 32, 96, 32, 32},
	{560, 0 * 32, 128, 32, 32},	// Bombs
	{561, 1 * 32, 128, 32, 32},
	{562, 2 * 32, 128, 32, 32},
	{563, 3 * 32, 128, 32, 32},
	{564, 4 * 32, 128, 32, 32},
	{570, 5 * 32, 128, 32, 32},	// Staff
	{571, 6 * 32, 128, 32, 32},
	{572, 7 * 32, 128, 32, 32},
	{573, 8 * 32, 128, 32, 32},
	{574, 9 * 32, 128, 32, 32},
	{575, 10 * 32, 128, 32, 32},
// Creeper
	{1000, 0 * 32, 160, 32, 32},
	{1001, 1 * 32, 160, 32, 32},
	{1002, 2 * 32, 160, 32, 32},
	{1003, 3 * 32, 160, 32, 32},
	{1004, 4 * 32, 160, 32, 32},
	{1005, 5 * 32, 160, 32, 32},
	{1006, 6 * 32, 160, 32, 32},
	{1007, 7 * 32, 160, 32, 32},
// Saqqraq
	{1010, 8 * 32, 160, 32, 32},
	{1011, 9 * 32, 160, 32, 32},
	{1012, 10 * 32, 160, 32, 32},
	{1013, 11 * 32, 160, 32, 32},
	{1014, 12 * 32, 160, 32, 32},
	{1015, 13 * 32, 160, 32, 32},
	{1016, 14 * 32, 160, 32, 32},
	{1017, 15 * 32, 160, 32, 32},
// Deadfish
	{1020, 0 * 32, 192, 32, 32},
	{1021, 1 * 32, 192, 32, 32},
	{1022, 2 * 32, 192, 32, 32},
	{1023, 3 * 32, 192, 32, 32},
	{1024, 4 * 32, 192, 32, 32},
	{1025, 5 * 32, 192, 32, 32},
	{1026, 6 * 32, 192, 32, 32},
	{1027, 7 * 32, 192, 32, 32},
// Ork
	{1030, 8 * 32, 192, 32, 32},
	{1031, 9 * 32, 192, 32, 32},
	{1032, 10 * 32, 192, 32, 32},
	{1033, 11 * 32, 192, 32, 32},
	{1034, 12 * 32, 192, 32, 32},
	{1035, 13 * 32, 192, 32, 32},
	{1036, 14 * 32, 192, 32, 32},
	{1037, 15 * 32, 192, 32, 32},
// Libelle
	{1050, 0 * 32, 224, 32, 32},
	{1051, 1 * 32, 224, 32, 32},
	{1052, 2 * 32, 224, 32, 32},
	{1053, 3 * 32, 224, 32, 32},
	{1054, 4 * 32, 224, 32, 32},
	{1055, 5 * 32, 224, 32, 32},
	{1056, 6 * 32, 224, 32, 32},
	{1057, 7 * 32, 224, 32, 32},
// BlackOrk
	{1060, 8 * 32, 224, 32, 32},
	{1061, 9 * 32, 224, 32, 32},
	{1062, 10 * 32, 224, 32, 32},
	{1063, 11 * 32, 224, 32, 32},
	{1064, 12 * 32, 224, 32, 32},
	{1065, 13 * 32, 224, 32, 32},
	{1066, 14 * 32, 224, 32, 32},
	{1067, 15 * 32, 224, 32, 32},
// Oger
	{1070, 0 * 32, 256, 32, 32},
	{1071, 1 * 32, 256, 32, 32},
	{1072, 2 * 32, 256, 32, 32},
	{1073, 3 * 32, 256, 32, 32},
	{1074, 4 * 32, 256, 32, 32},
	{1075, 5 * 32, 256, 32, 32},
	{1076, 6 * 32, 256, 32, 32},
	{1077, 7 * 32, 256, 32, 32},
// Nazgul
	{1040, 8 * 32, 256, 32, 32},
	{1041, 9 * 32, 256, 32, 32},
	{1042, 10 * 32, 256, 32, 32},
	{1043, 11 * 32, 256, 32, 32},
	{1044, 12 * 32, 256, 32, 32},
	{1045, 13 * 32, 256, 32, 32},
	{1046, 14 * 32, 256, 32, 32},
	{1047, 15 * 32, 256, 32, 32},
// Otyg
	{1080, 0 * 32, 288, 32, 32},
	{1081, 1 * 32, 288, 32, 32},
	{1082, 2 * 32, 288, 32, 32},
	{1083, 3 * 32, 288, 32, 32},
	{1084, 4 * 32, 288, 32, 32},
	{1085, 5 * 32, 288, 32, 32},
	{1086, 6 * 32, 288, 32, 32},
	{1087, 7 * 32, 288, 32, 32},
// Grieg
	{1090, 8 * 32, 288, 32, 32},
	{1091, 9 * 32, 288, 32, 32},
	{1092, 10 * 32, 288, 32, 32},
	{1093, 11 * 32, 288, 32, 32},
	{1094, 12 * 32, 288, 32, 32},
	{1095, 13 * 32, 288, 32, 32},
	{1096, 14 * 32, 288, 32, 32},
	{1097, 15 * 32, 288, 32, 32},
// Warg
	{1100, 0 * 64, 320, 64, 64},
	{1101, 1 * 64, 320, 64, 64},
	{1102, 2 * 64, 320, 64, 64},
	{1103, 3 * 64, 320, 64, 64},
	{1104, 4 * 64, 320, 64, 64},
	{1105, 5 * 64, 320, 64, 64},
	{1106, 6 * 64, 320, 64, 64},
	{1107, 7 * 64, 320, 64, 64},
// Weapons
	{4803, 105, 649, 14, 14}, // Phiole
	{5100, 7 * 32, 672, 32, 32},
	{5101, 8 * 32, 672, 32, 32},
	{4804, 138, 650, 12, 12}, // Zauberstab
	{5110, 9 * 32, 672, 32, 32},
	{5111, 10 * 32, 672, 32, 32},
	{4802, 71, 650, 18, 10},	// Pfeilbogen
	{5000, 0 * 32, 672, 32, 32},
	{5001, 1 * 32, 672, 32, 32},
	{5002, 2 * 32, 672, 32, 32},
	{5003, 3 * 32, 672, 32, 32},
	{5004, 4 * 32, 672, 32, 32},
	{4805, 167, 650, 16, 14},	// Hand
	{5120, 11 * 32, 672, 32, 32},
	{5121, 12 * 32, 672, 32, 32},
	{5122, 13 * 32, 672, 32, 32},
	{5123, 14 * 32, 672, 32, 32},
	{4806, 202, 652, 12, 12},  // Bombe
	{5160, 0 * 64, 800, 64, 64},
	{5161, 1 * 64, 800, 64, 64},
	{5162, 2 * 64, 800, 64, 64},
	{5163, 3 * 64, 800, 64, 64},
	{5164, 4 * 64, 800, 64, 64},
	{4807, 7 * 32, 640, 32, 32},	// Staff
	{5126, 1 * 64, 704, 64, 64},
	{5127, 2 * 64, 704, 64, 64},
	{5128, 3 * 64, 704, 64, 64},
	{5129, 4 * 64, 704, 64, 64},
	{5130, 5 * 64, 704, 64, 64},
	{4800, 9, 650, 14, 14},	// Unguided
	{4801, 38, 646, 18, 18},	// aimed
	{4810, 328, 649, 16, 16},	// guided
	{5180, 4, 741, 27, 28},
	{5181, 33, 736, 31, 31},
	{5182, 159, 769, 30, 30},
	//{4811, 6 * 32, 672, 32, 32},
	{5138, 7 * 32, 768, 32, 32},
	{5139, 8 * 32, 768, 32, 32},
	{5140, 9 * 32, 768, 32, 32},
	{5141, 10 * 32, 768, 32, 32},
	{5142, 11 * 32, 768, 32, 32},
	{4808, 263, 651, 18, 18},	// Trollbombs
	{5124, 0 * 32, 704, 32, 32},
	{5125, 1 * 32, 704, 32, 32},
	{4809, 297, 650, 14, 12},	// Otyg
	{5131, 0 * 32, 768, 32, 32},	
	{5132, 1 * 32, 768, 32, 32},
	{5133, 2 * 32, 768, 32, 32},
	{5134, 3 * 32, 768, 32, 32},
	{5135, 4 * 32, 768, 32, 32},
	{4113, 327, 649, 18, 18}, // Violett
	{5120, 6 * 32, 736, 32, 32},
	{5121, 7 * 32, 736, 32, 32},
	{5122, 8 * 32, 736, 32, 32},
	{5123, 9 * 32, 736, 32, 32},
	{5124, 10 * 32, 736, 32, 32},
	{4811, 356, 647, 25, 23},	// Warg 1
	{5150, 12 * 32, 768, 32, 32},
	{5151, 13 * 32, 768, 32, 32},	
	{4812, 384, 651, 34, 14},	// Warg 2
	{2000, 0, 384, 32, 32},			// Tre
	{2001, 33, 384, 30, 32},		// Lift
// Schalter etc.
	{200, 0 * 32, 0, 32, 32},
	{201, 1 * 32, 0, 32, 32},
	{202, 2 * 32, 0, 32, 32},
	{203, 3 * 32, 0, 32, 32},
	{204, 4 * 32, 0, 32, 32},
	{205, 5 * 32, 0, 32, 32},
	{206, 6 * 32, 0, 32, 32},
	{207, 7 * 32, 0, 32, 32},
	{208, 8 * 32, 0, 32, 32},
	{209, 9 * 32, 0, 32, 32},
	{210, 362, 0, 32, 37},
	{211, 394, 0, 32, 37},
	{300, 10 * 32, 0, 32, 32},
// Letters
	{65, 0, 864, 31, 24},
	{66, 31, 864, 32, 24},
	{67, 66, 864, 25, 24},
	{68, 95, 864, 31, 24},
	{69, 130, 864, 28, 24},
	{70, 162, 864, 32, 24},
	{71, 197, 864, 26, 24},
	{72, 228, 864, 29, 24},
	{73, 261, 864, 23, 24},

	{74, 6, 888, 25, 25},
	{75, 33, 888, 42, 25},
	{76, 79, 888, 34, 25},
	{77, 118, 888, 36, 25},
	{78, 164, 888, 34, 25},
	{79, 202, 888, 28, 25},
	{80, 234, 888, 28, 25},
	{81, 266, 888, 32, 25},
	{82, 299, 888, 39, 25},

	{83, 0, 914, 26, 25},
	{84, 32, 914, 30, 25},
	{85, 62, 914, 30, 25},
	{86, 96, 914, 29, 25},
	{87, 131, 914, 39, 25},
	{88, 170, 914, 36, 25},
	{89, 209, 914, 30, 25},
	{90, 243, 914, 26, 25},

	{33, 270, 914, 15, 25},
	{63, 291, 914, 22, 25},
	
	{49, 3, 939, 15, 21},
	{50, 25, 939, 17, 21},
	{51, 49, 939, 16, 21},
	{52, 73, 939, 17, 21},
	{53, 96, 939, 18, 21},
	{54, 121, 939, 17, 21},
	{55, 144, 939, 20, 21},
	{56, 169, 939, 16, 21},
	{57, 193, 939, 17, 21},
	{48, 217, 939, 17, 21},
	{46, 241, 939, 12, 21},
	{44, 259, 939, 11, 21},
	{45, 278, 939, 18, 21},

	{10000, 317, 543, 94, 92},
	{10001, 382, 806, 126, 126},
	{10002, 322, 802, 40, 40}


};

static short kTextureDescriptor[kNumTextures][5] = {
// Texset 1
	{3000, 0 * 32, 416, 32, 32},
	{3001, 1 * 32, 416, 32, 32},
	{3002, 2 * 32, 416, 32, 32},
	{3003, 3 * 32, 416, 32, 32},
	{3004, 4 * 32, 416, 32, 32},
	{3005, 5 * 32, 416, 32, 32},
	{3006, 6 * 32, 416, 32, 32},
	{3007, 7 * 32, 416, 32, 32},
	{3008, 8 * 32, 416, 32, 32},
	{3009, 9 * 32, 416, 32, 32},
	{3010, 10 * 32, 416, 32, 32},
	{3011, 11 * 32, 416, 32, 32},
	{3012, 12 * 32, 416, 32, 32},
	{3013, 13 * 32, 416, 32, 32},
	{3014, 14 * 32, 416, 32, 32},
// Texset 2
	{3020, 0 * 32, 448, 32, 32},
	{3021, 1 * 32, 448, 32, 32},
	{3022, 2 * 32, 448, 32, 32},
	{3023, 3 * 32, 448, 32, 32},
	{3024, 4 * 32, 448, 32, 32},
	{3025, 5 * 32, 448, 32, 32},
	{3026, 6 * 32, 448, 32, 32},
	{3027, 7 * 32, 448, 32, 32},
	{3028, 8 * 32, 448, 32, 32},
	{3029, 9 * 32, 448, 32, 32},
	{3030, 10 * 32, 448, 32, 32},
	{3031, 11 * 32, 448, 32, 32},
	{3032, 12 * 32, 448, 32, 32},
	{3033, 13 * 32, 448, 32, 32},
	{3034, 14 * 32, 448, 32, 32},
// Texset 3
	{3040, 0 * 32, 480, 32, 32},
	{3041, 1 * 32, 480, 32, 32},
	{3042, 2 * 32, 480, 32, 32},
	{3043, 3 * 32, 480, 32, 32},
	{3044, 4 * 32, 480, 32, 32},
	{3045, 5 * 32, 480, 32, 32},
	{3046, 6 * 32, 480, 32, 32},
	{3047, 7 * 32, 480, 32, 32},
	{3048, 8 * 32, 480, 32, 32},
	{3049, 9 * 32, 480, 32, 32},
	{3050, 10 * 32, 480, 32, 32},
	{3051, 11 * 32, 480, 32, 32},
	{3052, 12 * 32, 480, 32, 32},
	{3053, 13 * 32, 480, 32, 32},
	{3054, 14 * 32, 480, 32, 32}

};


#endif