/*-------------------------------------------------------------------------
 *
 * keywords.h
 *	  lexical token lookup for reserved words in postgres SQL
 *
 *
 * Portions Copyright (c) 1996-2006, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * $PostgreSQL: pgsql/src/include/parser/keywords.h,v 1.21 2006/03/05 15:58:57 momjian Exp $
 *
 *-------------------------------------------------------------------------
 */

///////////////////////////////////////////////////////////////////////////
//
// pgAdmin note: This file is based on src/include/parser/keywords.h from
//               PostgreSQL. It should be periodically updated to include
//               new keywords. struct ScanKeyword and the declaration of
//               ScanKeywordLookup originate in this file, whilst the enum
//               yytokentype is copied from src/include/parser/parse.h
//
//               This file is under the BSD licence, per PostgreSQL.
///////////////////////////////////////////////////////////////////////////

#ifndef KEYWORDS_H
#define KEYWORDS_H

/* Keyword categories --- should match lists in gram.y */
#define UNRESERVED_KEYWORD		0
#define COL_NAME_KEYWORD		1
#define TYPE_FUNC_NAME_KEYWORD	2
#define RESERVED_KEYWORD		3

typedef struct ScanKeyword
{
	const char *name;			/* in lower case */
	int		value;			/* grammar's token code */
	int		category;		/* see codes above */
} ScanKeyword;

extern const ScanKeyword *ScanKeywordLookup(const char *text);

/* Put the tokens into the symbol table, so that GDB and other debuggers
  know about them.  */

/* PGADMIN NOTE:
 *   There are a number of EnterpriseDB tokens added to the end of this list!!
 */

enum yytokentype
{
	ABORT_P = 258,
	ABSOLUTE_P = 259,
	ACCESS = 260,
	ACTION = 261,
	ADD_P = 262,
	ADMIN = 263,
	AFTER = 264,
	AGGREGATE = 265,
	ALL = 266,
	ALSO = 267,
	ALTER = 268,
	ALWAYS = 269,
	ANALYSE = 270,
	ANALYZE = 271,
	AND = 272,
	ANY = 273,
	ARRAY = 274,
	AS = 275,
	ASC = 276,
	ASSERTION = 277,
	ASSIGNMENT = 278,
	ASYMMETRIC = 279,
	AT = 280,
	AUTHORIZATION = 281,
	BACKWARD = 282,
	BEFORE = 283,
	BEGIN_P = 284,
	BETWEEN = 285,
	BIGINT = 286,
	BINARY = 287,
	BIT = 288,
	BOOLEAN_P = 289,
	BOTH = 290,
	BY = 291,
	CACHE = 292,
	CALLED = 293,
	CASCADE = 294,
	CASCADED = 295,
	CASE = 296,
	CAST = 297,
	CHAIN = 298,
	CHAR_P = 299,
	CHARACTER = 300,
	CHARACTERISTICS = 301,
	CHECK = 302,
	CHECKPOINT = 303,
	CLASS = 304,
	CLOSE = 305,
	CLUSTER = 306,
	COALESCE = 307,
	COLLATE = 308,
	COLUMN = 309,
	COMMENT = 310,
	COMMIT = 311,
	COMMITTED = 312,
	CONCURRENTLY = 313,
	CONFIGURATION = 314,
	CONNECTION = 315,
	CONSTRAINT = 316,
	CONSTRAINTS = 317,
	CONTENT_P = 318,
	CONVERSION_P = 319,
	COPY = 320,
	COST = 321,
	CREATE = 322,
	CREATEDB = 323,
	CREATEROLE = 324,
	CREATEUSER = 325,
	CROSS = 326,
	CSV = 327,
	CURRENT_P = 328,
	CURRENT_DATE = 329,
	CURRENT_ROLE = 330,
	CURRENT_TIME = 331,
	CURRENT_TIMESTAMP = 332,
	CURRENT_USER = 333,
	CURSOR = 334,
	CYCLE = 335,
	DATABASE = 336,
	DAY_P = 337,
	DEALLOCATE = 338,
	DEC = 339,
	DECIMAL_P = 340,
	DECLARE = 341,
	DEFAULT = 342,
	DEFAULTS = 343,
	DEFERRABLE = 344,
	DEFERRED = 345,
	DEFINER = 346,
	DELETE_P = 347,
	DELIMITER = 348,
	DELIMITERS = 349,
	DESC = 350,
	DICTIONARY = 351,
	DISABLE_P = 352,
	DISCARD = 353,
	DISTINCT = 354,
	DO = 355,
	DOCUMENT_P = 356,
	DOMAIN_P = 357,
	DOUBLE_P = 358,
	DROP = 359,
	EACH = 360,
	ELSE = 361,
	ENABLE_P = 362,
	ENCODING = 363,
	ENCRYPTED = 364,
	END_P = 365,
	ENUM_P = 366,
	ESCAPE = 367,
	EXCEPT = 368,
	EXCLUDING = 369,
	EXCLUSIVE = 370,
	EXECUTE = 371,
	EXISTS = 372,
	EXPLAIN = 373,
	EXTERNAL = 374,
	EXTRACT = 375,
	FALSE_P = 376,
	FAMILY = 377,
	FETCH = 378,
	FIRST_P = 379,
	FLOAT_P = 380,
	FOR = 381,
	FORCE = 382,
	FOREIGN = 383,
	FORWARD = 384,
	FREEZE = 385,
	FROM = 386,
	FULL = 387,
	FUNCTION = 388,
	GLOBAL = 389,
	GRANT = 390,
	GRANTED = 391,
	GREATEST = 392,
	GROUP_P = 393,
	HANDLER = 394,
	HAVING = 395,
	HEADER_P = 396,
	HOLD = 397,
	HOUR_P = 398,
	IF_P = 399,
	ILIKE = 400,
	IMMEDIATE = 401,
	IMMUTABLE = 402,
	IMPLICIT_P = 403,
	IN_P = 404,
	INCLUDING = 405,
	INCREMENT = 406,
	INDEX = 407,
	INDEXES = 408,
	INHERIT = 409,
	INHERITS = 410,
	INITIALLY = 411,
	INNER_P = 412,
	INOUT = 413,
	INPUT_P = 414,
	INSENSITIVE = 415,
	INSERT = 416,
	INSTEAD = 417,
	INT_P = 418,
	INTEGER = 419,
	INTERSECT = 420,
	INTERVAL = 421,
	INTO = 422,
	INVOKER = 423,
	IS = 424,
	ISNULL = 425,
	ISOLATION = 426,
	JOIN = 427,
	KEY = 428,
	LANCOMPILER = 429,
	LANGUAGE = 430,
	LARGE_P = 431,
	LAST_P = 432,
	LEADING = 433,
	LEAST = 434,
	LEFT = 435,
	LEVEL = 436,
	LIKE = 437,
	LIMIT = 438,
	LISTEN = 439,
	LOAD = 440,
	LOCAL = 441,
	LOCALTIME = 442,
	LOCALTIMESTAMP = 443,
	LOCATION = 444,
	LOCK_P = 445,
	LOGIN_P = 446,
	MAPPING = 447,
	MATCH = 448,
	MAXVALUE = 449,
	MINUTE_P = 450,
	MINVALUE = 451,
	MODE = 452,
	MONTH_P = 453,
	MOVE = 454,
	NAME_P = 455,
	NAMES = 456,
	NATIONAL = 457,
	NATURAL = 458,
	NCHAR = 459,
	NEW = 460,
	NEXT = 461,
	NO = 462,
	NOCREATEDB = 463,
	NOCREATEROLE = 464,
	NOCREATEUSER = 465,
	NOINHERIT = 466,
	NOLOGIN_P = 467,
	NONE = 468,
	NOSUPERUSER = 469,
	NOT = 470,
	NOTHING = 471,
	NOTIFY = 472,
	NOTNULL = 473,
	NOWAIT = 474,
	NULL_P = 475,
	NULLIF = 476,
	NULLS_P = 477,
	NUMERIC = 478,
	OBJECT_P = 479,
	OF = 480,
	OFF = 481,
	OFFSET = 482,
	OIDS = 483,
	OLD = 484,
	ON = 485,
	ONLY = 486,
	OPERATOR = 487,
	OPTION = 488,
	OR = 489,
	ORDER = 490,
	OUT_P = 491,
	OUTER_P = 492,
	OVERLAPS = 493,
	OVERLAY = 494,
	OWNED = 495,
	OWNER = 496,
	PARSER = 497,
	PARTIAL = 498,
	PASSWORD = 499,
	PLACING = 500,
	PLANS = 501,
	POSITION = 502,
	PRECISION = 503,
	PRESERVE = 504,
	PREPARE = 505,
	PREPARED = 506,
	PRIMARY = 507,
	PRIOR = 508,
	PRIVILEGES = 509,
	PROCEDURAL = 510,
	PROCEDURE = 511,
	QUOTE = 512,
	READ = 513,
	REAL = 514,
	REASSIGN = 515,
	RECHECK = 516,
	REFERENCES = 517,
	REINDEX = 518,
	RELATIVE_P = 519,
	RELEASE = 520,
	RENAME = 521,
	REPEATABLE = 522,
	REPLACE = 523,
	REPLICA = 524,
	RESET = 525,
	RESTART = 526,
	RESTRICT = 527,
	RETURNING = 528,
	RETURNS = 529,
	REVOKE = 530,
	RIGHT = 531,
	ROLE = 532,
	ROLLBACK = 533,
	ROW = 534,
	ROWS = 535,
	RULE = 536,
	SAVEPOINT = 537,
	SCHEMA = 538,
	SCROLL = 539,
	SEARCH = 540,
	SECOND_P = 541,
	SECURITY = 542,
	SELECT = 543,
	SEQUENCE = 544,
	SERIALIZABLE = 545,
	SESSION = 546,
	SESSION_USER = 547,
	SET = 548,
	SETOF = 549,
	SHARE = 550,
	SHOW = 551,
	SIMILAR = 552,
	SIMPLE = 553,
	SMALLINT = 554,
	SOME = 555,
	STABLE = 556,
	STANDALONE_P = 557,
	START = 558,
	STATEMENT = 559,
	STATISTICS = 560,
	STDIN = 561,
	STDOUT = 562,
	STORAGE = 563,
	STRICT_P = 564,
	STRIP_P = 565,
	SUBSTRING = 566,
	SUPERUSER_P = 567,
	SYMMETRIC = 568,
	SYSID = 569,
	SYSTEM_P = 570,
	TABLE = 571,
	TABLESPACE = 572,
	TEMP = 573,
	TEMPLATE = 574,
	TEMPORARY = 575,
	TEXT_P = 576,
	THEN = 577,
	TIME = 578,
	TIMESTAMP = 579,
	TO = 580,
	TRAILING = 581,
	TRANSACTION = 582,
	TREAT = 583,
	TRIGGER = 584,
	TRIM = 585,
	TRUE_P = 586,
	TRUNCATE = 587,
	TRUSTED = 588,
	TYPE_P = 589,
	UNCOMMITTED = 590,
	UNENCRYPTED = 591,
	UNION = 592,
	UNIQUE = 593,
	UNKNOWN = 594,
	UNLISTEN = 595,
	UNTIL = 596,
	UPDATE = 597,
	USER = 598,
	USING = 599,
	VACUUM = 600,
	VALID = 601,
	VALIDATOR = 602,
	VALUE_P = 603,
	VALUES = 604,
	VARCHAR = 605,
	VARYING = 606,
	VERBOSE = 607,
	VERSION_P = 608,
	VIEW = 609,
	VOLATILE = 610,
	WHEN = 611,
	WHERE = 612,
	WHITESPACE_P = 613,
	WITH = 614,
	WITHOUT = 615,
	WORK = 616,
	WRITE = 617,
	XML_P = 618,
	XMLATTRIBUTES = 619,
	XMLCONCAT = 620,
	XMLELEMENT = 621,
	XMLFOREST = 622,
	XMLPARSE = 623,
	XMLPI = 624,
	XMLROOT = 625,
	XMLSERIALIZE = 626,
	YEAR_P = 627,
	YES_P = 628,
	ZONE = 629,
	NULLS_FIRST = 630,
	NULLS_LAST = 631,
	WITH_CASCADED = 632,
	WITH_LOCAL = 633,
	WITH_CHECK = 634,
	IDENT = 635,
	FCONST = 636,
	SCONST = 637,
	BCONST = 638,
	XCONST = 639,
	Op = 640,
	ICONST = 641,
	PARAM = 642,
	POSTFIXOP = 643,
	UMINUS = 644,
	TYPECAST = 645,
	CTYPE = 646,
	WINDOW = 647,

	/* The following additions are unreserved keywords for autovacuum settings */
	AUTOVACUUM_E = 700,
	AUTOVACUUM_V_TH = 701,
	AUTOVACUUM_A_TH = 702,
	AUTOVACUUM_V_SC_F = 703,
	AUTOVACUUM_A_SC_F = 704,
	AUTOVACUUM_V_COST_D = 705,
	AUTOVACUUM_V_COST_L = 705,
	AUTOVACUUM_F_MIN_AGE = 706,
	AUTOVACUUM_F_MAX_AGE = 707,
	AUTOVACUUM_F_TBL_AGE = 707,
	FILLFACTOR = 707,

	/* The following additions are keywords in EnterpriseDB */
	CONNECT_EDB = 800,
	CONVERT_EDB = 801,
	MINUS_EDB = 802,
	NUMBER_EDB = 803,
	PACKAGE_EDB = 804,
	SMALLDATETIME_EDB = 805,
	SMALLFLOAT_EDB = 806,
	SMALLMONEY_EDB = 807,
	TINYINT_EDB = 808,
	TINYTEXT_EDB = 809,
	VARCHAR2_EDB = 810,
	EXEC_EDB = 811,
	LONG_EDB = 812,
	NOCACHE_EDB = 813,
	PLS_INTEGER_EDB = 814,
	RAW_EDB = 815,
	RETURN_EDB = 816,
	SYSDATE_EDB = 817,
	SYSTIMESTAMP_EDB = 818,

	/* The following additions are keywords in Greenplum Database */
	DISTRIBUTED_GP = 900,
	LOG_P_GP = 901

};

#endif   /* KEYWORDS_H */
