/* Xteddy - a cuddly bear to place on your desktop. */
/* Author: Stefan Gustavson, ISY-LiTH, 1994         */
/* Internet email address: stegu@itn.liu.se         */
/* This software is distributed under the GNU       */
/* Public Licence (GPL).                            */
/* Also, if you modify this program or include it   */
/* in some kind of official distribution, I would   */
/* like to know about it.                           */

/* Xpm pixmap manipulation routines for color       */
/* and grayscale teddies are from the Xpm library   */
/* by Arnaud Le Hors, lehors@sophia.inria.fr,       */
/* Copyright 1990-93 GROUPE BULL                    */

/* This is Xteddy version 2.0.2 as of 2003-06-30.   */
/* from Andreas Tille <tille@debian.org>            */
/* Changes: use Imlib instead of libxpm and load    *
 *          different image formats                 */

#define DEFAULT_IMAGE_DIR "/usr/share/xteddy"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/extensions/shape.h>
#include <X11/cursorfont.h>

#include <Imlib.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/param.h>

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

static char *progname;
Display *display;
int screen_num;

char *Extensions[] = {
  "xpm",
  "png",
  "tif",
  "jpg",
  "jpeg",
  "gif",
  "pnm",
  "XPM",
  "PNG",
  "TIF",
  "JPG",
  "JPEG",
  "GIF",
  "PNG",
  NULL
};

char *InitTeddy(char *teddy)
/* Initializing filename */
{
  char     fbuf[MAXPATHLEN], sbuf[MAXPATHLEN], *name, *ext, *sext;
  struct   stat stat_buf;
  char   **ptr;

  if ( !teddy || !*(teddy) ) return NULL;

  if ( !stat(teddy, &stat_buf) ) return strdup(teddy);
  /* Test, some image formats PIXMAP_PATH */
  strcat(strcpy(fbuf, PIXMAP_PATH), "/");
  strcat(strcat(strcpy(sbuf, DEFAULT_IMAGE_DIR), "/"), teddy);
  name = fbuf + strlen(fbuf);
  strcpy(name, teddy);
  if ( !stat(fbuf, &stat_buf) ) return strdup(fbuf);
  if ( !stat(sbuf, &stat_buf) ) return strdup(sbuf);
  strcat(name, ".");
  ext  = name + strlen(name);
  sext = sbuf + strlen(sbuf);
  for ( ptr = Extensions; *ptr; ptr++ ) {
    strcat(name, *ptr);
    if ( !stat(name, &stat_buf) ) return strdup(name);
    if ( !stat(fbuf, &stat_buf) ) return strdup(fbuf);
    strcat(sbuf, *ptr);
    if ( !stat(sbuf, &stat_buf) ) return strdup(sbuf);
    *ext = *sext = 0;
  }
  return NULL;
}

int main(int argc, char **argv)
{
  /* Display, window and gc manipulation variables */
  Window               win;
  XSetWindowAttributes setwinattr;
  unsigned long        valuemask, inputmask;
  int                  x, y, geomflags, xw, xh;
  unsigned int         border_width = 0;
  unsigned int         display_width, display_height;
  XSizeHints           size_hints;
  XWMHints             wm_hints;
  XClassHint           class_hints;
  XTextProperty        windowName, iconName;
  int                  argnum;
  int                  use_wm, float_up, allow_quit;
  XEvent               report;
  char                *display_name = NULL;
  char                 buffer[20];
  int                  bufsize = 20;
  KeySym               keysym;
  XComposeStatus       compose;
  int                  charcount;
  Cursor               cursor;
  char                *teddy;
  char                *file;

  /* Window movement variables */
  XWindowChanges       winchanges;
  Window               root, child, basewin;
  int                  offs_x, offs_y, new_x, new_y, tmp_x, tmp_y;
  unsigned int         tmp_mask;

  ImlibData           *id;
  ImlibImage          *im;

  /* Determine program name */
  if ((progname = strrchr(argv[0],'/')) == NULL)
    progname = argv[0];
  else
    progname++;
  teddy = progname; 

  /* Option handling: "-wm", "-float", "-noquit", "-geometry" */
  /* and "-display" are recognized. See manual page for details. */
  /* -F<name> ... Other pixmap name */
  use_wm = FALSE;
  float_up = FALSE;
  allow_quit = TRUE;
  x = y = 0;
  geomflags = 0;
  for ( argnum = 1; argnum < argc; argnum++ ) {
    if (!strcmp(argv[argnum],"-wm"))
      use_wm = TRUE;
    if (!strcmp(argv[argnum],"-float"))
      float_up = TRUE;
    if (!strcmp(argv[argnum],"-noquit"))
      allow_quit = FALSE;
    if (!strcmp(argv[argnum],"-geometry")) 
      geomflags = XParseGeometry(argv[++argnum], &x, &y, &xw, &xh);
    if (!strcmp(argv[argnum],"-display"))
      display_name = argv[++argnum];
    if (!strncmp(argv[argnum],"-F", 2)) 
      teddy = argv[argnum] + 2;
  }
  /* Connect to X server */
  if ( (display = XOpenDisplay(display_name)) == NULL )
    {
      (void) fprintf(stderr, "%s: Cannot connect to X server %s\n",
		     progname, XDisplayName(display_name));
      exit(-1);
    }
  /* Get screen size and depth */
  display_width  = DisplayWidth(display, screen_num);
  display_height = DisplayHeight(display, screen_num);

  if ( !(id=Imlib_init(display)) ) return -1;
  if ( !(file = InitTeddy(teddy)) ) {
    fprintf(stderr, "Can not find any image with name %s.\n", teddy);
    return -1;
  }
  if ( !(im=Imlib_load_image(id, file)) ) return -1;

  /* Set the window position according to user preferences */
  if (geomflags & XNegative)
    x = display_width - im->rgb_width + x;
  if (geomflags & YNegative)
    y = display_height - im->rgb_height + y;
  /* Clip against bounds to stay on the screen */
  if (x<0) x=0;
  if (x > display_width - im->rgb_width) x = display_width - im->rgb_width;
  if (y<0) y=0;
  if (y > display_height - im->rgb_height) y = display_height - im->rgb_height;

  /* Create the main window */
  win = XCreateSimpleWindow(display, DefaultRootWindow(display),
			    x,y,im->rgb_width,im->rgb_height,border_width,
			    BlackPixel(display,screen_num),
			    WhitePixel(display,screen_num));
  XSelectInput(display,win,StructureNotifyMask);
  Imlib_apply_image(id,im,win);

  basewin = win;

  if (use_wm)
    setwinattr.override_redirect = FALSE;
  else
    setwinattr.override_redirect = TRUE;
  cursor = XCreateFontCursor(display, XC_heart);
  setwinattr.cursor = cursor;
  valuemask = CWOverrideRedirect | CWCursor;
  XChangeWindowAttributes(display, win, valuemask, &setwinattr);

  /* Report size hints and other stuff to the window manager */
  size_hints.min_width  = im->rgb_width;    /* Don't allow any resizing */
  size_hints.min_height = im->rgb_height;
  size_hints.max_width  = im->rgb_width;
  size_hints.max_height = im->rgb_height;
  size_hints.flags = PPosition | PSize | PMinSize | PMaxSize;
  if (XStringListToTextProperty(&(teddy), 1, &windowName) == 0)
    {
      (void) fprintf(stderr,
		     "%s: structure allocation for windowName failed.\n",
		     progname);
      Imlib_kill_image(id, im);
      return -1;
    }
  wm_hints.initial_state = NormalState;
  wm_hints.input = TRUE;
  wm_hints.flags = StateHint | IconPixmapHint | InputHint;
  
  class_hints.res_name = progname;
  class_hints.res_class = "Xteddy";
  
  XSetWMProperties(display, win, &windowName, &iconName,
		   argv, argc, &size_hints, &wm_hints, &class_hints);

  /* Select event types wanted */
  inputmask = ExposureMask | KeyPressMask | ButtonPressMask | 
    ButtonReleaseMask | StructureNotifyMask | ButtonMotionMask | 
      PointerMotionHintMask | EnterWindowMask | LeaveWindowMask;
  if (float_up) inputmask |= VisibilityChangeMask;
  XSelectInput(display, win, inputmask);

  /* Display window */
  XMapWindow(display,win);

  /* Get and process the events */
  while (1)
    {
      XNextEvent(display, &report);
      switch(report.type)
	{
	case Expose:
	  if (report.xexpose.count != 0)
	    break;
	  else
	    {
	      /* No drawing needed - the background pixmap */
	      /* is handled automatically by the X server  */
	    }
	  break;
	case ConfigureNotify:
	  /* Window has been resized */
          Imlib_apply_image(id,im,win);
          XSync(display,False);
	  break;
	case ReparentNotify:
	  /* Window was reparented by the window manager */
	  if (!use_wm)
	    (void) fprintf(stderr,
			   "%s: Window manager wouldn't leave the window alone!\n",
			   progname);
	  basewin = report.xreparent.parent;
	  break;
	case EnterNotify:
	  /* Grab the keyboard while the pointer is in the window */
	  XGrabKeyboard(display, win, FALSE, GrabModeAsync, GrabModeAsync,
			CurrentTime);
	  break;
	case LeaveNotify:
	  /* Release the keyboard when the pointer leaves the window */
	  XUngrabKeyboard(display, CurrentTime);
	  break;
	case ButtonPress:
	  /* Raise xteddy above sibling windows  */
	  XRaiseWindow(display, win);
	  /* Remember where the mouse went down */
	  XQueryPointer(display, basewin, &root, &child, &tmp_x, &tmp_y,
			&offs_x, &offs_y, &tmp_mask);
	  break;
	case ButtonRelease:
	  /* Place xteddy at the new position */
	  XQueryPointer(display, basewin, &root, &child, &new_x, &new_y,
		        &tmp_x, &tmp_y, &tmp_mask);
	  winchanges.x = new_x - offs_x;
	  winchanges.y = new_y - offs_y;
	  XReconfigureWMWindow(display, basewin, screen_num,
			       CWX | CWY, &winchanges);
	  break;
	case MotionNotify:
	  /* Move xteddy around with the mouse */
	  while (XCheckMaskEvent(display, ButtonMotionMask, &report));
	  if (!XQueryPointer(display, report.xmotion.window, &root, &child,
			    &new_x, &new_y, &tmp_x, &tmp_y, &tmp_mask))
	    break;
	  winchanges.x = new_x - offs_x;
	  winchanges.y = new_y - offs_y;
	  XReconfigureWMWindow(display, win, screen_num,
			       CWX | CWY, &winchanges);
	  break;
	case VisibilityNotify:
	  /* Put xteddy on top of overlapping windows */
	  if (float_up)
	    if ((report.xvisibility.state == VisibilityFullyObscured)
		|| (report.xvisibility.state == VisibilityPartiallyObscured))
	      XRaiseWindow(display,win);
	  break;
	case KeyPress:
	  /* Exit on "q" or "Q" */
	  charcount = XLookupString(&report.xkey, buffer, bufsize,
				    &keysym, &compose);
	  if((keysym == XK_Q) || (keysym == XK_q))
	    {
              if (allow_quit)
		{
                  Imlib_kill_image(id, im);
		  XCloseDisplay(display);
		  return 0;
		}
	    }
	  break;
	default:
	  /* Throw away all other events */
	  break;
	} /* end switch */
    } /* end while */
}




























