#ifndef __APPLICATION_HH__
#define __APPLICATION_HH__

#include <waili/Channel.h>
//#include <vector>
#include <fstream>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define y_t double
#define x_t int

//class HistoGram;

char *mytempfile(char * templat)
{
#ifdef __WIN32__
  return tmpnam(NULL); 
#else
  if(!mkstemp(templat))
    abort();
  return templat;
#endif
}



void gnuplot(char *plotdata, 
	     char *title= NULL,
	     char **args  = NULL,
	     char *cmdformat="\"%s\" %s "  )
{
  char templat[] = "/tmp/gnuplotXXXXXXXX";
  char *plotscript = mytempfile(templat);   
  char command[560]="plot     ";
  std::ofstream gp(plotscript);

  if(title) {
    gp << "set title \"" << title << "\"\n";
  }
  if(args) {
    int p=5,q,lp=0;
    while(args[lp]) {
      q=sprintf(command+p,cmdformat,  plotdata, args[lp]);
      p=p+q; lp++; assert ( p < 550);
      if(args[lp]) {  command[p]=','; p++; }
    }
  } else
    sprintf(command+5,cmdformat,  plotdata, " with lines");

  gp << command;
  //gp << "pause 120\n";
  gp.close();
  
  sprintf(command, \
" gnuplot  -persist   '%s' & ( sleep 400 && rm  '%s' '%s' ) & ",
	  plotscript,plotscript, plotdata);
  system(command);
};








//this is a mathematical application
class Application {
  size_t size;
  y_t * fun, *funP;

  void copyfrom(const  Application * A)
  {
    falloc(A->leftx,A->rightx);
    memcpy(funP,A->funP,  size*sizeof(y_t) );
  }
  Application * copy()
  {
    Application *N=  new Application(leftx,rightx);
    memcpy(N->fun+1,fun+1,  size*sizeof(y_t) );
    return N;
  }

  void falloc(x_t leftx_, x_t rightx_) 
  {    
    assert(fun==NULL);
    assert(leftx_ < rightx_);
    rightx=rightx_;
    leftx=leftx_;
    size=rightx+3-leftx;
    assert( size < 15000000);
    fun=(y_t *)calloc(size, sizeof(y_t) ); 
    assert( fun);
    //reserve first for memory checks
    fun[0]=1;  funP=fun+1-leftx; size--;
  };
#define ASSERT_SENSE(V)     assert((V)> -10000000 && (V) < 10000000 );
#define ASSERT_OK(T) assert((T)->fun && ((T)->fun)[0]>0);

  void ffree() 
  {
    assert(fun);
    assert(0==fun[0]);
    fun[0]=-11311;
    free(fun);
    fun=NULL; leftx=rightx=0; size=0;
  }
public:
  x_t leftx;
  x_t rightx;

public:
  Application()
  { abort(); fun=NULL; }
  Application(x_t leftx_, x_t rightx_) 
  {  fun=NULL; falloc( leftx_,  rightx_); };
  ~Application() 
  {
    ASSERT_OK(this);
    fun[0]--; this->ffree();
  }

  void operator=(Application &T)
  {
    abort();
    assert(fun=NULL);
    memcpy(this,&T,sizeof(Application));
    T.fun=NULL;
    //return this;
  }

  y_t  get(x_t l) const
  {
    ASSERT_OK(this);
    if(l<leftx )
      return 0;
    else if ( l > rightx)
      return 0;
    return  funP[l];
  }

  y_t &  operator[](x_t l) 
  {
    assert( l <= rightx && l >= leftx);
    ASSERT_OK(this);
    ASSERT_SENSE(funP[l]); 
    return funP[l] ;
  }

  void write(std::ostream *o) 
  {     
    x_t r; char s[151];
    ASSERT_OK(this);
    for ( r = leftx; r <= rightx; r++) {
      double v=this->get(r);
      assert(v> -100000000 && v < 100000000 );
      snprintf(s,150,"%d %e\n",r,v  );
      *o << s;
    }
  }

  Application * integral() const //y_t cum_fun[], y_t fun[], int rightx_symb)
  {
    y_t f=0;
    ASSERT_OK(this);
    Application *H= new Application(leftx,rightx);
    
    for(x_t lp=leftx; lp <=rightx; lp++)
      {
	f+= this->get(lp);
	(*H)[lp]=f;
      }      
    return H;
  };

#define MIN(a,b) ((a)<(b)?(a):(b))

#define MAX(a,b) ((a)>(b)?(a):(b))


  Application  * operator+(const Application *that) const
  {
    ASSERT_OK(this);
    ASSERT_OK(that);
    x_t newleftx =MIN(leftx,  that->leftx);
    x_t newrightx=MAX(rightx, that->rightx);

    Application  * R = new  Application(newleftx,newrightx);
    for (x_t j=newleftx; j <= newrightx ;  j++) { 
      (*R)[j] =  this->get(j) + that->get(j);
    }
      
    return R;
  };

  Application  * operator+(const y_t f) const
  {
    ASSERT_OK(this);
    Application  * R = new  Application(leftx,rightx);
    for (x_t j=leftx; j <= rightx ;  j++) {
      (*R)[j] =  this->get(j)+f;
    }      
    return R;
  };
  
  void operator+=(const Application *that)
  {
    ASSERT_OK(this);
    ASSERT_OK(that);
    if( leftx >= that->leftx && rightx <= that->rightx  ) {
	x_t newleftx =MAX(leftx,  that->leftx);
	x_t newrightx=MIN(rightx, that->rightx);

	for (x_t j=newleftx; j <= newrightx ;  j++)
	  (*this)[j] = this->get(j) + that->get(j);
    }    else {
      Application *N = (*this) + that;
      this->ffree();
      *this=*N;
    } 
  };

  void operator+=(const y_t f)
  {
    ASSERT_OK(this);
    for (x_t j=leftx; j <= rightx ;  j++)
      (*this)[j] = this->get(j) + f;
  };


  Application *  operator*(const double factor)
  {
    //if (NULL==fun || factor == 1) return this;
    Application * R = new  Application(leftx,rightx);

    for (x_t j=leftx; j <= rightx ;  j++)
      (*R)[j] =  this->get(j) * factor ;
      
    return R;
  };
  
  void plot(char* title,char *style)
  {
    char templat[] = "/tmp/histodataXXXXXXXX";
    char *plotdata = mytempfile(templat);   
    {
      std::ofstream plotfile(plotdata, std::ios::out );
      this->write(&plotfile);
      plotfile.close();
    }
    char *A[]={style, NULL};
    gnuplot(plotdata,title,A);
  };


private:
  void reset() //y_t fun[], int rightx) 
  {  
    for (x_t r = leftx; r <= rightx; r++)
      (*this)[r]=0;
  }
};


// class HistoGram : public Application {
// public:
//   y_t total;
Application * HistoGram(Channel *C)
{ 
  u_int nr=C->GetRows(), nc=C->GetCols();
  x_t max=  (*C)(0, 0), min=max;
  for (u_int r = 0; r < nr; r++)
      for (u_int c = 0; c < nc; c++) {
	PixType p=(*C)(c, r);
	if(p<min) min=p;
	else if(p> max) max=p;
      }
  Application * A = new Application(min,max);
  for (u_int r = 0; r < nr; r++)
    for (u_int c = 0; c < nc; c++) {
      x_t d= (*C)(c, r);
      (*A)[d] = 1 +	(*A)[d] ;
    }
  //total=nr*nc;
  return A;
};
//};

Application * histogram_equalizer(const Application  *T,const Application  *O) 
{
    Application *E  = new Application(T->leftx,T->rightx);

    Application *NT = *T + 0.0001; 
    Application *NO = *O + 0.0001;
    
    Application *IT = NT->integral(); 
    Application *IO = NO->integral();

    y_t MT = (*IT)[(*IT).rightx];
    y_t MO = (*IO)[(*IO).rightx];

    x_t x=T->leftx;
    x_t z=O->leftx;
    
    (*E)[x]=z;
    x++;
    while(x<= (*IT).rightx) {
      while ( z<= (*IO).rightx &&  
	      ((MO *(*IT)[x])) > (MT * (*IO)[z]))
	z++;
      (*E)[x] = z;
      x++;
    }
    
    delete IT; delete IO;     delete NT; delete NO;
    return E;
}










#endif //__APPLICATION_HH__








#ifdef UNUSED

//   void simplify()
//   { 
//     y_t a=0; 
//     x_t r;
//     while ( a==0) {
//       for ( r = 1; r <= rightx; r++)
// 	a |= fun[r] & 1;
//       if( a==0)
// 	for ( r = 1; r <= rightx; r++)
// 	  fun[r] /= 2;
//     }
//     fun2cum_fun();
//   }
  
//   void fun_downsize() //y_t fun[], int rightx) 
//     {
//       for (int r = 0; r <=rightx-leftx; r++)
// 	fun[r]=(fun[r]+1) / 2  ;
//     }

  /* computes the cum_fun given the probabilities */
//   void prob2cum_fun(double prob[])
//   {
//     int lp;
//     y_t f=0;
    
//     cum_fun[rightx]=0;
//     for(lp=rightx-1; lp>=0; lp--)
//       {
// 	f+= 1+(y_t)floor(prob[lp] * (AC_RIGHTX_FUN-rightx) );
// 	cum_fun[lp]=f;
//       }
//   }



//   void dynam_fun(x_t symb)
//     {
//       assert(symb <= rightx && symb >0);
//       count++;
//       fun[symb] +=2 ;
      
//       //if ( (count & 127) == 64) {
//       if( cum_fun[0]>= AC_RIGHTX_FUN-4 ) 
// 	fun_downsize(); //fun, (RIGHTX_SYMB/quantization));
      
//       fun2cum_fun(); 
    
//     }  


u64 *NTChannel::FullHistogram(PixType &leftx, PixType &rightx, u64 &numpixels) const
{
    GetLeftxRightx(leftx, rightx);
    histogram histogram = new histogram(leftx, rightx);
    numpixels = Cols*Rows;
    return(histogram);
}



u64 *NTChannel::Histogram(PixType leftx, PixType rightx) const
{
    Application *histogram = new Application(leftx,rightx);
    ::Clear(histogram, rightx-leftx+1);
    u64 *hz = histogram-leftx;
    for (u_int r = 0; r < Rows; r++)
       for (u_int c = 0; c < Cols; c++) {
	   PixType val = (*this)(c, r);
	   if (val < leftx)
	       val = leftx;
	   else if (val > rightx)
	       val = rightx;
	   histogram(val)++;
       }
    return(histogram);
}


u64 *LChannel::FullHistogram(PixType &leftx, PixType &rightx, u64 &numpixels) const
{
    numpixels = 0;
    PixType leftxima[NumSubBands], rightxima[NumSubBands];
    u64 *histograms[NumSubBands];
    for (u_int i = 0; i < NumSubBands; i++) {
	u64 *hist = NULL;
	if (SubBands[i]) {
	    u64 n;
	    if ((hist = SubBands[i]->FullHistogram(leftxima[i], rightxima[i], n))) {
		if (!numpixels) {
		    leftx = leftxima[i];
		    rightx = rightxima[i];
		} else {
		    leftx = Leftx(leftx, leftxima[i]);
		    rightx = Rightx(rightx, rightxima[i]);
		}
		numpixels += n;
	    }
	}
	histograms[i] = hist;
    }
    if (!numpixels)
	return(NULL);

    u64 *histogram = new u64[rightx-leftx+1];
    ::Clear(histogram, rightx-leftx+1);
    u64 *hz = histogram-leftx;
    for (u_int i = 0; i < NumSubBands; i++)
	if (histograms[i]) {
	    u64 *hz2 = histograms[i]-leftxima[i];
	    for (PixType j = Rightx(leftx, leftxima[i]); j <= Leftx(rightx, rightxima[i]);
		 j++)
		hz[j] += hz2[j];
	    delete [] histograms[i];
	}
    return(histogram);
}
#endif
