/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkGaussianCubeReader.h,v $
  Language:  C++
  Date:      $Date: 2003/08/30 11:09:54 $
  Version:   $Revision: 1.4 $


Copyright (c) 1993-2001 Ken Martin, Will Schroeder, Bill Lorensen 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Ken Martin, Will Schroeder, or Bill Lorensen nor the names
   of any contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
// .NAME vtkGaussianCubeReader - read ASCII Gaussian Cube Data files
// .SECTION Description
// vtkGaussianCubeReader is a source object that reads ASCII files following
// the description in http://www.gaussian.com/00000430.htm
// The FileName must be specified.
//
// .SECTION Thanks
// Dr. Jean M. Favre who developed and contributed this class.

#ifndef __vtkGaussianCubeReader_h
#define __vtkGaussianCubeReader_h

#include "vtkMoleculeReaderBase.h"

class vtkImageData;
class vtkTransform;

class VTK_IO_EXPORT vtkGaussianCubeReader : public vtkMoleculeReaderBase 
{
public:
  static vtkGaussianCubeReader *New();
  vtkTypeRevisionMacro(vtkGaussianCubeReader,vtkMoleculeReaderBase);
  void PrintSelf(ostream& os, vtkIndent indent);

  vtkGetObjectMacro(Transform,vtkTransform);
  vtkSetStringMacro(FileName);
  vtkGetStringMacro(FileName);
  vtkImageData *GetGridOutput();

protected:
  vtkGaussianCubeReader();
  ~vtkGaussianCubeReader();

  char *FileName;
  vtkTransform *Transform;

  void Execute();
  
  void ReadSpecificMolecule(FILE* fp);

private:
  vtkGaussianCubeReader(const vtkGaussianCubeReader&);  // Not implemented.
  void operator=(const vtkGaussianCubeReader&);  // Not implemented.
};

#endif
