// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1997
//  wer auch immer ...
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        dbcontr_utils.h
// 
// Purpose:     
// 
// Created:     21 Feb 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: dbcontr_utils.h,v 1.1 1997/03/03 09:52:53 jfasch Exp $
// 
// $Log: dbcontr_utils.h,v $
// Revision 1.1  1997/03/03 09:52:53  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_hyperg_dbcontr_utils_h
#define hg_hyperg_dbcontr_utils_h

class INETAddress ;
class RString ;
class TCPMatch ;

class DbContrUtils {
public:
   static bool isMainScope (const RString&) ; 

   class TCP {
   public:
      // a returns true and fills in the parameter(s) accordingly if s
      // is a valid TCP endpoint.
      static bool isTCP (const RString&, INETAddress&) ;
      static bool isTCP (const RString&, RString& hostname, int& port) ;
      
      // parses strings of the form 'a.a.a.a m.m.m.m op port' into a
      // TCPMatch. (a-ddress, m-atch, op-erator, port)
      static bool isTCPMatch (const RString&, TCPMatch&) ;
      
      // if it is a SOCKS4 line, return true and set the parameters
      // accordingly. calls string2TCPMatch() internally.
      static bool isSOCKS4 (const RString&, INETAddress& socks_server, TCPMatch&) ;

      // true if it is a DIRECT line (optionally filling in the TCPMatch)
      static bool isDIRECT (const RString&) ;
      static bool isDIRECT (const RString&, TCPMatch&) ;

      // ... DENY line ...
      static bool isDENY (const RString&, TCPMatch&) ;
   } ;

public:
   // link time assertion (is one necessary?)
   static const char* version2 ;
} ;
static const char* DbContrUtils_version = DbContrUtils::version2 ;

#endif
