/*
 * The Sleuth Kit
 *
 * $Date: 2005/01/17 22:40:17 $
 *
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2003-2005 Brian Carrier.  All rights reserved
 *
 * This file is part of mmtools
 *
 * mmtools is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 */

#ifndef _MAC_H
#define _MAC_H

typedef struct {
    uint8_t magic[2];
    uint8_t reserved[2];
    uint8_t pmap_size[4];
    uint8_t start_sec[4];
    uint8_t size_sec[4];
    uint8_t name[32];
    uint8_t type[32];
    uint8_t data_start_sec[4];
    uint8_t data_size_sec[4];
    uint8_t status[4];
    uint8_t boot_start_sec[4];
    uint8_t boot_size_sec[4];
    uint8_t boot_load_addr[4];
    uint8_t reserved2[4];
    uint8_t boot_entry[4];
    uint8_t reserved3[4];
    uint8_t boot_checksum[4];
    uint8_t proc_type[16];
    uint8_t reserved4[376];
} mac_part;

#define MAC_MAGIC	0x504d
#define MAC_PART_OFFSET	1

#define MAC_STAT_VALID		0x00
#define MAC_STAT_ALLOC		0x01
#define MAC_STAT_INUSE		0x02
#define MAC_STAT_BOOT		0x04
#define MAC_STAT_READ		0x08

#endif
