/*
 *  Copyright (C) 1999
 *  Robert Lissner
 *  Jay MacDonald
 *  Sam Phillips
 *  Keith Wesolowski. 
 */


#include "includes.h"
#include "globals.h"

static void cancel_clicked (GtkObject *object, gpointer *entry);
static void done_clicked (GtkObject *object, gpointer *entry);
static void just_clicked (GtkObject *object, GtkJustification entry);
static void new_std_field (void);
static void ok_clicked (GtkObject *object, gpointer *entry);
static GtkWidget* sub_menus ();
static void sm_formatting_changed (GtkObject *object, gpointer entry);
static void type_clicked (GtkObject *object, gpointer entry);
void update_field_db (void);
static void swap_columns (gint to, gint from);

static char *num_formats []= {
  "1,234.56", /*formatting style for formatting == 0 */
  "1.234,56",
  "1234.56",
  "1234,56",
  "$1,234.56",
  "1,234.56%",
  "1.234,56%",
  NULL
};

static char *time_formats [] = {
  "6:00 PM",
  "18:00",
  "18.00",
  NULL
};

static char *date_formats [] = {
  "12/31/99",
  "12/31/1999",
  "12.31.99",
  "12.31.1999",
  "Dec 31 1999",
  "1999-12-31",
  "31 Dec 1999",
  "31/12/99",
  "31/12/1999",
  NULL
  }; 

  /* this is all done in a dialog box, so globals are OK */
field_info field_db_start;
field_info field_db_curr; 
GtkWidget *done_button;
gboolean displaying; /* so we can ignore signals during display */



/* ________________________________
   |                               |
   |       activate_disp           |
   |_______________________________| 

   static void activate_disp () {;} */

/* ________________________________
   |                                |
   |        build_field_db          |
   |________________________________|
   This function builds a level1 dialog box to edit field parameters 
   such as name, justification, type, etc.
   front->sel_range.col0 is the field being edited
   field_db_curr is the information we want to display
   field_db_start contains the settings at the time the dialog
   box was opened.  Zero is possible */
void build_field_db () {
 GtkWidget *top_box;
 GtkWidget *hbox_name;
 GtkWidget *hbox_type;
 GtkWidget *hbox_just;
 GtkWidget *button_box;
 GtkWidget *ok_button;
 GtkWidget *cancel_button;
 GtkWidget *name_label;

  make_basic_dialog1 ();
  displaying = FALSE;
  field_db_start = field_db_curr; 
  gtk_window_set_title (GTK_WINDOW(dialog1_win), 
			_("Edit Column Information"));
  top_box = GTK_DIALOG(dialog1_win) -> vbox;
  gtk_box_set_spacing (GTK_BOX (top_box), 10);
  button_box = GTK_DIALOG (dialog1_win) -> action_area;  
  
  hbox_name = gtk_hbox_new (FALSE, 5);
  name_label = gtk_label_new (_("Column Name"));
  gtk_widget_show (name_label);
  gtk_box_pack_start (GTK_BOX (hbox_name), name_label, FALSE, FALSE, 0);
  
  front->entry4 = gtk_entry_new_with_max_length (MAX_FIELD_NAME);
  gtk_box_pack_start (GTK_BOX (hbox_name), front->entry4, TRUE, TRUE, 0);
  gtk_widget_show (front->entry4);
  gtk_widget_show (hbox_name);
  gtk_box_pack_start (GTK_BOX (top_box), hbox_name, FALSE, FALSE, 0);

  /* Got the top box formatted, now go for type radio buttons */
  hbox_type = gtk_hbox_new (FALSE, 3);
  front->text_button = gtk_radio_button_new_with_label (NULL, _("Text"));
  gtk_signal_connect (GTK_OBJECT (front->text_button), "clicked", 
		      GTK_SIGNAL_FUNC (type_clicked), 
		      (gpointer) FIELD_TYPE_TEXT);
  gtk_box_pack_start (GTK_BOX (hbox_type), front->text_button, TRUE, TRUE, 0);
  gtk_widget_show (front->text_button);
  
  front->numeric_button = gtk_radio_button_new_with_label
    ( gtk_radio_button_group (GTK_RADIO_BUTTON (front->text_button)),
						    _("Numeric"));
  gtk_signal_connect (GTK_OBJECT (front->numeric_button), "clicked",
		      GTK_SIGNAL_FUNC (type_clicked), 
		      (gpointer) FIELD_TYPE_NUMERIC);
  gtk_box_pack_start (GTK_BOX (hbox_type), front->numeric_button, 
		      TRUE, TRUE, 0);
  gtk_widget_show (front->numeric_button);
  
  front->date_button = gtk_radio_button_new_with_label 
    ( gtk_radio_button_group (GTK_RADIO_BUTTON (front->text_button)),
						 _("Date"));
  gtk_signal_connect (GTK_OBJECT (front->date_button), "clicked",
		      GTK_SIGNAL_FUNC (type_clicked), 
		      (gpointer) FIELD_TYPE_DATE);
  gtk_box_pack_start (GTK_BOX (hbox_type), front->date_button, TRUE, TRUE, 0);
  gtk_widget_show (front->date_button);
  
  front->time_button = gtk_radio_button_new_with_label
    (gtk_radio_button_group (GTK_RADIO_BUTTON (front->text_button)),
						 _("Time"));
  gtk_signal_connect (GTK_OBJECT (front->time_button), "clicked",
		      GTK_SIGNAL_FUNC (type_clicked), 
		      (gpointer) FIELD_TYPE_TIME);
  gtk_box_pack_start (GTK_BOX (hbox_type), front->time_button, TRUE, TRUE, 0);
  gtk_widget_show (front->time_button);
  gtk_widget_show (hbox_type);
  gtk_box_pack_start (GTK_BOX (top_box), hbox_type, FALSE, FALSE, 0);
  
  /* Now the justification radio buttons */
  hbox_just = gtk_hbox_new (FALSE, 3);
  front->left_button = gtk_radio_button_new_with_label (NULL, _("Left"));
  gtk_signal_connect (GTK_OBJECT (front->left_button), "clicked", 
		      GTK_SIGNAL_FUNC (just_clicked),
		      (gpointer) GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox_just), front->left_button, TRUE, TRUE, 0);
  gtk_widget_show (front->left_button);
  
  front->center_button = gtk_radio_button_new_with_label
    ( gtk_radio_button_group (GTK_RADIO_BUTTON (front->left_button)),
						   _("Center"));
  gtk_signal_connect (GTK_OBJECT (front->center_button), "clicked",
		      GTK_SIGNAL_FUNC (just_clicked),
		      (gpointer) GTK_JUSTIFY_CENTER);
  gtk_box_pack_start (GTK_BOX (hbox_just), front->center_button, 
		      TRUE, TRUE, 0);
  gtk_widget_show (front->center_button);
  
  front->right_button = gtk_radio_button_new_with_label 
    ( gtk_radio_button_group (GTK_RADIO_BUTTON (front->left_button)),
      _("Right"));
  gtk_signal_connect (GTK_OBJECT (front->right_button), "clicked",
		      GTK_SIGNAL_FUNC (just_clicked),
		      (gpointer) GTK_JUSTIFY_RIGHT);
  gtk_box_pack_start (GTK_BOX (hbox_just), front->right_button, TRUE, TRUE, 0);
  gtk_widget_show (front->right_button);
  gtk_widget_show (hbox_just);
  gtk_box_pack_start (GTK_BOX (top_box), hbox_just, FALSE, FALSE, 0);
  
  /* go get the display types buttons for numeric, date and time */
  gtk_box_pack_start (GTK_BOX (top_box), sub_menus (), FALSE, FALSE, 0);
    
  /* Now do OK, Done and Cancel buttons */
  ok_button = gtk_button_new_with_label (_("OK"));
  gtk_widget_show (ok_button);
  gtk_box_pack_start (GTK_BOX (button_box),
		      ok_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(ok_button), "clicked", 
		      GTK_SIGNAL_FUNC (ok_clicked), NULL);
  
  if (dialog_mode == 'N') {
    done_button = gtk_button_new_with_label (_("Done"));
    /* show is done later */
    gtk_box_pack_start (GTK_BOX (button_box),
			done_button, TRUE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT(done_button),"clicked", \
			GTK_SIGNAL_FUNC (done_clicked), NULL);
  }
  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_show (cancel_button);
  gtk_box_pack_start (GTK_BOX (button_box),
		      cancel_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(cancel_button),"clicked", \
		      GTK_SIGNAL_FUNC (cancel_clicked), NULL );
  gtk_signal_connect (GTK_OBJECT  (dialog1_win),
		      "delete_event",
		      (GtkSignalFunc) cancel_clicked, NULL);
  gtk_widget_show (dialog1_win);  
}

/* ________________________________
   |                                |
   |        cancel_clicked          |
   |________________________________|*/
static void cancel_clicked (GtkObject *object, gpointer *entry) {
  destroy_dialog ();
  if (dialog_mode == 'N') 
    get_rid_of_front ();
  maybe_create_initial_db ();
}


/* _________________________________
   |                                |
   |        done_clicked            |
   |________________________________|
*/
static void done_clicked (GtkObject *object, gpointer *entry) {
  if (front->last_field < 0)
    return;
  destroy_dialog ();
  build_basic_list_mode ();
  add1row ();
   
  dim_all_menus ();
  gtk_widget_show_all (front->list_win);
  connect_signals ();
}

/* |--------------------------------|
   |   column_add                   |
   |--------------------------------|
*/
void column_add (GtkWidget *w, gpointer *data) { 
  if (check_if_changed ())
    return;
  dialog_mode = 'A';
  build_field_db ();
  new_std_field ();
  update_field_db ();
}


/* |--------------------------------|
   |   column_edit                   |
   |--------------------------------|
*/
void column_edit (GtkWidget *w, gpointer *data){
  gint this_field; /* notation is just too complicated */
   if (front->sel_range.col0 > front->last_field)
    return; /* because of sheet bug */
   if (check_if_changed ())
    return;
  if (front->sel_type != 'C')
    return;
  dialog_mode = 'E';
  this_field = front->col_to_field [front->sel_range.col0];
  field_db_curr = front->fields [this_field];
  build_field_db ();
  update_field_db ();

}


/* |--------------------------------|
   |   column_delete                |
   |--------------------------------|
*/
void column_delete (GtkWidget *w, gpointer *data){
  gint colx;
  gint fieldx;
  gint field_leaving;
  gint groupx;
  gint linex;
  gint reportto, reportfrom;
  gint starting_reports;
  gint colto, colfrom;
  gint starting_cols;
  report_info temp_report;

  /* someday we should have code to ask if the user really wants this */
  if (front->sel_range.col0 > front->last_field)
    return; /* because of sheet bug */
  if (check_if_changed ())
    return;
  front_is_changed ();
  colx = front->sel_range.col0;
  field_leaving = front->col_to_field [colx];
  gtk_sheet_delete_columns (GTK_SHEET (front->sheet), colx, 1);

  for (fieldx = field_leaving; 
	fieldx < front->last_field; fieldx++) 
     front->fields [fieldx] = front->fields [fieldx + 1];

  front->last_field--;  
  for (fieldx = 0; fieldx <= front->last_field; fieldx++) 
    if (front->fields [fieldx].sheet_column > colx)
      front->fields [fieldx].sheet_column--;
 
    reset_col_to_field ();  

   /* then go through sorts */
  for (groupx = 0; groupx < front->sort_ct; groupx++) {
    for (linex = 0; linex < front->sorts [groupx].line_ct; linex++) {
      if (front->sorts [groupx].line [linex].field == field_leaving)
	front->sorts [groupx].line [linex].field = -1;
      else if (front->sorts [groupx].line [linex].field > field_leaving)
	front->sorts [groupx].line [linex].field--;
    }
  }
	
  /* now go through filters */
  for (groupx = 0; groupx < front->filter_ct; groupx++) {
    for (linex = 0; linex < front->filters [groupx].line_ct; linex++) {
      if (front->filters [groupx].line [linex].field == field_leaving)
	front->filters [groupx].line [linex].field = -1;
      else if (front->filters [groupx].line [linex].field > field_leaving)
	front->filters [groupx].line [linex].field--;
    }
  }

  /* now go through reports */ 
  reportto = 0;
  starting_reports = front->report_ct;
  for (reportfrom = 0; reportfrom < starting_reports; reportfrom++) {
    temp_report = front->reports [reportfrom];
    colto = 0;
    starting_cols = temp_report.last_column;
    for (colfrom = 0; colfrom <= starting_cols; colfrom++) {
      if (temp_report.column [colfrom].field != field_leaving) { 
	if (temp_report.column [colfrom].field > field_leaving)
	  temp_report.column [colfrom].field--;
	temp_report.column [colto++] = temp_report.column [colfrom];
      }
       else 
	temp_report.last_column--;
    }
    if (temp_report.last_column >= 0)  /* only if valid fields in report */
      front->reports [reportto++] = temp_report;
    else
      front->report_ct--;
  } 
      
  /* have to select something other than the deleted column */
} /* end of delete field */


/* |--------------------------------|
   |   column_left                  |
   |--------------------------------|
*/
void column_left (GtkWidget *w, gpointer *data){
  if (front->sel_range.col0 > front->last_field)
    return; /* because of sheet bug */  
  if (check_if_changed ())
    return;
  swap_columns (front->sel_range.col0 - 1, front->sel_range.col0);
}


/* |--------------------------------|
   |   column_right                 |
   |--------------------------------|
*/
void column_right (GtkWidget *w, gpointer *data){
  if (front->sel_range.col0 > front->last_field)
    return; /* because of sheet bug */
  if (check_if_changed ())
    return;
  swap_columns (front->sel_range.col0 + 1, front->sel_range.col0);
}

/* _________________________________
   |                                |
   |        just_clicked            |
   |________________________________|
*/
static void just_clicked (GtkObject *object, GtkJustification entry) {
  field_db_curr.justification = (GtkJustification) entry;
}


/* |--------------------------------|
   |   new_file                     |
   |--------------------------------|
*/ 
void new_file (GtkWidget *w, gpointer *data) {
  gint i;
  if (check_if_changed())
    return;
  destroy_dialog ();
  /* Whatever file was front isn't anymore */

  front = (whole_file*) calloc (1, sizeof (whole_file));
  file_ct++;
  front->last_field = -1;

 /* Add this window to table of open windows so I can list */
  for (i=0; i < MAX_FILES; i++)
    if (!back [i]) {
      back [i] = front;
      break;
    }

  dialog_mode = 'N';
  front->file_path =  (char *) g_strdup
    (_("~/Untitled_New_List.qlf"));
  front->file_name = (char *) g_strdup (_("Untitled_New_List.qlf"));
  build_field_db ();
  new_std_field ();
  update_field_db ();
} /* End of new file */


/* ________________________________
  |                                |
  |        new_std_field           |
  |________________________________|
 setup a new text field as a standard text field.  User might
  change it as they edit it */
static void new_std_field () {
  gtk_entry_set_text (GTK_ENTRY (front->entry4), "");
  g_snprintf(field_db_curr.name, MAX_FIELD_NAME, "Column %u",
	   front->last_field + 2); /* if last_field =2, then new is Field 4 */
  field_db_curr.sheet_column = front->last_field + 1;
  field_db_curr.type = FIELD_TYPE_TEXT;
  field_db_curr.formatting = 0;
  field_db_curr.decimal_places = 0;
  field_db_curr.justification = GTK_JUSTIFY_LEFT;
  field_db_curr.width = 10;
}

/* _________________________________
   |                                |
   |         ok_clicked             |
   |________________________________| 
  Remember that sheet isn't open yet if this is new file */
static void ok_clicked (GtkObject *object, gpointer *entry) {
  gint fieldx;
  gint sheetx;
  gint rowx;
  gchar *text;
  GtkSheetRange range;
  double temp_double;
  char linebuf [48];

  text = gtk_entry_get_text (GTK_ENTRY (front->entry4));
  if (check_entry (text))
    return;
  strcpy (field_db_curr.name, text);

  if (field_db_curr.type == FIELD_TYPE_NUMERIC) {
    text = gtk_entry_get_text (GTK_ENTRY (front->entry1));
    if (text [0] < '0' || text [0] > '9' || text [1]) {
      level2_error ("Number of decimal places must be from 0 to 9",
		    "Go back");
      return;
    }
    field_db_curr.decimal_places = atoi (text);
  }

  /* notation is just too complicated */
  if (dialog_mode == 'A') { /* A is add one column */
    destroy_dialog ();
    field_db_curr.sheet_column = sheetx = front->sel_range.col0;

    for (fieldx = 0; fieldx <= front->last_field; fieldx++)
      if (front->fields [fieldx].sheet_column >= sheetx)
	front->fields [fieldx].sheet_column++;
    
    fieldx = ++front->last_field;
    big_draw_start ();
    front->fields [fieldx] =  field_db_curr;
    
    /* add column, add to sheet now */
    gtk_sheet_insert_columns (GTK_SHEET (front->sheet), sheetx, 1);  
    gtk_sheet_set_column_width (GTK_SHEET (front->sheet), sheetx, 
				field_db_curr.width*8);  
    gtk_sheet_column_button_add_label( GTK_SHEET (front->sheet), sheetx,
				       field_db_curr.name);  
    gtk_sheet_column_set_justification(GTK_SHEET (front->sheet), sheetx,
				       field_db_curr.justification);

    reset_col_to_field ();
    big_draw_end ();
    front_is_changed ();
    return;
  } /* end of add field */

 
  /* now do edit field */
  else if (dialog_mode == 'E') {
    destroy_dialog ();
    sheetx = front->sel_range.col0;
    fieldx = front->col_to_field [sheetx];
    front->fields [fieldx] =  field_db_curr;
    gtk_sheet_column_button_add_label( GTK_SHEET (front->sheet), sheetx,
				       field_db_curr.name);
    big_draw_start ();
    if (field_db_curr.justification != field_db_start.justification) {
      gtk_sheet_column_set_justification (GTK_SHEET (front->sheet), 
					  sheetx,
					  field_db_curr.justification);
      range.row0 = 0;
      range.rowi = front->last_row;
      range.col0 = range.coli = sheetx;
      gtk_sheet_range_set_justification  (GTK_SHEET (front->sheet),
					  range, 
					  field_db_curr.justification);
    }

    /* check if numeric format changed */
    if (field_db_curr.type == FIELD_TYPE_TEXT ||
	!front->last_row) {
      big_draw_end ();
      front_is_changed ();
      return;
    }
    if (field_db_curr.type != FIELD_TYPE_TEXT && 
	(field_db_start.type != field_db_curr.type  ||
	  field_db_start.formatting != field_db_curr.formatting ||
	  field_db_start.decimal_places != 
	 field_db_curr.decimal_places)) {
      
      /* make sure the old formatting code is valid */
      if (field_db_start.type == FIELD_TYPE_TEXT)
	field_db_start.formatting = field_db_curr.formatting; /* default */
      for (rowx = 0; rowx < front->last_row; rowx++) {
	text = gtk_sheet_cell_get_text (GTK_SHEET (front->sheet), 
					rowx, sheetx);
	if (text) {
	  temp_double = qls2d (text, field_db_curr.type, 
			       field_db_start.formatting);
	  d2qls (linebuf, temp_double, field_db_curr.type,
		 field_db_curr.formatting,
		 field_db_curr.decimal_places);
	  gtk_sheet_set_cell_text (GTK_SHEET (front->sheet), 
				   rowx, sheetx, linebuf);
	}
      }
    }
    big_draw_end ();
    front_is_changed ();
    return;
  }
  
  /* this is for a new file */
  fieldx = sheetx = ++front->last_field;
  front->fields [fieldx] =  field_db_curr;
  reset_col_to_field ();
  new_std_field ();
  field_db_start = field_db_curr;
  update_field_db ();
}


/* _________________________________
   |                                |
   |       sm_formatting_changed    |
   |________________________________|
*/
static void sm_formatting_changed (GtkObject *object, gpointer entry) {
 field_db_curr.formatting = (gint) entry;
}


/* ________________________________
  |                                |
  |          sub_menus             |
  |________________________________|
  Assemble the style menus for numeric, date and time */
GtkWidget* sub_menus () {
  GtkWidget *menu;
  GtkWidget *menu_item;
  GtkWidget *sub_menu_box;
  gint subx;

  /* add the individual display types to the menu.  We'll show them
     later.  They only show one at a time. */
  sub_menu_box = gtk_hbox_new (FALSE, 5);
  gtk_widget_show (sub_menu_box);
   
  /* first the numeric menu */
  menu = gtk_menu_new ();
  subx = 0;
  while (num_formats [subx] != NULL) {
    menu_item = gtk_menu_item_new_with_label (num_formats [subx]);
    gtk_signal_connect (GTK_OBJECT (menu_item), "select",
			    GTK_SIGNAL_FUNC (sm_formatting_changed), 
			    (gpointer) subx);
    gtk_widget_show (menu_item);
    gtk_menu_append (GTK_MENU(menu), menu_item);
    subx++;
  }
    
  front->sm_numeric_menu = gtk_option_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (front->sm_numeric_menu), menu);
  gtk_box_pack_start (GTK_BOX (sub_menu_box), front->sm_numeric_menu, 
		      FALSE, FALSE, 0);
  front->entry1 = gtk_entry_new_with_max_length (1);
  gtk_widget_set_usize (front->entry1, 40, -1);
  gtk_box_pack_end (GTK_BOX (sub_menu_box), front->entry1, FALSE, FALSE, 0);
  front->dec_places_label = gtk_label_new (_("Decimal places"));
  gtk_box_pack_end (GTK_BOX (sub_menu_box), front->dec_places_label, 
		      FALSE, FALSE, 0);

  /* now the date format menu */
  menu = gtk_menu_new ();
  subx = 0;
  while (date_formats [subx] != NULL) {
    menu_item = gtk_menu_item_new_with_label (date_formats [subx]);
    gtk_signal_connect (GTK_OBJECT (menu_item), "select",
			    GTK_SIGNAL_FUNC (sm_formatting_changed), 
			    (gpointer) subx);
    gtk_widget_show (menu_item);
    gtk_menu_append (GTK_MENU(menu), menu_item);  
    subx++;
  }
    
  front->sm_date_menu = gtk_option_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (front->sm_date_menu), menu);
  gtk_box_pack_start (GTK_BOX (sub_menu_box), front->sm_date_menu, 
		      FALSE, FALSE, 0);
  
  /* now the time format menu */
  menu = gtk_menu_new ();
  subx = 0;
  while (time_formats [subx] != NULL) {
    menu_item = gtk_menu_item_new_with_label (time_formats [subx]);
    gtk_signal_connect (GTK_OBJECT (menu_item), "select",
			    GTK_SIGNAL_FUNC (sm_formatting_changed), 
			    (gpointer) subx);
    gtk_widget_show (menu_item);
    gtk_menu_append (GTK_MENU(menu), menu_item);  
    subx++;
  }
    
  front->sm_time_menu = gtk_option_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (front->sm_time_menu), menu);
  gtk_box_pack_start (GTK_BOX (sub_menu_box), front->sm_time_menu, 
		      FALSE, FALSE, 0);
  return (sub_menu_box);
} /* end of sub_menus */


/* _________________________________
   |                                |
   |       swap_columns             |
   |________________________________|
*/
static void swap_columns (gint tocol, gint from) {
  char* textfromp;
  char* texttop;
  char textfrom [1024];
  gint fieldfrom;
  gint fieldto;
  gint from_justification;
  gint to_justification;
  gint rowx;
  gint to_sheet_col;

  big_draw_start (); 
  fieldfrom = front->col_to_field [from];
  fieldto = front->col_to_field [tocol];
  from_justification = front->fields [fieldfrom].justification;
  to_justification = front->fields [fieldto].justification;
  to_sheet_col = front->fields [fieldto].sheet_column; 
  front->fields [fieldto].sheet_column  = 
    front->fields [fieldfrom].sheet_column;
  front->fields [fieldfrom].sheet_column = to_sheet_col;
  
    gtk_sheet_set_column_width (GTK_SHEET (front->sheet), from,
			      front->fields [fieldto].width*8);
  gtk_sheet_set_column_width (GTK_SHEET (front->sheet), tocol,
			      front->fields [fieldfrom].width*8);
  gtk_sheet_column_button_add_label( GTK_SHEET (front->sheet), from, 
				     front->fields[fieldto].name);
  gtk_sheet_column_button_add_label( GTK_SHEET (front->sheet), tocol, 
				     front->fields[fieldfrom].name); 
  gtk_sheet_column_set_justification(GTK_SHEET (front->sheet), from,
				     front->fields [fieldto].justification);
  gtk_sheet_column_set_justification(GTK_SHEET (front->sheet), tocol,
				     front->fields [fieldfrom].justification);

  reset_col_to_field ();

 /* now move the row data */
  for (rowx = 0; rowx <= front->last_row; rowx++) {
     textfromp = gtk_sheet_cell_get_text (GTK_SHEET (front->sheet),
					 rowx, from);
    if (textfromp)
      strcpy (textfrom, textfromp);

    /* if text in the "to" column, move it to the "from" column */
    texttop = gtk_sheet_cell_get_text (GTK_SHEET (front->sheet),
					 rowx, tocol);
    if (texttop)
      gtk_sheet_set_cell (GTK_SHEET (front->sheet), rowx, from, 
			  to_justification, texttop);
    else 
      gtk_sheet_cell_clear (GTK_SHEET (front->sheet), rowx, from);

    /* put the "from" text, if any, into the "to" column */
    if (textfromp)
      gtk_sheet_set_cell (GTK_SHEET (front->sheet), rowx, tocol,
				  from_justification, textfrom);
    else 
      gtk_sheet_cell_clear (GTK_SHEET (front->sheet), rowx, tocol);
  }
  big_draw_end ();
  front_is_changed ();
  gtk_sheet_select_column (GTK_SHEET (front->sheet), tocol);
}

/* ________________________________
   |                                |
   |       type_clicked             |
   |________________________________|
*/
static void type_clicked (GtkObject *object, gpointer entry) {
  if (displaying) /* update_db causes another type_clicked */
    return;

  field_db_curr.type = (GtkJustification) entry;
  field_db_curr.formatting = 0;
  if (field_db_curr.type == FIELD_TYPE_TEXT)
    field_db_curr.justification = GTK_JUSTIFY_LEFT;
  else
    field_db_curr.justification = GTK_JUSTIFY_RIGHT;
  update_field_db ();
}

/* ________________________________
   |                                |
   |       update_field_db          |
   |________________________________|
   This function display the field dialog box. */
void update_field_db () {
  char linebuf [20];
  char* text;

  displaying = TRUE; 

  text = gtk_entry_get_text (GTK_ENTRY (front->entry4));
  if (text && strlen (text) > 0)
    strcpy (field_db_curr.name, text);
  gtk_entry_set_text (GTK_ENTRY (front->entry4), field_db_curr.name);
  if (dialog_mode!= 'E') /* otherwise assume want to enter name */
      gtk_entry_select_region(GTK_ENTRY (front->entry4), 0, 
			      strlen (field_db_curr.name));
  gtk_widget_hide (front->sm_numeric_menu);
  gtk_widget_hide (front->dec_places_label);
  gtk_widget_hide (front->entry1);
  gtk_widget_hide (front->sm_date_menu);
  gtk_widget_hide (front->sm_time_menu);

  switch (field_db_curr.type) {
  case FIELD_TYPE_TEXT:  
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (front->text_button), 
				  TRUE);
    break;
  case FIELD_TYPE_NUMERIC:  
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (front->numeric_button),
				  TRUE);
    gtk_option_menu_set_history (GTK_OPTION_MENU (front->sm_numeric_menu), 
				   field_db_curr.formatting);
    if (field_db_curr.decimal_places >= 0 &&
	field_db_curr.decimal_places < 10) 
      sprintf (linebuf, "%u", field_db_curr.decimal_places);
    else
      strcpy (linebuf, "0");
	       
    gtk_entry_set_text (GTK_ENTRY (front->entry1), linebuf);
    gtk_widget_show (front->sm_numeric_menu);
    gtk_widget_show (front->dec_places_label);
    gtk_widget_show (front->entry1);
    break; 
  case FIELD_TYPE_DATE:  
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (front->date_button), 
				  TRUE);
    gtk_option_menu_set_history (GTK_OPTION_MENU (front->sm_date_menu), 
				   field_db_curr.formatting);
     gtk_widget_show (front->sm_date_menu);
    break;  
  case FIELD_TYPE_TIME:  
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (front->time_button),
				  TRUE);
    gtk_option_menu_set_history (GTK_OPTION_MENU (front->sm_time_menu), 
				   field_db_curr.formatting);
    gtk_widget_show (front->sm_time_menu);
    break;
  }
  switch (field_db_curr.justification) {
  case GTK_JUSTIFY_LEFT:  
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (front->left_button),
				  TRUE);
    break;
  case GTK_JUSTIFY_CENTER:  
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (front->center_button),
				  TRUE);
    break; 
  case GTK_JUSTIFY_RIGHT:  
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (front->right_button), 
				  TRUE);
    break;  
  }
  if (dialog_mode == 'N' && front->last_field >= 0) 
    gtk_widget_show (done_button);

gtk_widget_grab_focus (GTK_WIDGET (front->entry4));
  displaying = FALSE;
}











