#ifndef VISUAL_SPHERE_H
#define VISUAL_SPHERE_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "prim.h"

namespace visual {

class sphere : public Primitive
{
 private:
	double radius;

 public:
	inline sphere() : radius( 1.0) {}
	sphere( const sphere& other) 
		: Primitive( other), radius( other.radius) 
	{}
		
	inline double get_radius()
	{ return radius; }

	void set_radius( double r);

	virtual vector getScale();

	virtual double rayIntersect( const vector &camera, const vector &ray);

	virtual void glRender( rView &view);
};



} // !namespace visual

#endif // !VISUAL_SPHERE_H
