// ------------------------------------------------------------------------- //
// $Id: group.h,v 1.17 2003/09/04 20:49:34 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// ------------------------------------------------------------------------- //

#ifndef _GROUP_H_
#define _GROUP_H_

#include "node.h"

// ------------------------------------------------------------------------- //

//! A Node which can hold child nodes.
/*!
 * The Group is a container version of the Node.
 */

class Group : public Node
{
public:
	Group(const std::string &name);
	~Group();
	virtual void       add(Node* child);
	virtual bool       remove(Node* child);
	virtual Node*      child(int n) { return _children[n]; };
	virtual void       draw_prims(float alpha = 1.0f);
	std::vector<Node*> get_children() { return _children; }
	virtual void       frame_update();
	virtual void       dump_tree(uint indent = 0);
	void set_children(std::vector<Node*> children) { _children = children; }
protected:
	std::vector<Node*> _children;
private:
	typedef std::vector<Node*>::iterator child_iter;
};

#endif /* _GROUP_H_ */

// ------------------------------------------------------------------------- //

