# Copyright 2001 Free Software Foundation, Inc.             -*- Autoconf -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

#
# The macro will define PYTHON_INCLUDES and PYTHON_LIBS
#

AC_DEFUN([AM_PATH_PYTHON_DEV],[
	AM_PATH_PYTHON(2.2)
	AC_MSG_CHECKING(for python $PYTHON_VERSION headers)

	dnl deduce PYTHON_INCLUDES
	py_prefix=`$PYTHON -c "import sys; print sys.prefix"`
	py_exec_prefix=`$PYTHON -c "import sys; print sys.exec_prefix"`
	PYTHON_INCLUDES="-I${py_prefix}/include"
	if test "$py_prefix" != "$py_exec_prefix"; then
		PYTHON_INCLUDES="$PYTHON_INCLUDES -I${py_exec_prefix}/include"
	fi
	dnl check if the headers exist:
	save_CPPFLAGS="$CPPFLAGS"
	CPPFLAGS="$CPPFLAGS $PYTHON_INCLUDES"
	AC_TRY_CPP([#include <python$PYTHON_VERSION/Python.h>],dnl
		[AC_MSG_RESULT(found)
		$1],dnl
		[AC_MSG_ERROR([not found])])

	dnl fake deduction of PYTHON_LIBS 
	## openpty, forkpty is required for python (IA64)
	AC_CHECK_FUNCS(openpty,, AC_CHECK_LIB(util,openpty, [PYTHON_LIBS="-lutil"]))
	AC_CHECK_FUNCS(forkpty,, AC_CHECK_LIB(util,forkpty, [PYTHON_LIBS="-lutil"]))

	## pthread are required on freebsd (python related)
	pthread_libs=""
	AC_CHECK_LIB([pthread],
	     [pthread_create],
	     [pthread_libs="-lpthread"])
	AC_CHECK_LIB([c_r],
	     [pthread_create],
	     [pthread_libs="-lc_r"])
	if test "$pthread_libs"; then
		PYTHON_LIBS="$pthread_libs ${PYTHON_LIBS}"
	fi

	AC_MSG_CHECKING(for python $PYTHON_VERSION libs and linkage)
	changequote(<<, >>)dnl
	py_lib_path=`$PYTHON -c "import sys; print sys.path[1]"`
	changequote([, ])dnl
	dnl note that -L isn't very safe, not all linkers uses -L
	PYTHON_LIBS="${PYTHON_LIBS} -L${py_lib_path}/config -lpython$PYTHON_VERSION"
	save_CXXFLAGS="$CXXFLAGS"
	CXXFLAGS="$CXXFLAGS ${PYTHON_LIBS}"
	AC_TRY_LINK([#include <python$PYTHON_VERSION/Python.h>],dnl
		[static PyObject *tmp],
		[AC_MSG_RESULT(looks good)
		$1],dnl
		[AC_MSG_ERROR([failed])])

	AC_MSG_CHECKING(python import of modules that requires dynamic linkage)
	python_module_linkage=""
	AC_TRY_LINK([#include <python$PYTHON_VERSION/Python.h>],dnl
	[Py_Initialize();
		PyRun_SimpleString("from time import time,ctime\n" "print 'Today is',ctime(time())\n");
		Py_Finalize();
	],
	[AC_MSG_RESULT(looks good)
		python_module_linkage="success"
	],dnl
	[AC_MSG_RESULT(failed)
		python_module_linkage="failed"
	])
	python_module_linkage_hack="failed"
	if test x"$python_module_linkage" = x"failed"; then
		AC_MSG_CHECKING(whether we can find a work-around for the linkage problem)
		if test x"$GXX" = x"yes" || test x"$GCC" = x"yes"; then
			## this hack is only usable for the GNU compiler
			save_LDFLAGS="$LDFLAGS"
			save_LIBS=$LIBS
			LIBS="$LIBS $PYTHON_LIBS" 
			LDFLAGS="$LDFLAGS -Wl,-E"
			AC_TRY_LINK([#include <python$PYTHON_VERSION/Python.h>],dnl
				[Py_Initialize();
				PyRun_SimpleString("from time import time,ctime\n" "print 'Today is',ctime(time())\n");
				Py_Finalize();
				],
				[AC_MSG_RESULT(looks good)
					PYTHON_LDFLAGS="-Wl,-E"
					AC_SUBST(PYTHON_LDFLAGS)
					python_module_linkage_hack="success"
				],dnl
				[python_module_linkage_hack="failed"
				]	
			)
			LIBS="$save_LIBS"
			LDFLAGS="$save_LDFLAGS"
		fi
		if test x"$python_module_linkage_hack" = x"failed"; then
			AC_MSG_RESULT(failed)
			AC_MSG_WARN([you might be able to compile and link pointless
but will probably not be able to run it, please report this event to
pointless-devel@sourceforge.net])
		fi
	fi
	CPPFLAGS="$save_CPPFLAGS"
	CXXFLAGS="$save_CXXFLAGS"
	AC_SUBST(PYTHON_LIBS)
	AC_SUBST(PYTHON_INCLUDES)
])
