/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <stdarg.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include "messenger.h"
#include "reporter.h"

Reporter::Reporter()
{

#ifdef VARIABLE
#  undef VARIABLE
#endif

# define VARIABLE(AA,BB,CC) BB = CC;

#include "reporter.i"

    monthNames[0] = "Jan";
    monthNames[1] = "Feb";
    monthNames[2] = "Mar";
    monthNames[3] = "Apr";
    monthNames[4] = "May";
    monthNames[5] = "Jun";
    monthNames[6] = "Jul";
    monthNames[7] = "Aug";
    monthNames[8] = "Sep";
    monthNames[9] = "Oct";
    monthNames[10] = "Nov";
    monthNames[11] = "Dec";

};


void Reporter::Debug(char *fmt, ...) 
{
    va_list args;

    va_start(args, fmt);
    MESSENGER::Debug(MESSENGER::REPORTER, fmt, args);
    va_end(args);
}

void Reporter::Error(char *fmt, ...) 
{
    char buf[1024];
    va_list args;

    va_start(args, fmt);
    vsprintf(buf, fmt, args);
    va_end(args);
    
    throw ReporterException( buf );
}

void Reporter::Warning(char *fmt, ...) 
{
    va_list args;

    va_start(args, fmt);
    MESSENGER::Warning(fmt, args);
    va_end(args);
}

void Reporter::DoReports( Project *project )
{
    SlippageReport(project);

    if ( text_report != NULL )
	TextReport(project, text_report);

    if ( xml_report != NULL )
	XMLReport(project, xml_report);

    if ( weekly_tex_report != NULL )
	WeeklyReport(project, weekly_tex_report, TEX_REPORT);

    if ( monthly_tex_report != NULL )
	MonthlyReport(project, monthly_tex_report, TEX_REPORT);

    if ( weekly_html_report != NULL )
	WeeklyReport(project, weekly_html_report, HTML_REPORT);
    if ( monthly_html_report != NULL )
	MonthlyReport(project, monthly_html_report, HTML_REPORT);

    if ( weekly_txt_report != NULL )
	WeeklyReport(project, weekly_txt_report, TXT_REPORT);
    if ( monthly_txt_report != NULL )
	MonthlyReport(project, monthly_txt_report, TXT_REPORT);

    if ( tex_report != NULL )
	TexReport(project, tex_report);

    if ( html_report != NULL )
	HTMLReport(project, html_report);

    if ( hard_schedule != NULL )
	HardSchedule(project, hard_schedule);

    if ( util_graph != NULL )
	UtilGraph(project, util_graph);

    for ( vector<TASKGRAPH *>::const_iterator tg = mTaskGraphs.begin() ; 
	  tg != mTaskGraphs.end() ; tg++ )
	TaskGraph(project, (*tg)->start, (*tg)->finish, (*tg)->filename.c_str());

    for ( vector<TASKNET *>::const_iterator pc = mTaskNets.begin() ; 
	  pc != mTaskNets.end() ; pc++ )
	NetworkDiagram(project, (*pc)->start, (*pc)->finish, (*pc)->filename.c_str());

    if ( html_cost_report != NULL )
	CostReport(project, html_cost_report, HTML_REPORT);

    if ( tex_cost_report != NULL )
	CostReport(project, tex_cost_report, TEX_REPORT);
    
}

ReporterException::ReporterException(string reason)
    : OpenschedException(reason)
{
}

ReporterException::~ReporterException()
{
}
