/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include "project.h"

#include <algorithm>

extern "C" {
#include "base.h"
}



Project::Project()
{

#ifdef VARIABLE
#  undef VARIABLE
#endif

# define VARIABLE(AA,BB,CC) BB = CC;

#include "globals.i"
    
    for ( int i = 0; i < MAX_TIME ; i++ )
    {
	days[i].t =  0;
	days[i].s =  NULL;
	days[i].num =  0;
    }

    monthNames[0] = "Jan";
    monthNames[1] = "Feb";
    monthNames[2] = "Mar";
    monthNames[3] = "Apr";
    monthNames[4] = "May";
    monthNames[5] = "Jun";
    monthNames[6] = "Jul";
    monthNames[7] = "Aug";
    monthNames[8] = "Sep";
    monthNames[9] = "Oct";
    monthNames[10] = "Nov";
    monthNames[11] = "Dec";

    dayNames[0] = "Su";
    dayNames[1] = "Mo";
    dayNames[2] = "Tu";
    dayNames[3] = "We";
    dayNames[4] = "Th";
    dayNames[5] = "Fr";
    dayNames[6] = "Sa";
};


Project::~Project()
{
}



MILESTONE * Project::sortedMilestone(int i) 
{ 
    return mSortedMilestoneList[i]; 
}


void Project::SortMilestones()
{
    if ( mSortedMilestoneList.size() != 0 )
	return;
    LoadDays();
    mSortedMilestoneList = mMilestoneList;
    sort( mSortedMilestoneList.begin(), mSortedMilestoneList.end(), CompareMilestoneDates() );
}


double Project::itemCost()
{
    double value = 0.0;
    for ( ITEM::PTRLIST::const_iterator ip = mItems.begin() ; ip != mItems.end() ; ip++)
	value += (*ip)->cost();

    return value;
}


void Project::SortTasks(bool tg_sortbyresource)
{
    if ( mSortedTaskList.size() != 0 )
	return;
    LoadDays();
    mSortedTaskList = mTaskList;
    if ( tg_sortbyresource )
	sort( mSortedTaskList.begin(), mSortedTaskList.end(), CompareTaskResources() );
    else
	sort( mSortedTaskList.begin(), mSortedTaskList.end(), CompareTaskStarts() );
}


