/*
** Copyright (C) 2000 Idan Shoham <idan@m-tech.ab.ca>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include "projectFile.h"

enum myparserstates
  {
  SEARCH,
  OPENQUOTE,
  BACKSLASH,
  INWORD,
  BACKQUOTE,
  PLINVALID
  };

int ProjectFile::ParseLine(char *linebuf, char ***pwords)
{
  char *ptr, *lastptr, **words;
  int state, c;
  int Nwords;

  Nwords = 0;
  state = SEARCH;
  ptr = linebuf;

  lastptr = ptr + strlen(ptr);
  for( ; ptr<lastptr; ++ptr)
    {
    c = *ptr;
    switch(state)
      {
      case SEARCH:
        if( c=='"' )
          {
          ++Nwords;
          state=OPENQUOTE;
          }
        else if( c=='\\' )
          {
          ++Nwords;
          state=BACKSLASH;
          }
        else if( c==' ' || c=='\n' || c=='\t' || c=='\r' )
          ;
        else
          {
          ++Nwords;
          state = INWORD;
          }
        break;

      case OPENQUOTE:
        if( c=='\\' )
          state = BACKQUOTE;
        else if( c=='"' )
          state = SEARCH;
        break;

      case BACKQUOTE:
        state = OPENQUOTE;
        break;

      case BACKSLASH:
        state = INWORD;
        break;

      case INWORD:
        if( c==' ' || c=='\n' || c=='\t' || c=='\r' )
          state = SEARCH;
        break;
      }
    }

  *pwords = words = (char **)malloc(Nwords * sizeof(char*));

  Nwords = 0;
  state = SEARCH;
  ptr = linebuf;

  for( ; ptr<lastptr; ++ptr)
    {
    c = *ptr;
    switch(state)
      {
      case SEARCH:
        if( c=='"' )
          {
          words[Nwords++] = ptr+1;
          state=OPENQUOTE;
          }
        else if( c=='\\' )
          {
          words[Nwords++] = ptr+1;
          state=BACKSLASH;
          }
        else if( c==' ' || c=='\n' || c=='\t' || c=='\r' )
          ;
        else
          {
          words[Nwords++] = ptr;
          state = INWORD;
          }
        break;

      case OPENQUOTE:
        if( c=='\\' )
          state = BACKQUOTE;
        else if( c=='"' )
          {
          *ptr = 0;
          state = SEARCH;
          }
        break;

      case BACKQUOTE:
        state = OPENQUOTE;
        break;

      case BACKSLASH:
        state = INWORD;
        break;

      case INWORD:
        if( c==' ' || c=='\n' || c=='\t' || c=='\r' )
          {
          *ptr = 0;
          state = SEARCH;
          }
        break;
      }
    }

  return Nwords;
  }


#ifdef TEST
void main()
  {
  char *line;
  char **words;
  int Nwords;
  int i;

  line = strdup("one two three");
  printf("Parsing: [%s]\n",line);
  Nwords = ParseLine(line,&words);
  for( i=0; i<Nwords; ++i )
    printf("%3d: [%s]\n",i,words[i]);

  line = strdup("one two \"hi there!!\" three");
  printf("Parsing: [%s]\n",line);
  Nwords = ParseLine(line,&words);
  for( i=0; i<Nwords; ++i )
    printf("%3d: [%s]\n",i,words[i]);

  line = strdup("resource maggie \"Maggie Wong\"");
  printf("Parsing: [%s]\n",line);
  Nwords = ParseLine(line,&words);
  for( i=0; i<Nwords; ++i )
    printf("%3d: [%s]\n",i,words[i]);


  line = strdup("candidate oracle_install idan");
  printf("Parsing: [%s]\n",line);
  Nwords = ParseLine(line,&words);
  for( i=0; i<Nwords; ++i )
    printf("%3d: [%s]\n",i,words[i]);

  }


#endif

