// statuspanel.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// A GUI class containing a changable label and a changable value display.
// Used by the DataView subclasses for display of edit point values.
// See vmessage.h for more.

#ifndef STATUSPANEL_H
#ifdef __GNUG__
#pragma interface
#endif
#define STATUSPANEL_H

#include <InterViews/scene.h>

class VMessage;

class StatusPanel : public MonoScene {
public:
	StatusPanel(const char* label, const char* value);
	StatusPanel(const char* label, int value);
	StatusPanel(const char* label, double value);
	virtual ~StatusPanel() {}
	
	void updateLabel(const char* newlabel);
	void updateValue(const char* newvalue);
	void updateValue(int newvalue);
	void updateValue(double newvalue);
	void updateTime(double newtime);
private:
	void init(const char *);

	VMessage *myLabel;
	VMessage *myValue;
	static char *tempString;
};

#endif
