// outputfunction.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Subclasses of ProcessFunction designed for producing samples rather than
// processing them.  Direct subclasses of this are used for synthesis objects
// (see synthfunction.h).  Other subclasses include the InputOutputFunction
// class (see iofunction.h).
//
// The current class heirarchy here is unsatisfactory, and will be reworked
// in a later version.

#ifndef OUTPUTFUNCTION_H
#ifdef __GNUG__
#pragma interface
#endif
#define OUTPUTFUNCTION_H

#include "localdefs.h"
#include "processfun.h"
#include "queue.h"

class Data;

// an OutputFunction produces samples but takes no samples as input

class OutputFunction : public ProcessFunction {
public:
	OutputFunction(Data* output, bool needsUndo=true) : ProcessFunction(output, needsUndo) {}
	virtual int operator () (double *sig, int len, RunStatus *status) = 0;
protected:
	redefined int doApply(Data *);
};

// a QueuedOutputFunction buffers output data before returning it

class QueuedOutputFunction : public OutputFunction {
public:
	QueuedOutputFunction(Data* output, int queueSize, bool needsUndo=true);
	virtual ~QueuedOutputFunction() {}
	redefined void restoreState();
	redefined int operator () (double *sig, int len, RunStatus *status);
protected:
	virtual RunStatus runProcess();
	virtual int doProcessing() = 0;
	int outQueueEmpty();
	int outQueueFull();
	int addToOutQueue(double *values, int count);
	int takeFromOutQueue(double *values, int count);
	void setOutQueueSize(int size);
private:
	Queue outputQueue;
};

inline int
QueuedOutputFunction::outQueueEmpty() { return outputQueue.empty(); }

inline int
QueuedOutputFunction::outQueueFull() { return outputQueue.full(); }

#endif
