// buttonarray.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// A ButtonArray is a box containing any number of radio or checkbox buttons
// which are either tied to a single ButtonState (if only one at a time may be
// selected) or each to its own ButtonState (if any number may be selected).
// A second, single ButtonState is associated with the ButtonArray, and it is
// the one into which the final state is assigned when the DialogPanel is
// dismissed.

#ifndef BUTTONARRAY_H
#ifdef __GNUG__
#pragma interface
#endif
#define BUTTONARRAY_H

#include <InterViews/scene.h>
#include "localdefs.h"

class ButtonState;
class QueryChoice;

class ButtonArray : public MonoScene {
	typedef MonoScene Super;
public:
	ButtonArray(ButtonState *, QueryChoice *);
	virtual ~ButtonArray();
	redefined void Update();
protected:
    ButtonState* subject;
private:
	void init(ButtonState *, QueryChoice *);
	class ButtonStateLink {
		ButtonState *state;
	public:
		ButtonStateLink *next;
		ButtonStateLink(ButtonState *s) : state(s), next(nil) {}
		virtual ~ButtonStateLink();
		ButtonStateLink *tail();
		void append(ButtonStateLink *b);
		int finalValue();
	};
	ButtonStateLink* stateList;
	QueryChoice* queryChoice;
};

#endif
